/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.plugin;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.tuscany.sdo.generate.JavaGenerator;
import org.apache.tuscany.sdo.generate.XSD2JavaGenerator;
import org.apache.tuscany.sdo.plugin.SchemaFileOption;

public class GeneratorMojo
extends AbstractMojo {
    private String schemaDir;
    private File schemaFile;
    private String javaPackage;
    private String targetDirectory;
    private String prefix;
    private Boolean noInterfaces;
    private Boolean noContainment;
    private Boolean noNotification;
    private Boolean noUnsettable;
    private Boolean generateLoader;
    private Boolean generateSwitch;
    private MavenProject project;
    private List mojos;
    private Boolean interfaceDataObject;
    private SchemaFileOption[] schemaFiles;
    private String schemaNamespace;
    private static final FileFilter FILTER = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isFile() || !pathname.isHidden();
        }
    };

    public void execute() throws MojoExecutionException {
        int i;
        if (null != this.schemaFiles) {
            for (i = 0; i < this.schemaFiles.length; ++i) {
                SchemaFileOption sf = this.schemaFiles[i];
                if (null == sf.getTargetDirectory()) {
                    sf.setTargetDirectory(this.targetDirectory);
                }
                if (null == sf.getJavaPackage()) {
                    sf.setJavaPackage(this.javaPackage);
                }
                if (null == sf.getSchemaNamespace()) {
                    sf.setSchemaNamespace(this.schemaNamespace);
                }
                if (null == sf.isNoInterfaces()) {
                    sf.setNoInterfaces(this.noInterfaces);
                }
                if (null == sf.isNoContainment()) {
                    sf.setNoContainment(this.noContainment);
                }
                if (null == sf.isNoNotification()) {
                    sf.setNoNotification(this.noNotification);
                }
                if (null == sf.isNoUnsettable()) {
                    sf.setNoUnsettable(this.noUnsettable);
                }
                if (null == sf.isGenerateLoader()) {
                    sf.setGenerateLoader(this.generateLoader);
                }
                if (null == sf.isGenerateSwitch()) {
                    sf.setGenerateSwitch(this.generateSwitch);
                }
                if (null == sf.isInterfaceDataObject()) {
                    sf.setInterfaceDataObject(this.interfaceDataObject);
                }
                if (sf.getFileName() == null || sf.getFileName().length() == 0L) {
                    throw new MojoExecutionException("no fileName specfied for schema.");
                }
                if (sf.getFileName().canRead() && sf.getFileName().isFile()) continue;
                throw new MojoExecutionException("file can not be read:" + sf.getFileName());
            }
        } else if (this.schemaFile == null) {
            File[] files = new File(this.schemaDir).listFiles(FILTER);
            this.schemaFiles = new SchemaFileOption[files.length];
            for (int i2 = files.length - 1; i2 > -1; --i2) {
                this.schemaFiles[i2] = new SchemaFileOption();
                this.schemaFiles[i2].setFileName(files[i2]);
                this.schemaFiles[i2].setJavaPackage(this.javaPackage);
                this.schemaFiles[i2].setGenerateLoader(this.generateLoader);
                this.schemaFiles[i2].setGenerateSwitch(this.generateSwitch);
                this.schemaFiles[i2].setNoContainment(this.noContainment);
                this.schemaFiles[i2].setInterfaceDataObject(this.interfaceDataObject);
                this.schemaFiles[i2].setNoInterfaces(this.noInterfaces);
                this.schemaFiles[i2].setNoNotification(this.noNotification);
                this.schemaFiles[i2].setNoUnsettable(this.noUnsettable);
                this.schemaFiles[i2].setPrefix(this.prefix);
                this.schemaFiles[i2].setTargetDirectory(this.targetDirectory);
                this.schemaFiles[i2].setSchemaNamespace(this.schemaNamespace);
            }
        } else {
            this.schemaFiles = new SchemaFileOption[]{new SchemaFileOption()};
            this.schemaFiles[0].setFileName(this.schemaFile);
            this.schemaFiles[0].setJavaPackage(this.javaPackage);
            this.schemaFiles[0].setGenerateLoader(this.generateLoader);
            this.schemaFiles[0].setGenerateSwitch(this.generateSwitch);
            this.schemaFiles[0].setNoContainment(this.noContainment);
            this.schemaFiles[0].setInterfaceDataObject(this.interfaceDataObject);
            this.schemaFiles[0].setNoInterfaces(this.noInterfaces);
            this.schemaFiles[0].setNoNotification(this.noNotification);
            this.schemaFiles[0].setNoUnsettable(this.noUnsettable);
            this.schemaFiles[0].setPrefix(this.prefix);
            this.schemaFiles[0].setTargetDirectory(this.targetDirectory);
            this.schemaFiles[0].setSchemaNamespace(this.schemaNamespace);
        }
        for (i = 0; i < this.schemaFiles.length; ++i) {
            File file = this.schemaFiles[i].getFileName();
            File marker = new File(this.schemaFiles[i].getTargetDirectory(), ".gen#" + file.getName());
            if (file.lastModified() > marker.lastModified()) {
                this.getLog().info((CharSequence)("Generating SDO interfaces from " + file));
                int genOptions = 0;
                if (this.schemaFiles[i].isNoInterfaces() != null && this.schemaFiles[i].isNoInterfaces().booleanValue()) {
                    genOptions |= JavaGenerator.OPTION_NO_INTERFACES;
                }
                if (this.schemaFiles[i].isNoContainment() != null && this.schemaFiles[i].isNoContainment().booleanValue()) {
                    genOptions |= JavaGenerator.OPTION_NO_CONTAINMENT;
                }
                if (this.schemaFiles[i].isNoNotification() != null && this.schemaFiles[i].isNoNotification().booleanValue()) {
                    genOptions |= JavaGenerator.OPTION_NO_NOTIFICATION;
                }
                if (this.schemaFiles[i].isGenerateLoader() != null && this.schemaFiles[i].isGenerateLoader().booleanValue()) {
                    genOptions |= JavaGenerator.OPTION_GENERATE_LOADER;
                }
                if (this.schemaFiles[i].isNoUnsettable() != null && this.schemaFiles[i].isNoUnsettable().booleanValue()) {
                    genOptions |= JavaGenerator.OPTION_NO_UNSETTABLE;
                }
                if (this.schemaFiles[i].isGenerateSwitch() != null && this.schemaFiles[i].isGenerateSwitch().booleanValue()) {
                    genOptions |= JavaGenerator.OPTION_GENERATE_SWITCH;
                }
                if (this.schemaFiles[i].isInterfaceDataObject() != null && this.schemaFiles[i].isInterfaceDataObject().booleanValue()) {
                    genOptions |= JavaGenerator.OPTION_INTERFACE_DO;
                }
                XSD2JavaGenerator.generateFromXMLSchema((String)file.toString(), (String)this.schemaFiles[i].getSchemaNamespace(), (String)this.schemaFiles[i].getTargetDirectory(), (String)this.schemaFiles[i].getJavaPackage(), (String)this.schemaFiles[i].getPrefix(), (int)genOptions);
            }
            try {
                marker.createNewFile();
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage() + "'" + marker.getAbsolutePath() + "'", (Exception)e);
            }
            marker.setLastModified(System.currentTimeMillis());
        }
        this.targetDirectory = this.targetDirectory.replace('/', File.separatorChar);
        MojoDescriptor descriptor = (MojoDescriptor)this.mojos.get(0);
        PluginDescriptor pluginDescriptor = descriptor.getPluginDescriptor();
        Map pluginMap = this.project.getBuild().getPluginsAsMap();
        Plugin plugin = (Plugin)pluginMap.get(pluginDescriptor.getGroupId() + ":" + pluginDescriptor.getArtifactId());
        Iterator i3 = plugin.getExecutions().iterator();
        while (i3.hasNext()) {
            PluginExecution execution = (PluginExecution)i3.next();
            String phase = execution.getPhase();
            if (phase != null && phase.indexOf("-test-") != -1) {
                this.project.addTestCompileSourceRoot(this.targetDirectory);
                continue;
            }
            this.project.addCompileSourceRoot(this.targetDirectory);
        }
    }
}

