/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.xsd.xml;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.common.xml.XMLDocumentHelper;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.DefaultImport;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImport;
import org.apache.tuscany.sca.contribution.processor.ContributionRuntimeException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.xsd.DefaultXSDFactory;
import org.apache.tuscany.sca.xsd.XSDFactory;
import org.apache.tuscany.sca.xsd.XSDefinition;
import org.apache.tuscany.sca.xsd.impl.XSDefinitionImpl;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDModelResolver
implements ModelResolver {
    private static final String AGGREGATED_XSD = "http://tuscany.apache.org/aggregated.xsd";
    private XSDFactory factory;
    private Contribution contribution;
    private Map<String, List<XSDefinition>> map = new HashMap<String, List<XSDefinition>>();
    private XmlSchemaCollection schemaCollection;

    public XSDModelResolver(Contribution contribution, FactoryExtensionPoint modelFactories) {
        this.contribution = contribution;
        this.schemaCollection = new XmlSchemaCollection();
        this.factory = new DefaultXSDFactory();
    }

    public void addModel(Object resolved, ProcessorContext context) {
        XSDefinition definition = (XSDefinition)resolved;
        List<XSDefinition> list = this.map.get(definition.getNamespace());
        if (list == null) {
            list = new ArrayList<XSDefinition>();
            this.map.put(definition.getNamespace(), list);
        }
        list.add(definition);
    }

    public Object removeModel(Object resolved, ProcessorContext context) {
        XSDefinition definition = (XSDefinition)resolved;
        List<XSDefinition> list = this.map.get(definition.getNamespace());
        if (list == null) {
            return null;
        }
        return list.remove(definition);
    }

    public <T> T resolveModel(Class<T> modelClass, T unresolved, ProcessorContext context) {
        int index;
        this.schemaCollection.setSchemaResolver((URIResolver)new URIResolverImpl(this.contribution, context));
        XSDefinition definition = (XSDefinition)unresolved;
        String namespace = definition.getNamespace();
        XSDefinition resolved = null;
        List<XSDefinition> list = this.map.get(namespace);
        XSDefinition modelXSD = null;
        if (list != null && definition.getDocument() != null && (index = list.indexOf(definition)) != -1) {
            modelXSD = list.get(index);
            modelXSD.setDocument(definition.getDocument());
        }
        if (list == null && definition.getDocument() != null) {
            list = new ArrayList<XSDefinition>();
            list.add(definition);
            this.map.put(namespace, list);
        }
        try {
            resolved = this.aggregate(list);
        }
        catch (IOException e) {
            throw new ContributionRuntimeException((Throwable)e);
        }
        if (resolved != null && !resolved.isUnresolved()) {
            if (definition.isUnresolved() && definition.getSchema() == null && modelXSD != null) {
                definition.setSchema(modelXSD.getSchema());
                definition.setSchemaCollection(modelXSD.getSchemaCollection());
                definition.setUnresolved(false);
            }
            return modelClass.cast(resolved);
        }
        return modelClass.cast(unresolved);
    }

    private void loadOnDemand(XSDefinition definition) throws IOException {
        if (definition.getSchema() != null) {
            return;
        }
        if (definition.getDocument() != null) {
            String uri = null;
            if (definition.getLocation() != null) {
                uri = definition.getLocation().toString();
            }
            XmlSchema schema = this.schemaCollection.read(definition.getDocument(), uri, null);
            definition.setSchemaCollection(this.schemaCollection);
            definition.setSchema(schema);
            definition.setUnresolved(false);
        } else if (definition.getLocation() != null) {
            if (definition.getLocation().getFragment() != null) {
                return;
            }
            XmlSchema schema = null;
            XmlSchema[] xmlSchemaArray = this.schemaCollection.getXmlSchemas();
            int n = xmlSchemaArray.length;
            int n2 = 0;
            while (n2 < n) {
                XmlSchema d = xmlSchemaArray[n2];
                if (d.getTargetNamespace().equals(definition.getNamespace()) && d.getSourceURI().equals(definition.getLocation().toString())) {
                    schema = d;
                    break;
                }
                ++n2;
            }
            if (schema == null) {
                InputSource xsd = XMLDocumentHelper.getInputSource((URL)definition.getLocation().toURL());
                schema = this.schemaCollection.read(xsd, null);
            }
            definition.setSchemaCollection(this.schemaCollection);
            definition.setSchema(schema);
        }
    }

    private XSDefinition aggregate(List<XSDefinition> definitions) throws IOException {
        if (definitions == null || definitions.size() == 0) {
            return null;
        }
        if (definitions.size() == 1) {
            XSDefinition d = definitions.get(0);
            this.loadOnDemand(d);
            return d;
        }
        XSDefinition aggregated = this.factory.createXSDefinition();
        for (XSDefinition d : definitions) {
            this.loadOnDemand(d);
        }
        String ns = definitions.get(0).getNamespace();
        XmlSchema facade = null;
        XmlSchema[] xmlSchemaArray = this.schemaCollection.getXmlSchema(AGGREGATED_XSD);
        int n = xmlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XmlSchema s = xmlSchemaArray[n2];
            if (ns.equals(s.getTargetNamespace())) {
                facade = s;
                break;
            }
            ++n2;
        }
        if (facade == null) {
            facade = new XmlSchema(ns, AGGREGATED_XSD, this.schemaCollection);
        }
        xmlSchemaArray = this.schemaCollection.getXmlSchemas();
        n = xmlSchemaArray.length;
        n2 = 0;
        while (n2 < n) {
            XmlSchema d = xmlSchemaArray[n2];
            if (ns.equals(d.getTargetNamespace()) && d != facade) {
                XmlSchemaInclude include = new XmlSchemaInclude();
                include.setSchema(d);
                include.setSourceURI(d.getSourceURI());
                include.setSchemaLocation(d.getSourceURI());
                facade.getIncludes().add((XmlSchemaObject)include);
                facade.getItems().add((XmlSchemaObject)include);
            }
            ++n2;
        }
        aggregated.setUnresolved(true);
        aggregated.setSchema(facade);
        aggregated.setNamespace(ns);
        aggregated.setAggregatedDefinitions(definitions);
        aggregated.setUnresolved(false);
        return aggregated;
    }

    public static class URIResolverImpl
    implements URIResolver {
        private Contribution contribution;
        private ProcessorContext context;

        public URIResolverImpl(Contribution contribution, ProcessorContext context) {
            this.contribution = contribution;
            this.context = context;
        }

        public InputSource resolveEntity(String targetNamespace, String schemaLocation, String baseUri) {
            block11: {
                if (schemaLocation != null) break block11;
                return null;
            }
            try {
                NamespaceImport namespaceImport;
                URL url = null;
                XSDefinition resolved = null;
                XSDefinitionImpl unresolved = new XSDefinitionImpl();
                unresolved.setUnresolved(true);
                unresolved.setLocation(new URI(schemaLocation));
                unresolved.setNamespace(targetNamespace);
                ArrayList<String> locations = new ArrayList<String>();
                HashMap<String, NamespaceImport> locationMap = new HashMap<String, NamespaceImport>();
                for (Import import_ : this.contribution.getImports()) {
                    if (import_ instanceof NamespaceImport) {
                        namespaceImport = (NamespaceImport)import_;
                        if (!namespaceImport.getNamespace().equals(targetNamespace)) continue;
                        if (namespaceImport.getLocation() == null) {
                            resolved = (XSDefinition)namespaceImport.getModelResolver().resolveModel(XSDefinition.class, (Object)unresolved, this.context);
                            if (resolved.isUnresolved()) continue;
                            return XMLDocumentHelper.getInputSource((URL)resolved.getLocation().toURL());
                        }
                        locations.add(namespaceImport.getLocation());
                        locationMap.put(namespaceImport.getLocation(), namespaceImport);
                        continue;
                    }
                    if (!(import_ instanceof DefaultImport) || (resolved = (XSDefinition)import_.getModelResolver().resolveModel(XSDefinition.class, (Object)unresolved, this.context)).isUnresolved()) continue;
                    return XMLDocumentHelper.getInputSource((URL)resolved.getLocation().toURL());
                }
                Collections.sort(locations);
                for (String location : locations) {
                    namespaceImport = (NamespaceImport)locationMap.get(location);
                    resolved = (XSDefinition)namespaceImport.getModelResolver().resolveModel(XSDefinition.class, (Object)unresolved, this.context);
                    if (resolved.isUnresolved()) continue;
                    return XMLDocumentHelper.getInputSource((URL)resolved.getLocation().toURL());
                }
                if (schemaLocation.startsWith("/")) {
                    String uri = schemaLocation.substring(1);
                    for (Artifact a : this.contribution.getArtifacts()) {
                        if (!a.getURI().equals(uri)) continue;
                        url = new URL(a.getLocation());
                        break;
                    }
                } else {
                    url = new URL(new URL(baseUri), schemaLocation);
                }
                return XMLDocumentHelper.getInputSource((URL)url);
            }
            catch (IOException iOException) {
                return new InputSource(schemaLocation);
            }
            catch (URISyntaxException uRISyntaxException) {
                return new InputSource(schemaLocation);
            }
        }
    }
}

