/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.xsd.xml;

import java.net.URI;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import org.apache.tuscany.sca.common.xml.stax.StAXHelper;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.xsd.XSDFactory;
import org.apache.tuscany.sca.xsd.XSDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDDocumentProcessor
implements URLArtifactProcessor<XSDefinition> {
    private StAXHelper helper;
    private XSDFactory factory;
    private XMLInputFactory inputFactory;
    public static final QName XSD = new QName("http://www.w3.org/2001/XMLSchema", "schema");

    public XSDDocumentProcessor(ExtensionPointRegistry registry, StAXArtifactProcessor processor) {
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.factory = (XSDFactory)modelFactories.getFactory(XSDFactory.class);
        this.inputFactory = (XMLInputFactory)modelFactories.getFactory(XMLInputFactory.class);
        this.helper = StAXHelper.getInstance((ExtensionPointRegistry)registry);
    }

    private void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "xsd-xml-validation-messages", Problem.Severity.ERROR, model, message, (Throwable)ex);
            monitor.problem(problem);
        }
    }

    public XSDefinition read(URL contributionURL, URI artifactURI, URL artifactURL, ProcessorContext context) throws ContributionReadException {
        try {
            return this.indexRead(artifactURL);
        }
        catch (Exception e) {
            ContributionReadException ce = new ContributionReadException((Throwable)e);
            this.error(context.getMonitor(), "ContributionReadException", artifactURL, (Exception)ce);
            throw ce;
        }
    }

    public void resolve(XSDefinition model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
    }

    public String getArtifactType() {
        return ".xsd";
    }

    public Class<XSDefinition> getModelType() {
        return XSDefinition.class;
    }

    protected XSDefinition indexRead(URL doc) throws Exception {
        XSDefinition xsd = this.factory.createXSDefinition();
        xsd.setUnresolved(true);
        xsd.setNamespace(this.helper.readAttribute(doc, XSD, "targetNamespace"));
        xsd.setLocation(doc.toURI());
        xsd.setUnresolved(false);
        return xsd;
    }
}

