/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.xsd.impl;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.xsd.XSDefinition;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDefinitionImpl
implements XSDefinition {
    private XmlSchemaCollection schemaCollection = new XmlSchemaCollection();
    private XmlSchema schema;
    private String namespace;
    private URI location;
    private Document document;
    private boolean unresolved;
    private List<XSDefinition> definitions;

    @Override
    public XmlSchema getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(XmlSchema definition) {
        this.schema = definition;
    }

    public boolean isUnresolved() {
        return this.unresolved;
    }

    public void setUnresolved(boolean undefined) {
        this.unresolved = undefined;
    }

    @Override
    public String getNamespace() {
        if (this.isUnresolved()) {
            return this.namespace;
        }
        if (this.schema != null) {
            return this.schema.getTargetNamespace();
        }
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        if (!this.isUnresolved()) {
            throw new IllegalStateException();
        }
        this.namespace = namespace;
    }

    @Override
    public URI getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(URI location) {
        this.location = location;
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(Document document) {
        this.document = document;
    }

    @Override
    public XmlSchemaCollection getSchemaCollection() {
        return this.schemaCollection;
    }

    @Override
    public void setSchemaCollection(XmlSchemaCollection schemaCollection) {
        this.schemaCollection = schemaCollection;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XSDefinitionImpl)) {
            return false;
        }
        XSDefinitionImpl other = (XSDefinitionImpl)obj;
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        return !(this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace));
    }

    private static <T extends XmlSchemaObject> T getXmlSchemaObject(XmlSchema schema, QName name, Class<T> type) {
        if (schema != null) {
            Object object = null;
            if (type == XmlSchemaElement.class) {
                object = schema.getElementByName(name);
            } else if (type == XmlSchemaType.class) {
                object = schema.getTypeByName(name);
            }
            if (object != null) {
                return (T)((XmlSchemaObject)type.cast(object));
            }
            Iterator i = schema.getIncludes().getIterator();
            while (i.hasNext()) {
                XmlSchemaObject obj = (XmlSchemaObject)i.next();
                XmlSchema ext = null;
                if (obj instanceof XmlSchemaInclude) {
                    ext = ((XmlSchemaInclude)obj).getSchema();
                }
                if (obj instanceof XmlSchemaImport) {
                    ext = ((XmlSchemaImport)obj).getSchema();
                }
                if ((object = XSDefinitionImpl.getXmlSchemaObject(ext, name, type)) == null) continue;
                return (T)((XmlSchemaObject)type.cast(object));
            }
        }
        return null;
    }

    @Override
    public XmlSchemaElement getXmlSchemaElement(QName name) {
        XmlSchemaElement element;
        if (this.schema != null && (element = XSDefinitionImpl.getXmlSchemaObject(this.schema, name, XmlSchemaElement.class)) != null) {
            return element;
        }
        if (this.schemaCollection != null) {
            return this.schemaCollection.getElementByQName(name);
        }
        return null;
    }

    @Override
    public XmlSchemaType getXmlSchemaType(QName name) {
        XmlSchemaType type;
        if (this.schema != null && (type = XSDefinitionImpl.getXmlSchemaObject(this.schema, name, XmlSchemaType.class)) != null) {
            return type;
        }
        if (this.schemaCollection != null) {
            return this.schemaCollection.getTypeByQName(name);
        }
        return null;
    }

    @Override
    public List<XSDefinition> getAggregatedDefinitions() {
        return this.definitions;
    }

    @Override
    public void setAggregatedDefinitions(List<XSDefinition> definitions) {
        this.definitions = definitions;
    }
}

