/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.client.impl;

import java.util.Iterator;
import java.util.List;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.client.impl.EndpointFinder;
import org.apache.tuscany.sca.runtime.DomainRegistry;
import org.oasisopen.sca.NoSuchServiceException;
import org.oasisopen.sca.ServiceRuntimeException;

public class DefaultEndpointFinder
implements EndpointFinder {
    protected boolean onlySCABinding;

    @Override
    public Endpoint findEndpoint(DomainRegistry domainRegistry, String serviceName) throws NoSuchServiceException {
        List eps = domainRegistry.findEndpoint(serviceName);
        if (eps == null || eps.size() < 1) {
            throw new NoSuchServiceException(serviceName);
        }
        Iterator iterator = eps.iterator();
        while (iterator.hasNext()) {
            Endpoint ep = (Endpoint)iterator.next();
            if (!ep.getService().isForCallback()) continue;
            iterator.remove();
        }
        if (serviceName.indexOf(47) == -1 && eps.size() > 1) {
            ComponentService firstService = ((Endpoint)eps.get(0)).getService();
            for (int i = 1; i < eps.size(); ++i) {
                if (firstService == ((Endpoint)eps.get(i)).getService()) continue;
                throw new ServiceRuntimeException("More than one service is declared on component " + serviceName + ". Service name is required to get the service.");
            }
        }
        for (Endpoint ep : eps) {
            if (!SCABinding.TYPE.equals(ep.getBinding().getType())) continue;
            return ep;
        }
        if (this.onlySCABinding) {
            throw new NoSuchServiceException(serviceName + " not found using binding.sca");
        }
        return (Endpoint)eps.get(0);
    }
}

