/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.tools.wsdl2java.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sdo.helper.SDOXSDEcoreBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLNameUtil {
    public static String getJavaNameFromXMLName(String name, boolean isUpperCase) {
        List<String> parsedName = XMLNameUtil.parseName(name, '_');
        StringBuilder result = new StringBuilder(64 * parsedName.size());
        for (String nameComponent : parsedName) {
            if (nameComponent.length() <= 0) continue;
            if (result.length() > 0 || isUpperCase) {
                result.append(Character.toUpperCase(nameComponent.charAt(0)));
                result.append(nameComponent.substring(1));
                continue;
            }
            result.append(nameComponent);
        }
        if (result.length() == 0) {
            return "_";
        }
        if (Character.isJavaIdentifierStart(result.charAt(0))) {
            return isUpperCase ? result.toString() : XMLNameUtil.decapitalizeName(result.toString());
        }
        return "_" + result;
    }

    public static String decapitalizeName(String name) {
        int i;
        if (name.length() == 0) {
            return name;
        }
        String lowerName = name.toLowerCase();
        for (i = 0; i < name.length() && name.charAt(i) != lowerName.charAt(i); ++i) {
        }
        if (i > 1 && i < name.length()) {
            --i;
        }
        return name.substring(0, i).toLowerCase() + name.substring(i);
    }

    private static List<String> parseName(String sourceName, char separator) {
        ArrayList<String> result = new ArrayList<String>();
        if (sourceName != null) {
            StringBuilder currentWord = new StringBuilder(64);
            boolean lastIsLower = false;
            int length = sourceName.length();
            for (int index = 0; index < length; ++index) {
                char curChar = sourceName.charAt(index);
                if (!Character.isJavaIdentifierPart(curChar)) {
                    curChar = separator;
                }
                if (Character.isUpperCase(curChar) || !lastIsLower && Character.isDigit(curChar) || curChar == separator) {
                    if (lastIsLower && currentWord.length() > 1 || curChar == separator && currentWord.length() > 0) {
                        result.add(currentWord.toString());
                        currentWord = new StringBuilder(64);
                    }
                    lastIsLower = false;
                } else {
                    int currentWordLength;
                    if (!lastIsLower && (currentWordLength = currentWord.length()) > 1) {
                        char lastChar = currentWord.charAt(--currentWordLength);
                        currentWord.setLength(currentWordLength);
                        result.add(currentWord.toString());
                        currentWord = new StringBuilder(64);
                        currentWord.append(lastChar);
                    }
                    lastIsLower = true;
                }
                if (curChar == separator) continue;
                currentWord.append(curChar);
            }
            result.add(currentWord.toString());
        }
        return result;
    }

    public static String getPackageNameFromNamespace(String namespace) {
        return SDOXSDEcoreBuilder.getDefaultPackageName((String)namespace);
    }
}

