/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.tools.wsdl2java.generate;

import com.sun.tools.xjc.api.XJC;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.util.FileWriter;
import org.apache.axis2.util.XMLUtils;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.codegen.extension.CodeGenExtension;
import org.apache.axis2.wsdl.codegen.extension.DefaultDatabindingExtension;
import org.apache.axis2.wsdl.codegen.extension.PackageFinder;
import org.apache.axis2.wsdl.codegen.extension.WSDLValidatorExtension;
import org.apache.axis2.wsdl.databinding.JavaTypeMapper;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.tuscany.tools.wsdl2java.generate.JavaInterfaceEmitter;
import org.apache.tuscany.tools.wsdl2java.generate.SDODataBindingCodegenExtension;
import org.apache.tuscany.tools.wsdl2java.generate.SDODataBindingTypeMappingEntry;
import org.apache.tuscany.tools.wsdl2java.generate.WSDL2JavaGenerator;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaInterfaceGenerator {
    private List codegenExtensions = new ArrayList();
    private List<CodeGenConfiguration> codegenConfigurations = new LinkedList<CodeGenConfiguration>();
    private String outputLocation;

    public JavaInterfaceGenerator(String uri, String[] ports, String outputLocation, String packageName, Map<QName, SDODataBindingTypeMappingEntry> typeMapping) throws CodeGenerationException {
        Definition definition;
        this.outputLocation = outputLocation;
        try {
            definition = this.readWSDL(uri);
        }
        catch (WSDLException e) {
            throw new CodeGenerationException((Throwable)e);
        }
        HashSet<String> interestedPorts = ports == null ? null : new HashSet<String>(Arrays.asList(ports));
        HashSet<QName> donePortTypes = new HashSet<QName>();
        for (Service service : definition.getServices().values()) {
            QName serviceQname = service.getQName();
            for (Port port : service.getPorts().values()) {
                AxisService axisService;
                QName pQName;
                PortType portType;
                if (interestedPorts != null && !interestedPorts.contains(port.getName()) || null == (portType = this.getPortType(port)) || donePortTypes.contains(pQName = portType.getQName())) continue;
                donePortTypes.add(pQName);
                if (packageName == null) {
                    packageName = XJC.getDefaultPackageName((String)definition.getTargetNamespace());
                }
                this.generateFaults(packageName, portType, typeMapping);
                JavaTypeMapper typeMapper = new JavaTypeMapper();
                for (Map.Entry<QName, SDODataBindingTypeMappingEntry> e : typeMapping.entrySet()) {
                    typeMapper.addTypeMappingObject(e.getKey(), (Object)e.getValue());
                    typeMapper.addTypeMappingName(e.getKey(), e.getValue().getClassName());
                }
                try {
                    WSDL11ToAxisServiceBuilder builder = new WSDL11ToAxisServiceBuilder(definition, serviceQname, port.getName());
                    builder.setCodegen(true);
                    axisService = builder.populateService();
                }
                catch (AxisFault e) {
                    throw new CodeGenerationException((Throwable)e);
                }
                axisService.setName(port.getBinding().getPortType().getQName().getLocalPart());
                CodeGenConfiguration codegenConfiguration = new CodeGenConfiguration(Collections.EMPTY_MAP);
                this.codegenConfigurations.add(codegenConfiguration);
                codegenConfiguration.setAxisService(axisService);
                codegenConfiguration.setAdvancedCodeGenEnabled(false);
                codegenConfiguration.setAsyncOn(false);
                codegenConfiguration.setDatabindingType("sdo");
                codegenConfiguration.setGenerateAll(true);
                codegenConfiguration.setGenerateDeployementDescriptor(false);
                codegenConfiguration.setOutputLanguage("java");
                codegenConfiguration.setOutputLocation(new File(outputLocation));
                codegenConfiguration.setPackageName(packageName);
                codegenConfiguration.setPackClasses(false);
                codegenConfiguration.setPolicyMap(Collections.EMPTY_MAP);
                codegenConfiguration.setPortName(port.getName());
                codegenConfiguration.setServerSide(false);
                codegenConfiguration.setServiceName(service.getQName().getLocalPart());
                codegenConfiguration.setSyncOn(true);
                codegenConfiguration.setTypeMapper((TypeMapper)typeMapper);
                codegenConfiguration.setSkipMessageReceiver(true);
                codegenConfiguration.setWriteTestCase(false);
                this.addExtension((CodeGenExtension)new WSDLValidatorExtension(), codegenConfiguration);
                this.addExtension((CodeGenExtension)new PackageFinder(), codegenConfiguration);
                this.addExtension((CodeGenExtension)new SDODataBindingCodegenExtension((TypeMapper)typeMapper), codegenConfiguration);
                this.addExtension((CodeGenExtension)new DefaultDatabindingExtension(), codegenConfiguration);
            }
        }
    }

    private PortType getPortType(Port port) {
        Binding binding = port.getBinding();
        if (null != binding) {
            return binding.getPortType();
        }
        return null;
    }

    private void addExtension(CodeGenExtension ext, CodeGenConfiguration codegenConfiguration) {
        this.codegenExtensions.add(new Object[]{ext, codegenConfiguration});
    }

    public void generate() throws CodeGenerationException {
        try {
            for (int i = 0; i < this.codegenExtensions.size(); ++i) {
                Object[] pair = (Object[])this.codegenExtensions.get(i);
                CodeGenExtension cge = (CodeGenExtension)pair[0];
                CodeGenConfiguration cgf = (CodeGenConfiguration)pair[1];
                cge.engage(cgf);
            }
            for (CodeGenConfiguration codegenConfiguration : this.codegenConfigurations) {
                JavaInterfaceEmitter emitter = new JavaInterfaceEmitter();
                emitter.setCodeGenConfiguration(codegenConfiguration);
                emitter.setMapper(codegenConfiguration.getTypeMapper());
                emitter.writeInterface(false);
            }
        }
        catch (Exception e) {
            throw new CodeGenerationException((Throwable)e);
        }
    }

    private Definition readWSDL(String uri) throws WSDLException {
        Document doc;
        String baseURI;
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.importDocuments", true);
        File file = new File(uri);
        if (uri.startsWith("http://")) {
            baseURI = uri;
        } else if (file.getParentFile() == null) {
            try {
                baseURI = new File(".").getCanonicalFile().toURI().toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            baseURI = file.getParentFile().toURI().toString();
        }
        try {
            doc = XMLUtils.newDocument((String)uri);
        }
        catch (ParserConfigurationException e) {
            throw new WSDLException("PARSER_ERROR", "Parser Configuration Error", (Throwable)e);
        }
        catch (SAXException e) {
            throw new WSDLException("PARSER_ERROR", "Parser SAX Error", (Throwable)e);
        }
        catch (IOException e) {
            throw new WSDLException("INVALID_WSDL", "IO Error", (Throwable)e);
        }
        return reader.readWSDL(baseURI, doc);
    }

    private void generateFaults(String packageName, PortType portType, Map<QName, SDODataBindingTypeMappingEntry> typeMapping) throws CodeGenerationException {
        for (Object o : portType.getOperations()) {
            Operation op = (Operation)o;
            Map messageMap = op.getFaults();
            for (Fault fault : messageMap.values()) {
                Message faultMsg = fault.getMessage();
                Iterator iter2 = faultMsg.getParts().values().iterator();
                Part faultMsgPart = (Part)iter2.next();
                QName faultMsgQName = faultMsg.getQName();
                QName faultMsgPartElementQName = faultMsgPart.getElementName();
                String faultClassName = typeMapping.get(faultMsgPartElementQName).getClassName();
                this.writeException(packageName, faultMsgQName, faultClassName, faultMsgPartElementQName);
            }
        }
    }

    private void writeException(String packageName, QName faultMsgQName, String faultClassName, QName faultMsgPartElementQName) throws CodeGenerationException {
        try {
            String faultWrapperClassName = WSDL2JavaGenerator.normalizeClassName(faultMsgQName.getLocalPart());
            File outputDir = new File(this.outputLocation);
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            File outputFile = FileWriter.createClassFile((File)outputDir, (String)packageName, (String)faultWrapperClassName, (String)".java");
            FileOutputStream fileStream = new FileOutputStream(outputFile);
            PrintStream stream = new PrintStream(fileStream);
            System.out.println(">>  Generating Java exception class " + packageName + "." + faultWrapperClassName);
            stream.println();
            stream.println("package " + packageName + ";");
            stream.println();
            stream.println("import javax.xml.ws.WebFault;");
            stream.println();
            stream.println("@WebFault(name=\"" + faultMsgPartElementQName.getLocalPart() + "\", targetNamespace=\"" + faultMsgPartElementQName.getNamespaceURI() + "\")");
            stream.println("public class " + faultWrapperClassName + " extends Exception {");
            stream.println();
            stream.println("    private " + faultClassName + " fault;");
            stream.println();
            stream.println("    public " + faultWrapperClassName + "(String message, " + faultClassName + " fault) {");
            stream.println("        super(message);");
            stream.println("        this.fault = fault;");
            stream.println("    }");
            stream.println();
            stream.println("    public " + faultWrapperClassName + "(String message, " + faultClassName + " fault, Throwable cause) {");
            stream.println("        super(message, cause);");
            stream.println("        this.fault = fault;");
            stream.println("    }");
            stream.println();
            stream.println("    public " + faultClassName + " getFaultInfo() {");
            stream.println("        return this.fault;");
            stream.println("    }");
            stream.println("}");
            stream.println();
        }
        catch (Exception e) {
            throw new CodeGenerationException((Throwable)e);
        }
    }
}

