/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.tools.wsdl2java.generate;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.util.FileWriter;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.emitter.JavaEmitter;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.tuscany.tools.wsdl2java.generate.RemotableInterfaceWritter;
import org.apache.tuscany.tools.wsdl2java.generate.SDODataBindingTypeMappingEntry;
import org.apache.tuscany.tools.wsdl2java.generate.WSDL2JavaGenerator;
import org.apache.tuscany.tools.wsdl2java.util.XMLNameUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JavaInterfaceEmitter
extends JavaEmitter {
    private CodeGenConfiguration codegenConfiguration;
    private TypeMapper typeMapper;

    public void setCodeGenConfiguration(CodeGenConfiguration configuration) {
        super.setCodeGenConfiguration(configuration);
        this.codegenConfiguration = configuration;
    }

    public void setMapper(TypeMapper typeMapper) {
        super.setMapper(typeMapper);
        this.typeMapper = typeMapper;
    }

    private List getParameterElementList(Document doc, AxisMessage message, boolean wrapped) {
        ArrayList<Element> parameterElementList = new ArrayList<Element>();
        if (message != null && message.getElementQName() != null) {
            List<String> typeMappings;
            SDODataBindingTypeMappingEntry typeMappingEntry = (SDODataBindingTypeMappingEntry)this.typeMapper.getTypeMappingObject(message.getElementQName());
            if (wrapped) {
                typeMappings = typeMappingEntry.getPropertyClassNames();
                if (typeMappings == null) {
                    typeMappings = new ArrayList<String>();
                    typeMappings.add(typeMappingEntry.getClassName());
                }
            } else {
                typeMappings = new ArrayList<String>();
                typeMappings.add(typeMappingEntry.getClassName());
            }
            for (int i = 0; i < typeMappings.size(); ++i) {
                Element param = doc.createElement("param");
                parameterElementList.add(param);
                String typeMapping = typeMappings.get(i);
                this.addAttribute(doc, "name", this.typeMapper.getParameterName(message.getElementQName()), param);
                this.addAttribute(doc, "type", typeMapping == null ? "" : typeMapping, param);
                if (this.typeMapper.getDefaultMappingName().equals(typeMapping)) {
                    this.addAttribute(doc, "default", "yes", param);
                }
                this.addAttribute(doc, "value", null, param);
                this.addAttribute(doc, "location", "body", param);
            }
        }
        return parameterElementList;
    }

    public List getParameterElementList(Document doc, List parameters, String location) {
        ArrayList<Element> parameterElementList = new ArrayList<Element>();
        if (parameters != null && !parameters.isEmpty()) {
            int count = parameters.size();
            for (int i = 0; i < count; ++i) {
                Element param = doc.createElement("param");
                QName name = (QName)parameters.get(i);
                this.addAttribute(doc, "name", this.typeMapper.getParameterName(name), param);
                String typeMapping = this.typeMapper.getTypeMappingName(name);
                String typeMappingStr = typeMapping == null ? "" : typeMapping;
                this.addAttribute(doc, "type", typeMappingStr, param);
                this.addAttribute(doc, "location", location, param);
                parameterElementList.add(param);
            }
        }
        return parameterElementList;
    }

    protected Element getInputElement(Document doc, AxisBindingOperation operation, List headerParameterQNameList) {
        return this.getElement(doc, "input", operation.getAxisOperation().getMessage("In"), operation.getAxisOperation().getMessage("In").isWrapped(), headerParameterQNameList);
    }

    protected Element getOutputElement(Document doc, AxisBindingOperation operation, List headerParameterQNameList) {
        return this.getElement(doc, "output", operation.getAxisOperation().getMessage("Out"), operation.getAxisOperation().getMessage("Out").isWrapped(), headerParameterQNameList);
    }

    protected Element getElement(Document doc, String elementName, AxisMessage message, boolean wrapped, List headerParameterQNameList) {
        Element element = doc.createElement(elementName);
        List parameterElementList = this.getParameterElementList(doc, message, wrapped);
        for (int i = 0; i < parameterElementList.size(); ++i) {
            element.appendChild((Element)parameterElementList.get(i));
        }
        List outputElementList = this.getParameterElementList(doc, headerParameterQNameList, "header");
        for (int i = 0; i < outputElementList.size(); ++i) {
            element.appendChild((Element)outputElementList.get(i));
        }
        return element;
    }

    protected void writeInterface(boolean writeDatabinders) throws Exception {
        Document interfaceModel = this.createDOMDocumentForInterface(writeDatabinders);
        if (!this.codegenConfiguration.getOutputLocation().exists()) {
            this.codegenConfiguration.getOutputLocation().mkdirs();
        }
        RemotableInterfaceWritter interfaceWriter = new RemotableInterfaceWritter(this.codegenConfiguration.getOutputLocation(), this.codegenConfiguration.getOutputLanguage());
        String packageName = interfaceModel.getDocumentElement().getAttribute("package");
        String className = interfaceModel.getDocumentElement().getAttribute("name");
        System.out.println(">>  Generating Java class " + packageName + "." + className);
        File outputFile = FileWriter.createClassFile((File)this.codegenConfiguration.getOutputLocation(), (String)packageName, (String)className, (String)".java");
        if (outputFile.exists()) {
            outputFile.delete();
        }
        this.writeFile(interfaceModel, (org.apache.axis2.wsdl.codegen.writer.FileWriter)interfaceWriter);
    }

    protected String makeJavaClassName(String word) {
        return XMLNameUtil.getJavaNameFromXMLName(word, true);
    }

    protected Element[] getFaultParamElements(Document doc, AxisOperation operation) {
        ArrayList<Element> params = new ArrayList<Element>();
        ArrayList faultMessages = operation.getFaultMessages();
        if (faultMessages != null && !faultMessages.isEmpty()) {
            for (int i = 0; i < faultMessages.size(); ++i) {
                Element paramElement = doc.createElement("param");
                AxisMessage msg = (AxisMessage)faultMessages.get(i);
                String msgClassName = WSDL2JavaGenerator.normalizeClassName(msg.getName());
                this.addAttribute(doc, "name", msgClassName, paramElement);
                params.add(paramElement);
            }
            return params.toArray(new Element[params.size()]);
        }
        return new Element[0];
    }
}

