/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.generate;

import commonj.sdo.helper.XSDHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.tuscany.sdo.generate.XSD2JavaGenerator;
import org.apache.tuscany.sdo.generate.adapter.SDOGenModelGeneratorAdapterFactory;
import org.apache.tuscany.sdo.helper.HelperContextImpl;
import org.apache.tuscany.sdo.impl.SDOPackageImpl;
import org.apache.tuscany.sdo.model.ModelFactory;
import org.apache.tuscany.sdo.model.internal.InternalFactory;
import org.apache.tuscany.sdo.util.DataObjectUtil;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenDelegationKind;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenResourceKind;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenModelGeneratorAdapterFactory;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.xsd.XSDSchema;

public abstract class JavaGenerator {
    public static int OPTION_NO_INTERFACES = 1;
    public static int OPTION_SPARSE_PATTERN = 2;
    public static int OPTION_STORE_PATTERN = 4;
    public static int OPTION_NO_CONTAINMENT = 8;
    public static int OPTION_NO_NOTIFICATION = 16;
    public static int OPTION_ARRAY_ACCESSORS = 32;
    public static int OPTION_GENERATE_LOADER = 64;
    public static int OPTION_NO_UNSETTABLE = 128;
    public static int OPTION_GENERATE_SWITCH = 256;
    public static int OPTION_INTERFACE_DO = 1024;
    public static int OPTION_NO_GENERATE = 2048;
    protected String targetDirectory = null;
    protected String javaPackage = null;
    protected String prefix = null;
    protected int genOptions = 0;
    protected String xsdFileName;
    protected int inputIndex;

    public static void main(String[] args) {
        try {
            XSD2JavaGenerator generator = new XSD2JavaGenerator();
            generator.processArguments(args);
            ((JavaGenerator)generator).run(args);
        }
        catch (IllegalArgumentException e) {
            JavaGenerator.printUsage();
        }
    }

    protected void processArguments(String[] args) {
        if (args.length == 0) {
            throw new IllegalArgumentException();
        }
        int index = 0;
        while (args[index].startsWith("-")) {
            int newIndex = this.handleArgument(args, index);
            if (newIndex == index) {
                throw new IllegalArgumentException();
            }
            index = newIndex;
            if (index != args.length) continue;
            throw new IllegalArgumentException();
        }
        this.inputIndex = index;
    }

    protected int handleArgument(String[] args, int index) {
        if (args[index].equalsIgnoreCase("-targetDirectory")) {
            this.targetDirectory = args[++index];
        } else if (args[index].equalsIgnoreCase("-javaPackage")) {
            this.javaPackage = args[++index];
        } else if (args[index].equalsIgnoreCase("-prefix")) {
            this.prefix = args[++index];
        } else if (args[index].equalsIgnoreCase("-noInterfaces")) {
            this.genOptions |= OPTION_NO_INTERFACES;
        } else if (args[index].equalsIgnoreCase("-sparsePattern")) {
            this.genOptions |= OPTION_SPARSE_PATTERN;
        } else if (args[index].equalsIgnoreCase("-storePattern")) {
            this.genOptions |= OPTION_STORE_PATTERN;
        } else if (args[index].equalsIgnoreCase("-noContainment")) {
            this.genOptions |= OPTION_NO_CONTAINMENT;
        } else if (args[index].equalsIgnoreCase("-noNotification")) {
            this.genOptions |= OPTION_NO_NOTIFICATION;
        } else if (args[index].equalsIgnoreCase("-arrayAccessors")) {
            this.genOptions |= OPTION_ARRAY_ACCESSORS;
        } else if (args[index].equalsIgnoreCase("-generateLoader")) {
            this.genOptions |= OPTION_GENERATE_LOADER;
        } else if (args[index].equalsIgnoreCase("-noUnsettable")) {
            this.genOptions |= OPTION_NO_UNSETTABLE;
        } else if (args[index].equalsIgnoreCase("-noEMF")) {
            System.out.println("Warning: -noEMF is deprecated. It is the default now.");
        } else if (args[index].equalsIgnoreCase("-interfaceDataObject")) {
            this.genOptions |= OPTION_INTERFACE_DO;
        } else if (args[index].equalsIgnoreCase("-noGenerate")) {
            this.genOptions |= OPTION_NO_GENERATE;
        } else {
            return index;
        }
        return index + 1;
    }

    protected abstract void run(String[] var1);

    public static void generateFromXMLSchema(String xsdFileName, String targetDirectory, String javaPackage, String prefix, int genOptions) {
        DataObjectUtil.initRuntime();
        EPackageRegistryImpl packageRegistry = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
        BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData((EPackage.Registry)packageRegistry);
        XSDHelper xsdHelper = new HelperContextImpl((ExtendedMetaData)extendedMetaData, false).getXSDHelper();
        try {
            File inputFile = new File(xsdFileName).getAbsoluteFile();
            FileInputStream inputStream = new FileInputStream(inputFile);
            xsdHelper.define(inputStream, inputFile.toURI().toString());
            targetDirectory = targetDirectory == null ? new File(xsdFileName).getCanonicalFile().getParent() : new File(targetDirectory).getCanonicalPath();
            if (!packageRegistry.values().isEmpty()) {
                String packageURI = JavaGenerator.getSchemaNamespace(xsdFileName);
                JavaGenerator.generatePackages(packageRegistry.values(), packageURI, null, targetDirectory, javaPackage, prefix, genOptions);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static void generatePackages(Collection packageList, String packageURI, String shortName, String targetDirectory, String javaPackage, String prefix, int genOptions) {
        Hashtable<String, PackageInfo> packageInfoTable = new Hashtable<String, PackageInfo>();
        packageInfoTable.put(packageURI, new PackageInfo(javaPackage, prefix, packageURI, shortName));
        JavaGenerator.generatePackages(packageList, targetDirectory, packageInfoTable, genOptions, false);
    }

    protected static GenModel generatePackages(Collection packageList, String targetDirectory, Hashtable packageInfoTable, int genOptions, boolean allNamespaces) {
        ResourceSet resourceSet = DataObjectUtil.createResourceSet();
        ArrayList<GenPackage> usedGenPackages = new ArrayList<GenPackage>();
        GenModel genModel = null;
        ArrayList<EPackage> packagesToModel = new ArrayList<EPackage>();
        Iterator iter = packageList.iterator();
        while (iter.hasNext()) {
            EPackage currentEPackage = (EPackage)iter.next();
            String packageNamespace = currentEPackage.getNsURI();
            PackageInfo packageInfo = (PackageInfo)packageInfoTable.get(packageNamespace);
            boolean bTargetPackage = allNamespaces;
            String javaPackage = null;
            String prefix = null;
            String shortName = null;
            if (packageInfo != null) {
                bTargetPackage = true;
                javaPackage = packageInfo.getBasePackage();
                prefix = packageInfo.getPrefix();
                shortName = packageInfo.getShortName();
            }
            String currentBasePackage = JavaGenerator.extractBasePackageName(currentEPackage, bTargetPackage ? javaPackage : null);
            String currentPrefix = bTargetPackage && prefix != null ? prefix : CodeGenUtil.capName((String)(shortName != null ? shortName : currentEPackage.getName()));
            packageInfoTable.put(currentEPackage, new PackageInfo(currentBasePackage, currentPrefix, null, null));
            if (allNamespaces || packageInfo != null) {
                packagesToModel.add(currentEPackage);
                continue;
            }
            GenPackage currentGenPackage = JavaGenerator.createGenPackage(currentEPackage, currentBasePackage, currentPrefix, genOptions, resourceSet);
            usedGenPackages.add(currentGenPackage);
        }
        genModel = JavaGenerator.createGenPackages(packagesToModel, packageInfoTable, genOptions, resourceSet);
        if (genModel == null) {
            return null;
        }
        usedGenPackages.add(JavaGenerator.createGenPackage((EPackage)SDOPackageImpl.eINSTANCE, "org.apache.tuscany", "SDO", 0, resourceSet));
        usedGenPackages.add(JavaGenerator.createGenPackage((EPackage)ModelFactory.INSTANCE, "org.apache.tuscany.sdo", "Model", 0, resourceSet));
        usedGenPackages.add(JavaGenerator.createGenPackage((EPackage)InternalFactory.INSTANCE, "org.apache.tuscany.sdo.model", "Internal", 0, resourceSet));
        genModel.getUsedGenPackages().addAll(usedGenPackages);
        if ((genOptions & OPTION_NO_GENERATE) == 0) {
            try {
                JavaGenerator.generateFromGenModel(genModel, new File(targetDirectory).getCanonicalPath(), genOptions);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return genModel;
    }

    public static String getSchemaNamespace(String xsdFileName) {
        ResourceSet resourceSet = DataObjectUtil.createResourceSet();
        File inputFile = new File(xsdFileName).getAbsoluteFile();
        Resource model = resourceSet.getResource(URI.createURI((String)inputFile.toURI().toString()), true);
        XSDSchema schema = (XSDSchema)model.getContents().get(0);
        return schema.getTargetNamespace();
    }

    protected static GenModel createGenPackages(Collection ePackages, Hashtable packageInfoTable, int genOptions, ResourceSet resourceSet) {
        GenModel genModel = JavaGenerator.ecore2GenModel(ePackages, packageInfoTable, genOptions);
        Iterator iter = ePackages.iterator();
        while (iter.hasNext()) {
            EPackage ePackage = (EPackage)iter.next();
            URI ecoreURI = URI.createURI((String)("file:///" + ePackage.getName() + ".ecore"));
            URI genModelURI = ecoreURI.trimFileExtension().appendFileExtension("genmodel");
            Resource ecoreResource = resourceSet.createResource(ecoreURI);
            ecoreResource.getContents().add((Object)ePackage);
            Resource genModelResource = resourceSet.createResource(genModelURI);
            genModelResource.getContents().add((Object)genModel);
        }
        return genModel;
    }

    public static GenPackage createGenPackage(EPackage ePackage, String basePackage, String prefix, int genOptions, ResourceSet resourceSet) {
        GenModel genModel = JavaGenerator.ecore2GenModel(ePackage, basePackage, prefix, genOptions);
        URI ecoreURI = URI.createURI((String)("file:///" + ePackage.getName() + ".ecore"));
        URI genModelURI = ecoreURI.trimFileExtension().appendFileExtension("genmodel");
        Resource ecoreResource = resourceSet.createResource(ecoreURI);
        ecoreResource.getContents().add((Object)ePackage);
        Resource genModelResource = resourceSet.createResource(genModelURI);
        genModelResource.getContents().add((Object)genModel);
        return (GenPackage)genModel.getGenPackages().get(0);
    }

    public static void generateFromEPackage(EPackage ePackage, String targetDirectory, String basePackage, String prefix, int genOptions) {
        GenModel genModel = JavaGenerator.ecore2GenModel(ePackage, basePackage, prefix, genOptions);
        ResourceSet resourceSet = DataObjectUtil.createResourceSet();
        URI ecoreURI = URI.createURI((String)"file:///temp.ecore");
        URI genModelURI = ecoreURI.trimFileExtension().appendFileExtension("genmodel");
        Resource ecoreResource = resourceSet.createResource(ecoreURI);
        ecoreResource.getContents().add((Object)ePackage);
        Resource genModelResource = resourceSet.createResource(genModelURI);
        genModelResource.getContents().add((Object)genModel);
        JavaGenerator.generateFromGenModel(genModel, targetDirectory, genOptions);
    }

    public static void generateFromGenModel(GenModel genModel, String targetDirectory, int genOptions) {
        Resource resource = genModel.eResource();
        if (resource == null) {
            return;
        }
        if (targetDirectory != null) {
            resource.getResourceSet().getURIConverter().getURIMap().put(URI.createURI((String)"platform:/resource/TargetProject/"), URI.createFileURI((String)(targetDirectory + "/")));
            genModel.setModelDirectory("/TargetProject");
        }
        GeneratorAdapterFactory.Descriptor.Registry.INSTANCE.addDescriptor("http://www.eclipse.org/emf/2002/GenModel", GenModelGeneratorAdapterFactory.DESCRIPTOR);
        Generator generator = new Generator(){

            public JControlModel getJControlModel() {
                if (this.jControlModel == null) {
                    this.jControlModel = new JControlModel();
                }
                return this.jControlModel;
            }
        };
        generator.getAdapterFactoryDescriptorRegistry().addDescriptor("http://www.eclipse.org/emf/2002/GenModel", SDOGenModelGeneratorAdapterFactory.DESCRIPTOR);
        generator.setInput((Object)genModel);
        generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", (Monitor)new BasicMonitor.Printing(System.out));
        Iterator j = resource.getContents().iterator();
        while (j.hasNext()) {
            EObject eObject = (EObject)j.next();
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject);
            if (diagnostic.getSeverity() == 0) continue;
            JavaGenerator.printDiagnostic(diagnostic, "");
        }
    }

    public static GenModel ecore2GenModel(EPackage ePackage, String basePackage, String prefix, int genOptions) {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        ePackages.add(ePackage);
        Hashtable<EPackage, PackageInfo> packageInfoTable = new Hashtable<EPackage, PackageInfo>();
        packageInfoTable.put(ePackage, new PackageInfo(basePackage, prefix, null, null));
        return JavaGenerator.ecore2GenModel(ePackages, packageInfoTable, genOptions);
    }

    private static GenModel ecore2GenModel(Collection ePackages, Hashtable packageInfoTable, int genOptions) {
        GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
        genModel.initialize(ePackages);
        genModel.setRootExtendsInterface("");
        genModel.setRootImplementsInterface("commonj.sdo.DataObject");
        genModel.setRootExtendsClass("org.apache.tuscany.sdo.impl.ExtensibleDataObjectImpl");
        genModel.setFeatureMapWrapperInterface("commonj.sdo.Sequence");
        genModel.setFeatureMapWrapperInternalInterface("org.apache.tuscany.sdo.util.BasicSequence");
        genModel.setFeatureMapWrapperClass("org.apache.tuscany.sdo.util.BasicSequence");
        genModel.setSuppressEMFTypes(true);
        genModel.setSuppressEMFMetaData(true);
        genModel.setSuppressEMFModelTags(true);
        genModel.setCanGenerate(true);
        genModel.setFacadeHelperClass("Hack");
        genModel.setForceOverwrite(true);
        if ((genOptions & OPTION_NO_INTERFACES) != 0) {
            genModel.setSuppressInterfaces(true);
        }
        if ((genOptions & OPTION_SPARSE_PATTERN) != 0) {
            genModel.setFeatureDelegation(GenDelegationKind.VIRTUAL_LITERAL);
        } else if ((genOptions & OPTION_STORE_PATTERN) != 0) {
            genModel.setFeatureDelegation(GenDelegationKind.REFLECTIVE_LITERAL);
            genModel.setRootExtendsClass("org.apache.tuscany.sdo.impl.StoreDataObjectImpl");
        }
        if ((genOptions & OPTION_NO_CONTAINMENT) != 0) {
            genModel.setSuppressContainment(true);
        }
        if ((genOptions & OPTION_NO_NOTIFICATION) != 0) {
            genModel.setSuppressNotification(true);
        }
        if ((genOptions & OPTION_ARRAY_ACCESSORS) != 0) {
            genModel.setArrayAccessors(true);
        }
        if ((genOptions & OPTION_NO_UNSETTABLE) != 0) {
            genModel.setSuppressUnsettable(true);
        }
        genModel.setRootExtendsClass("org.apache.tuscany.sdo.impl.DataObjectBase");
        if ((genOptions & OPTION_INTERFACE_DO) != 0) {
            genModel.setRootExtendsInterface("commonj.sdo.DataObject");
        } else {
            genModel.setRootExtendsInterface("java.io.Serializable");
        }
        EList packages = genModel.getGenPackages();
        Iterator iter1 = packages.iterator();
        block0: while (iter1.hasNext()) {
            GenPackage genPackage = (GenPackage)iter1.next();
            PackageInfo packageInfo = (PackageInfo)packageInfoTable.get(genPackage.getEcorePackage());
            if (packageInfo.getBasePackage() != null) {
                genPackage.setBasePackage(packageInfo.getBasePackage());
            }
            if (packageInfo.getPrefix() != null) {
                genPackage.setPrefix(packageInfo.getPrefix());
            }
            if ((genOptions & OPTION_GENERATE_SWITCH) == 0) {
                genPackage.setAdapterFactory(false);
            }
            if ((genOptions & OPTION_GENERATE_LOADER) != 0) {
                genPackage.setResource(GenResourceKind.XML_LITERAL);
                continue;
            }
            genPackage.setResource(GenResourceKind.NONE_LITERAL);
            Iterator iter2 = genPackage.getGenClasses().iterator();
            while (iter2.hasNext()) {
                GenClass genClass = (GenClass)iter2.next();
                if (!"DocumentRoot".equals(genClass.getName())) continue;
                genClass.setDynamic(true);
                continue block0;
            }
        }
        return genModel;
    }

    public static String extractBasePackageName(EPackage ePackage, String javaPackage) {
        String qualifiedName = javaPackage != null ? javaPackage : ePackage.getName();
        String name = JavaGenerator.shortName(qualifiedName);
        String baseName = qualifiedName.substring(0, qualifiedName.length() - name.length());
        if (javaPackage != null || !name.equals(qualifiedName)) {
            ePackage.setName(name);
        }
        return baseName != null ? JavaGenerator.safeQualifiedName(baseName) : null;
    }

    public static String shortName(String qualifiedName) {
        int index = qualifiedName.lastIndexOf(".");
        return index != -1 ? qualifiedName.substring(index + 1) : qualifiedName;
    }

    public static String safeQualifiedName(String qualifiedName) {
        StringBuffer safeQualifiedName = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(qualifiedName, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String name = stringTokenizer.nextToken();
            safeQualifiedName.append(CodeGenUtil.safeName((String)name));
            if (!stringTokenizer.hasMoreTokens()) continue;
            safeQualifiedName.append('.');
        }
        return safeQualifiedName.toString();
    }

    protected static void printDiagnostic(Diagnostic diagnostic, String indent) {
        System.out.print(indent);
        System.out.println(diagnostic.getMessage());
        Iterator i = diagnostic.getChildren().iterator();
        while (i.hasNext()) {
            JavaGenerator.printDiagnostic((Diagnostic)i.next(), indent + "  ");
        }
    }

    protected static void printUsage() {
        System.out.println("Usage: this is a deprecated command replaced by XSD2JavaGenerator");
    }

    static {
        System.setProperty("EMF_NO_CONSTRAINTS", "true");
    }

    public static class PackageInfo {
        private String basePackage;
        private String prefix;
        private String namespace;
        private String shortName;

        public PackageInfo(String basePackage, String prefix, String namespace, String shortName) {
            this.setBasePackage(basePackage);
            this.setPrefix(prefix);
            this.setNamespace(namespace);
            this.setShortName(shortName);
        }

        public void setBasePackage(String basePackage) {
            this.basePackage = basePackage;
        }

        public String getBasePackage() {
            return this.basePackage;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setShortName(String shortName) {
            this.shortName = shortName;
        }

        public String getShortName() {
            return this.shortName;
        }
    }
}

