/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.xsd.xml;

import java.net.URI;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.xsd.XSDFactory;
import org.apache.tuscany.sca.xsd.XSDefinition;
import org.apache.tuscany.sca.xsd.xml.XMLDocumentHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDDocumentProcessor
implements URLArtifactProcessor<XSDefinition> {
    private XSDFactory factory;
    private XMLInputFactory inputFactory;
    private Monitor monitor;
    public static final QName XSD = new QName("http://www.w3.org/2001/XMLSchema", "schema");

    public XSDDocumentProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.factory = modelFactories.getFactory(XSDFactory.class);
        this.inputFactory = modelFactories.getFactory(XMLInputFactory.class);
        this.monitor = monitor;
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "xsd-xml-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }

    @Override
    public XSDefinition read(URL contributionURL, URI artifactURI, URL artifactURL) throws ContributionReadException {
        try {
            return this.indexRead(artifactURL);
        }
        catch (Exception e) {
            ContributionReadException ce = new ContributionReadException(e);
            this.error("ContributionReadException", artifactURL, ce);
            throw ce;
        }
    }

    @Override
    public void resolve(XSDefinition model, ModelResolver resolver) throws ContributionResolveException {
    }

    @Override
    public String getArtifactType() {
        return ".xsd";
    }

    @Override
    public Class<XSDefinition> getModelType() {
        return XSDefinition.class;
    }

    protected XSDefinition indexRead(URL doc) throws Exception {
        XSDefinition xsd = this.factory.createXSDefinition();
        xsd.setUnresolved(true);
        xsd.setNamespace(XMLDocumentHelper.readTargetNamespace(doc, XSD, true, "targetNamespace", this.inputFactory));
        xsd.setLocation(doc.toURI());
        xsd.setUnresolved(false);
        return xsd;
    }
}

