/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.workspace.xml;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.workspace.Workspace;
import org.apache.tuscany.sca.workspace.WorkspaceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<Workspace> {
    private static final String SCA10_TUSCANY_NS = "http://tuscany.apache.org/xmlns/sca/1.0";
    private static final QName WORKSPACE_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "workspace");
    private static final QName CONTRIBUTION_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "contribution");
    private static final String URI = "uri";
    private static final String LOCATION = "location";
    private WorkspaceFactory workspaceFactory;
    private ContributionFactory contributionFactory;

    public WorkspaceProcessor(WorkspaceFactory workspaceFactory, ContributionFactory contributionFactory, StAXArtifactProcessor<Object> extensionProcessor) {
        this.workspaceFactory = workspaceFactory;
        this.contributionFactory = contributionFactory;
    }

    public WorkspaceProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor<Object> extensionProcessor, Monitor monitor) {
        this.workspaceFactory = modelFactories.getFactory(WorkspaceFactory.class);
        this.contributionFactory = modelFactories.getFactory(ContributionFactory.class);
    }

    @Override
    public Workspace read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        Workspace workspace = null;
        Contribution contribution = null;
        while (reader.hasNext()) {
            int event = reader.getEventType();
            switch (event) {
                case 1: {
                    QName name = reader.getName();
                    if (WORKSPACE_QNAME.equals(name)) {
                        workspace = this.workspaceFactory.createWorkspace();
                        workspace.setUnresolved(true);
                        break;
                    }
                    if (!CONTRIBUTION_QNAME.equals(name)) break;
                    contribution = this.contributionFactory.createContribution();
                    contribution.setURI(this.getString(reader, URI));
                    contribution.setLocation(this.getString(reader, LOCATION));
                    contribution.setUnresolved(true);
                    workspace.getContributions().add(contribution);
                    break;
                }
                case 2: {
                    QName name = reader.getName();
                    if (!CONTRIBUTION_QNAME.equals(name)) break;
                    contribution = null;
                }
            }
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return workspace;
    }

    @Override
    public void write(Workspace workspace, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        this.writeStartDocument(writer, WORKSPACE_QNAME, new BaseStAXArtifactProcessor.XAttr[0]);
        for (Contribution contribution : workspace.getContributions()) {
            this.writeStart(writer, CONTRIBUTION_QNAME, new BaseStAXArtifactProcessor.XAttr(URI, contribution.getURI()), new BaseStAXArtifactProcessor.XAttr(LOCATION, contribution.getLocation()));
            this.writeEnd(writer);
        }
        this.writeEndDocument(writer);
    }

    @Override
    public void resolve(Workspace workspace, ModelResolver resolver) throws ContributionResolveException {
        List<Contribution> contributions = workspace.getContributions();
        int n = contributions.size();
        for (int i = 0; i < n; ++i) {
            Contribution contribution = contributions.get(i);
            Contribution resolved = resolver.resolveModel(Contribution.class, contribution);
            if (resolved == contribution) continue;
            contributions.set(i, resolved);
        }
        workspace.setUnresolved(false);
    }

    @Override
    public QName getArtifactType() {
        return WORKSPACE_QNAME;
    }

    @Override
    public Class<Workspace> getModelType() {
        return Workspace.class;
    }
}

