/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.workspace.scanner.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.contribution.scanner.ContributionScanner;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryContributionScanner
implements ContributionScanner {
    @Override
    public String getContributionType() {
        return "application/vnd.tuscany.folder";
    }

    @Override
    public URL getArtifactURL(URL contributionURL, String artifact) throws ContributionReadException {
        File directory = DirectoryContributionScanner.directory(contributionURL);
        File file = new File(directory, artifact);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new ContributionReadException(e);
        }
    }

    @Override
    public List<String> getArtifacts(URL contributionURL) throws ContributionReadException {
        File directory = DirectoryContributionScanner.directory(contributionURL);
        ArrayList<String> artifacts = new ArrayList<String>();
        try {
            DirectoryContributionScanner.traverse(artifacts, directory, directory);
        }
        catch (IOException e) {
            throw new ContributionReadException(e);
        }
        return artifacts;
    }

    private static void traverse(List<String> fileList, File file, File root) throws IOException {
        if (file.isFile()) {
            fileList.add(root.toURI().relativize(file.toURI()).toString());
        } else if (file.isDirectory()) {
            File[] files;
            String uri = root.toURI().relativize(file.toURI()).toString();
            if (uri.endsWith("/")) {
                uri = uri.substring(0, uri.length() - 1);
            }
            fileList.add(uri);
            for (File f : files = file.listFiles()) {
                if (f.getName().startsWith(".")) continue;
                DirectoryContributionScanner.traverse(fileList, f, root);
            }
        }
    }

    private static File directory(URL url) throws ContributionReadException {
        File file;
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new ContributionReadException(e);
        }
        if (!file.exists() || !file.isDirectory()) {
            throw new ContributionReadException(url.toString());
        }
        return file;
    }
}

