/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.workspace.processor.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ContributionMetadata;
import org.apache.tuscany.sca.contribution.DefaultExport;
import org.apache.tuscany.sca.contribution.DefaultImport;
import org.apache.tuscany.sca.contribution.Export;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.ExtensibleURLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.DefaultModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ExtensibleModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolverExtensionPoint;
import org.apache.tuscany.sca.contribution.scanner.ContributionScanner;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.workspace.processor.impl.ContributionContentProcessor;
import org.apache.tuscany.sca.workspace.scanner.impl.DirectoryContributionScanner;
import org.apache.tuscany.sca.workspace.scanner.impl.JarContributionScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionInfoProcessor
implements URLArtifactProcessor<Contribution> {
    private ContributionFactory contributionFactory;
    private ModelResolverExtensionPoint modelResolvers;
    private ModelFactoryExtensionPoint modelFactories;
    private URLArtifactProcessorExtensionPoint artifactProcessors;
    private URLArtifactProcessor<Object> artifactProcessor;
    private StAXArtifactProcessor<Object> extensionProcessor;

    public ContributionInfoProcessor(ExtensionPointRegistry extensionPoints, StAXArtifactProcessor<Object> extensionProcessor, Monitor monitor) {
        URLArtifactProcessorExtensionPoint artifactProcessors;
        this.modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.modelResolvers = extensionPoints.getExtensionPoint(ModelResolverExtensionPoint.class);
        ContributionInfoProcessor.hackResolvers(this.modelResolvers);
        this.artifactProcessors = artifactProcessors = extensionPoints.getExtensionPoint(URLArtifactProcessorExtensionPoint.class);
        this.artifactProcessor = new ExtensibleURLArtifactProcessor(artifactProcessors, monitor);
        this.extensionProcessor = extensionProcessor;
        this.contributionFactory = this.modelFactories.getFactory(ContributionFactory.class);
    }

    public ContributionInfoProcessor(ModelFactoryExtensionPoint modelFactories, ModelResolverExtensionPoint modelResolvers, URLArtifactProcessor<Object> artifactProcessor) {
        this.modelFactories = modelFactories;
        this.modelResolvers = modelResolvers;
        ContributionInfoProcessor.hackResolvers(modelResolvers);
        this.artifactProcessor = artifactProcessor;
        this.contributionFactory = modelFactories.getFactory(ContributionFactory.class);
    }

    @Override
    public String getArtifactType() {
        return ".contribution/info";
    }

    @Override
    public Class<Contribution> getModelType() {
        return null;
    }

    @Override
    public Contribution read(URL parentURL, URI contributionURI, URL contributionURL) throws ContributionReadException {
        Contribution contribution = this.contributionFactory.createContribution();
        contribution.setURI(contributionURI.toString());
        contribution.setLocation(contributionURL.toString());
        ExtensibleModelResolver modelResolver = new ExtensibleModelResolver(contribution, this.modelResolvers, this.modelFactories);
        contribution.setModelResolver(modelResolver);
        contribution.setUnresolved(true);
        ContributionScanner scanner = "file".equals(contributionURL.getProtocol()) && new File(contributionURL.getFile()).isDirectory() ? new DirectoryContributionScanner() : new JarContributionScanner();
        boolean contributionMetadata = false;
        for (String path : new String[]{"META-INF/sca-contribution-generated.xml", "META-INF/sca-contribution.xml"}) {
            URL url = scanner.getArtifactURL(contributionURL, path);
            try {
                URLConnection connection = url.openConnection();
                connection.setUseCaches(false);
                InputStream is = connection.getInputStream();
                is.close();
            }
            catch (IOException e) {
                continue;
            }
            contributionMetadata = true;
            ContributionMetadata c = (ContributionMetadata)this.artifactProcessor.read(contributionURL, URI.create(path), url);
            contribution.getImports().addAll(c.getImports());
            contribution.getExports().addAll(c.getExports());
            contribution.getDeployables().addAll(c.getDeployables());
        }
        if (!contributionMetadata) {
            List<String> artifactURIs;
            try {
                artifactURIs = scanner.getArtifacts(contributionURL);
            }
            catch (ContributionReadException e) {
                artifactURIs = null;
            }
            if (artifactURIs != null) {
                for (String artifactURI : artifactURIs) {
                    boolean read = false;
                    if (artifactURI.endsWith(".composite")) {
                        read = true;
                    } else {
                        int s = artifactURI.lastIndexOf("/");
                        String fileName = artifactURI.substring(s + 1);
                        if (this.artifactProcessors.getProcessor(fileName) != null) {
                            read = true;
                        }
                    }
                    if (!read) continue;
                    URL artifactURL = scanner.getArtifactURL(contributionURL, artifactURI);
                    Object model = this.artifactProcessor.read(contributionURL, URI.create(artifactURI), artifactURL);
                    if (!(model instanceof Composite)) continue;
                    contribution.getDeployables().add((Composite)model);
                }
            }
            DefaultImport defaultImport = this.contributionFactory.createDefaultImport();
            defaultImport.setModelResolver(new DefaultModelResolver());
            contribution.getImports().add(defaultImport);
            DefaultExport defaultExport = this.contributionFactory.createDefaultExport();
            contribution.getExports().add(defaultExport);
        }
        return contribution;
    }

    @Override
    public void resolve(Contribution contribution, ModelResolver resolver) throws ContributionResolveException {
        ModelResolver contributionResolver = contribution.getModelResolver();
        contribution.setUnresolved(false);
        contributionResolver.addModel(contribution);
        for (Export export : contribution.getExports()) {
            if (export instanceof DefaultExport) {
                export.setModelResolver(contributionResolver);
                continue;
            }
            this.extensionProcessor.resolve(export, contributionResolver);
        }
        for (Import import_ : contribution.getImports()) {
            this.extensionProcessor.resolve(import_, contributionResolver);
        }
    }

    private static void hackResolvers(ModelResolverExtensionPoint modelResolvers) {
        Class<? extends ModelResolver> resolverClass = modelResolvers.getResolver(ClassReference.class);
        if (resolverClass == null || !resolverClass.getName().equals("org.apache.tuscany.sca.contribution.java.impl.ClassLoaderModelResolver")) {
            try {
                Class<?> loaderResolverClass = Class.forName("org.apache.tuscany.sca.contribution.java.impl.ClassLoaderModelResolver", true, ContributionContentProcessor.class.getClassLoader());
                modelResolvers.addResolver(ClassReference.class, loaderResolverClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

