/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.workspace.processor.impl;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ContributionMetadata;
import org.apache.tuscany.sca.contribution.DefaultExport;
import org.apache.tuscany.sca.contribution.DefaultImport;
import org.apache.tuscany.sca.contribution.Export;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.ExtensibleURLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.DefaultModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ExtensibleModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolverExtensionPoint;
import org.apache.tuscany.sca.contribution.scanner.ContributionScanner;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.workspace.scanner.impl.DirectoryContributionScanner;
import org.apache.tuscany.sca.workspace.scanner.impl.JarContributionScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionContentProcessor
implements URLArtifactProcessor<Contribution> {
    private ContributionFactory contributionFactory;
    private ModelResolverExtensionPoint modelResolvers;
    private ModelFactoryExtensionPoint modelFactories;
    private URLArtifactProcessor<Object> artifactProcessor;
    private StAXArtifactProcessor<Object> extensionProcessor;
    private UtilityExtensionPoint utilities;
    private Monitor monitor = null;

    public ContributionContentProcessor(ExtensionPointRegistry extensionPoints, StAXArtifactProcessor<Object> extensionProcessor, Monitor monitor) {
        this.modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.modelResolvers = extensionPoints.getExtensionPoint(ModelResolverExtensionPoint.class);
        ContributionContentProcessor.hackResolvers(this.modelResolvers);
        this.monitor = monitor;
        URLArtifactProcessorExtensionPoint artifactProcessors = extensionPoints.getExtensionPoint(URLArtifactProcessorExtensionPoint.class);
        this.artifactProcessor = new ExtensibleURLArtifactProcessor(artifactProcessors, this.monitor);
        this.extensionProcessor = extensionProcessor;
        this.contributionFactory = this.modelFactories.getFactory(ContributionFactory.class);
    }

    public ContributionContentProcessor(ModelFactoryExtensionPoint modelFactories, ModelResolverExtensionPoint modelResolvers, URLArtifactProcessor<Object> artifactProcessor, StAXArtifactProcessor<Object> extensionProcessor, Monitor monitor) {
        this.modelFactories = modelFactories;
        this.modelResolvers = modelResolvers;
        ContributionContentProcessor.hackResolvers(modelResolvers);
        this.artifactProcessor = artifactProcessor;
        this.extensionProcessor = extensionProcessor;
        this.contributionFactory = modelFactories.getFactory(ContributionFactory.class);
        this.monitor = monitor;
    }

    @Override
    public String getArtifactType() {
        return ".contribution/content";
    }

    @Override
    public Class<Contribution> getModelType() {
        return Contribution.class;
    }

    @Override
    public Contribution read(URL parentURL, URI contributionURI, URL contributionURL) throws ContributionReadException {
        Contribution contribution = this.contributionFactory.createContribution();
        contribution.setURI(contributionURI.toString());
        contribution.setLocation(contributionURL.toString());
        ExtensibleModelResolver modelResolver = new ExtensibleModelResolver(contribution, this.modelResolvers, this.modelFactories);
        contribution.setModelResolver(modelResolver);
        contribution.setUnresolved(true);
        ContributionScanner scanner = "file".equals(contributionURL.getProtocol()) && new File(contributionURL.getFile()).isDirectory() ? new DirectoryContributionScanner() : new JarContributionScanner();
        List<Artifact> artifacts = contribution.getArtifacts();
        boolean contributionMetadata = false;
        List<String> artifactURIs = scanner.getArtifacts(contributionURL);
        for (String artifactURI : artifactURIs) {
            URL artifactURL = scanner.getArtifactURL(contributionURL, artifactURI);
            Artifact artifact = this.contributionFactory.createArtifact();
            artifact.setURI(artifactURI);
            artifact.setLocation(artifactURL.toString());
            artifacts.add(artifact);
            modelResolver.addModel(artifact);
            Object model = this.artifactProcessor.read(contributionURL, URI.create(artifactURI), artifactURL);
            if (model == null) continue;
            artifact.setModel(model);
            modelResolver.addModel(model);
            if (!(model instanceof ContributionMetadata)) continue;
            contributionMetadata = true;
            ContributionMetadata c = (ContributionMetadata)model;
            contribution.getImports().addAll(c.getImports());
            contribution.getExports().addAll(c.getExports());
            contribution.getDeployables().addAll(c.getDeployables());
        }
        if (!contributionMetadata) {
            for (Artifact artifact : artifacts) {
                if (!(artifact.getModel() instanceof Composite)) continue;
                contribution.getDeployables().add((Composite)artifact.getModel());
            }
            DefaultImport defaultImport = this.contributionFactory.createDefaultImport();
            defaultImport.setModelResolver(new DefaultModelResolver());
            contribution.getImports().add(defaultImport);
            DefaultExport defaultExport = this.contributionFactory.createDefaultExport();
            contribution.getExports().add(defaultExport);
        }
        return contribution;
    }

    @Override
    public void resolve(Contribution contribution, ModelResolver resolver) throws ContributionResolveException {
        ModelResolver contributionResolver = contribution.getModelResolver();
        contribution.setUnresolved(false);
        contributionResolver.addModel(contribution);
        for (Export export : contribution.getExports()) {
            if (export instanceof DefaultExport) {
                export.setModelResolver(contributionResolver);
                continue;
            }
            this.extensionProcessor.resolve(export, contributionResolver);
        }
        for (Import import_ : contribution.getImports()) {
            this.extensionProcessor.resolve(import_, contributionResolver);
        }
        for (Artifact artifact : contribution.getArtifacts()) {
            Object model = artifact.getModel();
            if (model == null) continue;
            try {
                this.artifactProcessor.resolve(model, contributionResolver);
            }
            catch (ContributionResolveException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ContributionResolveException(e);
            }
        }
        List<Composite> deployables = contribution.getDeployables();
        int n = deployables.size();
        for (int i = 0; i < n; ++i) {
            Composite deployable = deployables.get(i);
            Composite resolved = contributionResolver.resolveModel(Composite.class, deployable);
            if (resolved == deployable) continue;
            deployables.set(i, resolved);
        }
    }

    private static void hackResolvers(ModelResolverExtensionPoint modelResolvers) {
        Class<? extends ModelResolver> resolverClass = modelResolvers.getResolver(ClassReference.class);
        if (resolverClass == null || !resolverClass.getName().equals("org.apache.tuscany.sca.contribution.java.impl.ClassLoaderModelResolver")) {
            try {
                Class<?> loaderResolverClass = Class.forName("org.apache.tuscany.sca.contribution.java.impl.ClassLoaderModelResolver", true, ContributionContentProcessor.class.getClassLoader());
                modelResolvers.addResolver(ClassReference.class, loaderResolverClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

