/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.workspace.builder.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.DefaultImport;
import org.apache.tuscany.sca.contribution.Export;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.resolver.DefaultImportModelResolver;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.workspace.Workspace;
import org.apache.tuscany.sca.workspace.builder.ContributionDependencyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionDependencyBuilderImpl
implements ContributionDependencyBuilder {
    private static final Logger logger = Logger.getLogger(ContributionDependencyBuilderImpl.class.getName());
    private Monitor monitor;

    public ContributionDependencyBuilderImpl(Monitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public List<Contribution> buildContributionDependencies(Contribution contribution, Workspace workspace) {
        ArrayList<Contribution> dependencies = new ArrayList<Contribution>();
        HashSet<Contribution> set = new HashSet<Contribution>();
        dependencies.add(contribution);
        set.add(contribution);
        this.addContributionDependencies(contribution, workspace, dependencies, set);
        Collections.reverse(dependencies);
        return dependencies;
    }

    private void addContributionDependencies(Contribution contribution, Workspace workspace, List<Contribution> dependencies, Set<Contribution> set) {
        for (Import import_ : contribution.getImports()) {
            boolean resolved = false;
            ArrayList<Export> matchingExports = new ArrayList<Export>();
            for (Contribution dependency : workspace.getContributions()) {
                if (dependency == contribution) continue;
                for (Export export : dependency.getExports()) {
                    if (!import_.match(export)) continue;
                    resolved = true;
                    matchingExports.add(export);
                    if (set.contains(dependency)) continue;
                    set.add(dependency);
                    dependencies.add(dependency);
                    this.addContributionDependencies(dependency, workspace, dependencies, set);
                }
            }
            if (resolved) {
                import_.setModelResolver(new DefaultImportModelResolver(matchingExports));
                continue;
            }
            if (import_ instanceof DefaultImport) continue;
            this.warning("UnresolvedImport", import_, import_);
        }
    }

    private void warning(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "workspace-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }
}

