/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.xml.ws;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.xml.PolicyConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSPolicyProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<Policy>,
PolicyConstants {
    public static final String WS_POLICY_NS = "http://schemas.xmlsoap.org/ws/2004/09/policy";
    public static final String WS_POLICY = "Policy";
    public static final QName WS_POLICY_QNAME = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy");

    public WSPolicyProcessor() {
        System.out.println(">>>Initializing WSPolicyProcessor");
    }

    public WSPolicyProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        System.out.println(">>>Initializing WSPolicyProcessor");
    }

    @Override
    public QName getArtifactType() {
        return WS_POLICY_QNAME;
    }

    @Override
    public Class<Policy> getModelType() {
        return Policy.class;
    }

    @Override
    public Policy read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        QName name;
        Policy wsPolicy = null;
        int event = reader.getEventType();
        if (event == 1 && WS_POLICY_QNAME.equals(name = reader.getName())) {
            OMElement policyElement = this.loadElement(reader);
            wsPolicy = PolicyEngine.getPolicy((OMElement)policyElement);
        }
        return wsPolicy;
    }

    @Override
    public void write(Policy wsPolicy, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(WS_POLICY_NS, WS_POLICY);
        writer.writeEndElement();
    }

    @Override
    public void resolve(Policy wsPolicy, ModelResolver resolver) throws ContributionResolveException {
    }

    private OMElement loadElement(XMLStreamReader reader) throws XMLStreamException {
        OMElement head;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement current = head = fac.createOMElement(reader.getName());
        while (true) {
            switch (reader.next()) {
                case 1: {
                    String ns;
                    int i;
                    QName name = reader.getName();
                    OMElement child = fac.createOMElement(name, (OMContainer)current);
                    int count = reader.getNamespaceCount();
                    for (i = 0; i < count; ++i) {
                        String prefix = reader.getNamespacePrefix(i);
                        ns = reader.getNamespaceURI(i);
                        child.declareNamespace(ns, prefix);
                    }
                    if (!"".equals(name.getNamespaceURI())) {
                        child.declareNamespace(name.getNamespaceURI(), name.getPrefix());
                    }
                    count = reader.getAttributeCount();
                    for (i = 0; i < count; ++i) {
                        OMNamespace omNs = null;
                        ns = reader.getAttributeNamespace(i);
                        String prefix = reader.getAttributePrefix(i);
                        String qname = reader.getAttributeLocalName(i);
                        String value = reader.getAttributeValue(i);
                        if (ns != null) {
                            omNs = fac.createOMNamespace(ns, prefix);
                        }
                        child.addAttribute(qname, value, omNs);
                        if (ns == null) continue;
                        child.declareNamespace(ns, prefix);
                    }
                    current = child;
                    break;
                }
                case 12: {
                    fac.createOMText((OMContainer)current, reader.getText());
                    break;
                }
                case 4: {
                    fac.createOMText((OMContainer)current, reader.getText());
                    break;
                }
                case 2: {
                    if (current == head) {
                        return head;
                    }
                    current = (OMElement)current.getParent();
                }
            }
        }
    }
}

