/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.ProfileIntent;
import org.apache.tuscany.sca.policy.QualifiedIntent;
import org.apache.tuscany.sca.policy.xml.PolicyConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PolicyIntentProcessor<T extends Intent>
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<T>,
PolicyConstants {
    private PolicyFactory policyFactory;
    private Monitor monitor;

    public PolicyIntentProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.monitor = monitor;
    }

    public PolicyIntentProcessor(PolicyFactory policyFactory, Monitor monitor) {
        this.policyFactory = policyFactory;
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "policy-xml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    @Override
    public T read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        Intent policyIntent = null;
        String policyIntentName = reader.getAttributeValue(null, "name");
        if (policyIntentName == null) {
            this.error("IntentNameMissing", reader, new Object[0]);
            return (T)policyIntent;
        }
        if (reader.getAttributeValue(null, "requires") != null) {
            policyIntent = this.policyFactory.createProfileIntent();
        } else if (policyIntentName != null && policyIntentName.indexOf(".") != -1) {
            policyIntent = this.policyFactory.createQualifiedIntent();
            int qualifierIndex = policyIntentName.lastIndexOf(".");
            Intent qualifiableIntent = this.policyFactory.createIntent();
            qualifiableIntent.setUnresolved(true);
            qualifiableIntent.setName(new QName(policyIntentName.substring(0, qualifierIndex)));
            ((QualifiedIntent)policyIntent).setQualifiableIntent(qualifiableIntent);
        } else {
            policyIntent = this.policyFactory.createIntent();
        }
        policyIntent.setName(new QName(policyIntentName));
        if (policyIntent instanceof ProfileIntent) {
            this.readRequiredIntents((ProfileIntent)policyIntent, reader);
        } else {
            this.readExcludedIntents(policyIntent, reader);
        }
        this.readConstrainedArtifacts(policyIntent, reader);
        int event = reader.getEventType();
        QName name = null;
        while (reader.hasNext()) {
            event = reader.getEventType();
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (!DESCRIPTION_QNAME.equals(name)) break;
                    policyIntent.setDescription(reader.getElementText());
                }
            }
            if (event == 2 && POLICY_INTENT_QNAME.equals(reader.getName())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return (T)policyIntent;
    }

    @Override
    public void write(T policyIntent, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        StringBuffer sb;
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "intent");
        writer.writeNamespace(policyIntent.getName().getPrefix(), policyIntent.getName().getNamespaceURI());
        writer.writeAttribute("name", policyIntent.getName().getPrefix() + ":" + policyIntent.getName().getLocalPart());
        if (policyIntent instanceof ProfileIntent) {
            ProfileIntent profileIntent = (ProfileIntent)policyIntent;
            if (profileIntent.getRequiredIntents() != null && profileIntent.getRequiredIntents().size() > 0) {
                StringBuffer sb2 = new StringBuffer();
                for (Intent requiredIntents : profileIntent.getRequiredIntents()) {
                    sb2.append(requiredIntents.getName());
                    sb2.append(" ");
                }
                writer.writeAttribute("requires", sb2.toString());
            }
        } else if (policyIntent.getExcludedIntents() != null && policyIntent.getExcludedIntents().size() > 0) {
            sb = new StringBuffer();
            for (Intent excludedIntents : policyIntent.getExcludedIntents()) {
                sb.append(excludedIntents.getName());
                sb.append(" ");
            }
            writer.writeAttribute("excludes", sb.toString());
        }
        if (!(policyIntent instanceof QualifiedIntent)) {
            if (policyIntent.getConstrains() != null && policyIntent.getConstrains().size() > 0) {
                sb = new StringBuffer();
                for (QName contrainedArtifact : policyIntent.getConstrains()) {
                    sb.append(contrainedArtifact.toString());
                    sb.append(" ");
                }
                writer.writeAttribute("constrains", sb.toString());
            } else {
                this.error("ContrainsAttributeMissing", policyIntent, policyIntent.getName());
            }
        }
        if (policyIntent.getDescription() != null && policyIntent.getDescription().length() > 0) {
            writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "description");
            writer.writeCData(policyIntent.getDescription());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void resolveContrainedArtifacts(Intent policyIntent, ModelResolver resolver) {
        policyIntent.setUnresolved(false);
    }

    private void resolveProfileIntent(ProfileIntent policyIntent, ModelResolver resolver) throws ContributionResolveException {
        if (policyIntent != null) {
            ArrayList<Intent> requiredIntents = new ArrayList<Intent>();
            for (Intent requiredIntent : policyIntent.getRequiredIntents()) {
                if (requiredIntent.isUnresolved()) {
                    Intent resolvedRequiredIntent = resolver.resolveModel(Intent.class, requiredIntent);
                    if (resolvedRequiredIntent.isUnresolved() && resolvedRequiredIntent instanceof ProfileIntent) {
                        if (((ProfileIntent)resolvedRequiredIntent).getRequiredIntents().contains(policyIntent)) {
                            this.error("CyclicReferenceFound", resolver, requiredIntent, policyIntent);
                            return;
                        }
                        this.resolveDependent(resolvedRequiredIntent, resolver);
                    }
                    if (!resolvedRequiredIntent.isUnresolved()) {
                        requiredIntents.add(resolvedRequiredIntent);
                        continue;
                    }
                    this.error("RequiredIntentNotFound", resolver, requiredIntent, policyIntent);
                    return;
                }
                requiredIntents.add(requiredIntent);
            }
            policyIntent.getRequiredIntents().clear();
            policyIntent.getRequiredIntents().addAll(requiredIntents);
        }
    }

    private void resolveQualifiedIntent(QualifiedIntent policyIntent, ModelResolver resolver) throws ContributionResolveException {
        Intent qualifiableIntent;
        if (policyIntent != null && (qualifiableIntent = policyIntent.getQualifiableIntent()).isUnresolved()) {
            Intent resolvedQualifiableIntent = resolver.resolveModel(Intent.class, qualifiableIntent);
            if (resolvedQualifiableIntent.isUnresolved() && resolvedQualifiableIntent instanceof QualifiedIntent) {
                this.resolveDependent(resolvedQualifiableIntent, resolver);
            }
            if (!resolvedQualifiableIntent.isUnresolved()) {
                policyIntent.setQualifiableIntent(resolvedQualifiableIntent);
            } else {
                this.error("QualifiableIntentNotFound", resolver, qualifiableIntent, policyIntent);
            }
        }
    }

    public void resolveDependent(Intent policyIntent, ModelResolver resolver) throws ContributionResolveException {
        if (policyIntent instanceof ProfileIntent) {
            this.resolveProfileIntent((ProfileIntent)policyIntent, resolver);
        }
        if (policyIntent instanceof QualifiedIntent) {
            this.resolveQualifiedIntent((QualifiedIntent)policyIntent, resolver);
        }
        this.resolveContrainedArtifacts(policyIntent, resolver);
    }

    @Override
    public void resolve(T policyIntent, ModelResolver resolver) throws ContributionResolveException {
        if (policyIntent instanceof ProfileIntent) {
            this.resolveProfileIntent((ProfileIntent)policyIntent, resolver);
        } else {
            this.resolveExcludedIntents((Intent)policyIntent, resolver);
        }
        if (policyIntent instanceof QualifiedIntent) {
            this.resolveQualifiedIntent((QualifiedIntent)policyIntent, resolver);
        }
        this.resolveContrainedArtifacts((Intent)policyIntent, resolver);
    }

    @Override
    public QName getArtifactType() {
        return POLICY_INTENT_QNAME;
    }

    private void readConstrainedArtifacts(Intent policyIntent, XMLStreamReader reader) throws ContributionReadException {
        String value = reader.getAttributeValue(null, "constrains");
        if (policyIntent instanceof QualifiedIntent && value != null) {
            this.error("ErrorInPolicyIntentDefinition", policyIntent, policyIntent.getName(), " - Qualified Intents must not specify 'constrains' attribute");
        } else if (value != null) {
            List<QName> constrainedArtifacts = policyIntent.getConstrains();
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                QName qname = this.getQNameValue(reader, tokens.nextToken());
                constrainedArtifacts.add(qname);
            }
        }
    }

    private void readRequiredIntents(ProfileIntent policyIntent, XMLStreamReader reader) {
        String value = reader.getAttributeValue(null, "requires");
        if (value != null) {
            List<Intent> requiredIntents = policyIntent.getRequiredIntents();
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                QName qname = this.getQNameValue(reader, tokens.nextToken());
                Intent intent = this.policyFactory.createIntent();
                intent.setName(qname);
                intent.setUnresolved(true);
                requiredIntents.add(intent);
            }
        }
    }

    private void readExcludedIntents(Intent policyIntent, XMLStreamReader reader) {
        String value = reader.getAttributeValue(null, "excludes");
        if (value != null) {
            List<Intent> excludedIntents = policyIntent.getExcludedIntents();
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                QName qname = this.getQNameValue(reader, tokens.nextToken());
                Intent intent = this.policyFactory.createIntent();
                intent.setName(qname);
                intent.setUnresolved(true);
                excludedIntents.add(intent);
            }
        }
    }

    private void resolveExcludedIntents(Intent policyIntent, ModelResolver resolver) throws ContributionResolveException {
        if (policyIntent != null) {
            ArrayList<Intent> excludedIntents = new ArrayList<Intent>();
            for (Intent excludedIntent : policyIntent.getExcludedIntents()) {
                if (excludedIntent.isUnresolved()) {
                    Intent resolvedExcludedIntent = resolver.resolveModel(Intent.class, excludedIntent);
                    if (!resolvedExcludedIntent.isUnresolved()) {
                        excludedIntents.add(resolvedExcludedIntent);
                        continue;
                    }
                    this.error("ExcludedIntentNotFound", resolver, excludedIntent, policyIntent);
                    return;
                }
                excludedIntents.add(excludedIntent);
            }
            policyIntent.getExcludedIntents().clear();
            policyIntent.getExcludedIntents().addAll(excludedIntents);
        }
    }
}

