/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.security;

import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.definitions.SCADefinitions;
import org.apache.tuscany.sca.definitions.util.SCADefinitionsUtil;
import org.apache.tuscany.sca.provider.SCADefinitionsProvider;
import org.apache.tuscany.sca.provider.SCADefinitionsProviderException;

public class SecurityPolicyDefinitionsProvider
implements SCADefinitionsProvider {
    private static final String tuscanyDefinitionsFile = "org/apache/tuscany/sca/policy/security/tuscany_definitions.xml";
    private String definitionsFile = "org/apache/tuscany/sca/policy/security/definitions.xml";
    URLArtifactProcessor urlArtifactProcessor = null;

    public SecurityPolicyDefinitionsProvider(ExtensionPointRegistry registry) {
        URLArtifactProcessorExtensionPoint documentProcessors = registry.getExtensionPoint(URLArtifactProcessorExtensionPoint.class);
        this.urlArtifactProcessor = (URLArtifactProcessor)documentProcessors.getProcessor(SCADefinitions.class);
    }

    public SCADefinitions getSCADefinition() throws SCADefinitionsProviderException {
        SCADefinitions scaDefns = null;
        SCADefinitions tuscanyDefns = null;
        try {
            URL definitionsFileUrl = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    return this.getClass().getClassLoader().getResource(SecurityPolicyDefinitionsProvider.this.definitionsFile);
                }
            });
            URI uri = new URI(this.definitionsFile);
            scaDefns = (SCADefinitions)this.urlArtifactProcessor.read(null, uri, definitionsFileUrl);
            definitionsFileUrl = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    return this.getClass().getClassLoader().getResource(SecurityPolicyDefinitionsProvider.tuscanyDefinitionsFile);
                }
            });
            uri = new URI(this.definitionsFile);
            tuscanyDefns = (SCADefinitions)this.urlArtifactProcessor.read(null, uri, definitionsFileUrl);
            SCADefinitionsUtil.aggregateSCADefinitions(tuscanyDefns, scaDefns);
            return scaDefns;
        }
        catch (Exception e) {
            throw new SCADefinitionsProviderException(e);
        }
    }
}

