/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.reliability;

import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.definitions.SCADefinitions;
import org.apache.tuscany.sca.provider.SCADefinitionsProvider;
import org.apache.tuscany.sca.provider.SCADefinitionsProviderException;

public class ReliabilityPolicyDefinitionsProvider
implements SCADefinitionsProvider {
    private String definitionsFile = "org/apache/tuscany/sca/policy/reliability/definitions.xml";
    URLArtifactProcessor urlArtifactProcessor = null;

    public ReliabilityPolicyDefinitionsProvider(ExtensionPointRegistry registry) {
        URLArtifactProcessorExtensionPoint documentProcessors = registry.getExtensionPoint(URLArtifactProcessorExtensionPoint.class);
        this.urlArtifactProcessor = (URLArtifactProcessor)documentProcessors.getProcessor(SCADefinitions.class);
    }

    public SCADefinitions getSCADefinition() throws SCADefinitionsProviderException {
        SCADefinitions scaDefns = null;
        Object tuscanyDefns = null;
        try {
            URL definitionsFileUrl = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    return this.getClass().getClassLoader().getResource(ReliabilityPolicyDefinitionsProvider.this.definitionsFile);
                }
            });
            URI uri = new URI(this.definitionsFile);
            scaDefns = (SCADefinitions)this.urlArtifactProcessor.read(null, uri, definitionsFileUrl);
            return scaDefns;
        }
        catch (Exception e) {
            throw new SCADefinitionsProviderException(e);
        }
    }
}

