/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.logging.jdk;

import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.logging.jdk.JDKLoggingPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKLoggingPolicyProcessor
implements StAXArtifactProcessor<JDKLoggingPolicy> {
    private static final QName JDK_LOGGING_POLICY_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "jdkLogger");
    private static final String LOG_LEVEL = "logLevel";
    private static final String RESOURCE_BUNDLE = "resourceBundle";
    private static final String USE_PARENT_HANDLERS = "useParentHandlers";
    private static final String TUSACNY_NS = "http://tuscany.apache.org/xmlns/sca/1.0";

    @Override
    public QName getArtifactType() {
        return JDK_LOGGING_POLICY_QNAME;
    }

    public JDKLoggingPolicyProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
    }

    @Override
    public JDKLoggingPolicy read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        JDKLoggingPolicy policy = new JDKLoggingPolicy();
        int event = reader.getEventType();
        QName name = null;
        while (reader.hasNext()) {
            event = reader.getEventType();
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (name.equals(JDK_LOGGING_POLICY_QNAME)) {
                        String loggerName = reader.getAttributeValue(null, "name");
                        policy.setLoggerName(loggerName);
                        break;
                    }
                    if (LOG_LEVEL.equals(name.getLocalPart())) {
                        policy.setLogLevel(Level.parse(reader.getElementText()));
                        break;
                    }
                    if (RESOURCE_BUNDLE.equals(name.getLocalPart())) {
                        policy.setResourceBundleName(reader.getElementText());
                        break;
                    }
                    if (!USE_PARENT_HANDLERS.equals(name.getLocalPart())) break;
                    policy.setUseParentHandlers(Boolean.getBoolean(reader.getElementText()));
                }
            }
            if (event == 2 && JDK_LOGGING_POLICY_QNAME.equals(reader.getName())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return policy;
    }

    @Override
    public void write(JDKLoggingPolicy policy, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        String prefix = "tuscany";
        writer.writeStartElement(prefix, JDK_LOGGING_POLICY_QNAME.getLocalPart(), JDK_LOGGING_POLICY_QNAME.getNamespaceURI());
        writer.writeNamespace("tuscany", TUSACNY_NS);
        if (policy.getLoggerName() != null) {
            writer.writeAttribute("name", policy.getLoggerName());
        }
        if (policy.getLogLevel() != null) {
            writer.writeStartElement(prefix, LOG_LEVEL, JDK_LOGGING_POLICY_QNAME.getNamespaceURI());
            writer.writeCharacters(policy.getLogLevel().getLocalizedName());
            writer.writeEndElement();
        }
        if (policy.getResourceBundleName() != null) {
            writer.writeStartElement(prefix, RESOURCE_BUNDLE, JDK_LOGGING_POLICY_QNAME.getNamespaceURI());
            writer.writeCharacters(policy.getResourceBundleName());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    @Override
    public Class<JDKLoggingPolicy> getModelType() {
        return JDKLoggingPolicy.class;
    }

    @Override
    public void resolve(JDKLoggingPolicy arg0, ModelResolver arg1) throws ContributionResolveException {
    }
}

