/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.logging.jdk;

import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.logging.jdk.JDKLoggingPolicy;

public class JDKLoggingPolicyInterceptor
implements Interceptor {
    public static final String loggingPolicy = "JDKLoggingPolicy";
    public static final QName policySetQName = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "JDKLoggingPolicy");
    private Logger logger = null;
    private Invoker next;
    private Operation operation;
    private PolicySet policySet = null;
    private String context;

    public JDKLoggingPolicyInterceptor(String context, Operation operation, PolicySet policySet) {
        this.operation = operation;
        this.policySet = policySet;
        this.context = context;
        this.init();
    }

    private void init() {
        if (this.policySet != null) {
            JDKLoggingPolicy policy = (JDKLoggingPolicy)this.policySet.getPolicies().get(0);
            this.logger = Logger.getLogger(policy.getLoggerName());
            this.logger.setLevel(policy.getLogLevel());
            this.logger.setUseParentHandlers(policy.isUseParentHandlers());
            boolean found = false;
            for (Handler handler : this.logger.getHandlers()) {
                if (!(handler instanceof ConsoleHandler)) continue;
                found = true;
                break;
            }
            if (!found) {
                ConsoleHandler consoleHandler = new ConsoleHandler();
                consoleHandler.setLevel(Level.ALL);
                this.logger.addHandler(consoleHandler);
            }
        }
    }

    public Message invoke(Message msg) {
        Object[] logParams;
        block10: {
            if (this.logger == null) {
                return this.getNext().invoke(msg);
            }
            Object msgBody = msg.getBody();
            if (msgBody instanceof Object[]) {
                this.logger.logp(Level.INFO, this.context, "", "Invoking operation - " + this.operation.getName());
                StringBuffer sb = new StringBuffer();
                if (msgBody == null) {
                    sb.append("");
                } else {
                    Object[] args = (Object[])msgBody;
                    for (int i = 0; i < args.length; ++i) {
                        sb.append(args[i]);
                        if (i == args.length - 1) continue;
                        sb.append(", ");
                    }
                }
                logParams = new Object[]{this.operation.getName(), sb.toString()};
                this.logger.logp(Level.FINER, this.context, "", "Invoking operation {0} with arguments {1}", logParams);
            }
            Object[] responseMsg = null;
            try {
                logParams = responseMsg = this.getNext().invoke(msg);
                if (responseMsg == null) break block10;
            }
            catch (RuntimeException e) {
                try {
                    this.logger.logp(Level.SEVERE, this.context, "", "Exception thrown from operation - " + this.operation.getName(), e);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (responseMsg != null) {
                        Object[] logParams2 = new Object[]{this.operation.getName(), responseMsg.getBody()};
                        this.logger.logp(Level.INFO, this.context, "", "Returned from operation - " + this.operation.getName());
                        this.logger.logp(Level.FINER, this.context, "", "Returning from operation {0} with return value {1}", logParams2);
                    }
                    throw throwable;
                }
            }
            Object[] logParams3 = new Object[]{this.operation.getName(), responseMsg.getBody()};
            this.logger.logp(Level.INFO, this.context, "", "Returned from operation - " + this.operation.getName());
            this.logger.logp(Level.FINER, this.context, "", "Returning from operation {0} with return value {1}", logParams3);
        }
        return logParams;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }
}

