/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.logging.jdk;

import org.apache.tuscany.sca.assembly.ConfiguredOperation;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.OperationsConfigurator;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.logging.jdk.JDKLoggingPolicy;
import org.apache.tuscany.sca.policy.logging.jdk.JDKLoggingPolicyInterceptor;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

public class JDKLoggingImplementationPolicyProvider
implements PolicyProvider {
    private RuntimeComponent component;
    private Implementation implementation;

    public JDKLoggingImplementationPolicyProvider(RuntimeComponent component, Implementation implementation) {
        this.component = component;
        this.implementation = implementation;
    }

    private String getContext() {
        return "component.implementation: " + this.component.getURI() + "(" + this.implementation.getClass().getName() + ")";
    }

    private PolicySet findPolicySet(Operation operation) {
        for (PolicySet ps : this.component.getPolicySets()) {
            for (Object p : ps.getPolicies()) {
                if (!JDKLoggingPolicy.class.isInstance(p)) continue;
                return ps;
            }
        }
        if (this.component instanceof OperationsConfigurator) {
            for (ConfiguredOperation confOp : ((OperationsConfigurator)((Object)this.component)).getConfiguredOperations()) {
                if (!confOp.getName().equals(operation.getName())) continue;
                for (PolicySet ps : confOp.getPolicySets()) {
                    for (Object p : ps.getPolicies()) {
                        if (!JDKLoggingPolicy.class.isInstance(p)) continue;
                        return ps;
                    }
                }
            }
        }
        return null;
    }

    public Interceptor createInterceptor(Operation operation) {
        PolicySet ps = this.findPolicySet(operation);
        return ps == null ? null : new JDKLoggingPolicyInterceptor(this.getContext(), operation, ps);
    }

    public String getPhase() {
        return "implementation.policy";
    }
}

