/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.osgi.runtime;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.osgi.runtime.EquinoxRuntime;
import org.apache.tuscany.sca.osgi.runtime.FelixRuntime;
import org.apache.tuscany.sca.osgi.runtime.KnopflerfishRuntime;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public abstract class OSGiRuntime {
    private static final Logger logger = Logger.getLogger(OSGiRuntime.class.getName());
    private static OSGiRuntime instance;
    private BundleContext bundleContext;
    private PackageAdmin packageAdmin;
    private boolean tuscanyRunningInOSGiContainer;
    private ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();

    public abstract BundleContext getBundleContext();

    public abstract boolean supportsBundleFragments();

    protected abstract BundleContext startRuntime(boolean var1) throws Exception;

    public static synchronized OSGiRuntime findRuntime() throws Exception {
        if (instance != null) {
            return instance;
        }
        String runtimeClassName = System.getProperty(OSGiRuntime.class.getName());
        if (runtimeClassName != null) {
            try {
                Class<?> runtimeClass = OSGiRuntime.class.getClassLoader().loadClass(runtimeClassName);
                Method method = runtimeClass.getMethod("getInstance", new Class[0]);
                instance = (OSGiRuntime)method.invoke(null, new Object[0]);
                return instance;
            }
            catch (Exception e) {
                throw new BundleException("Could not start OSGi runtime " + runtimeClassName, (Throwable)e);
            }
        }
        try {
            instance = EquinoxRuntime.getInstance();
            return instance;
        }
        catch (ClassNotFoundException e) {
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        try {
            instance = FelixRuntime.getInstance();
            return instance;
        }
        catch (ClassNotFoundException e) {
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        try {
            instance = KnopflerfishRuntime.getInstance();
            return instance;
        }
        catch (ClassNotFoundException e) {
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        throw new BundleException("Could not start OSGi runtime from the classpath");
    }

    public static synchronized OSGiRuntime getRuntime() throws Exception {
        return OSGiRuntime.getRuntime(false);
    }

    public static synchronized OSGiRuntime getRuntime(boolean tuscanyRunningInOSGiContainer) throws Exception {
        instance = OSGiRuntime.findRuntime();
        if (instance != null) {
            if (OSGiRuntime.instance.bundleContext == null) {
                OSGiRuntime.instance.tuscanyRunningInOSGiContainer = tuscanyRunningInOSGiContainer;
                instance.startRuntime(tuscanyRunningInOSGiContainer);
                instance.initialize();
            }
            return instance;
        }
        return instance;
    }

    public void shutdown() throws Exception {
        this.bundleContext = null;
        this.packageAdmin = null;
    }

    protected void setBundleContext(BundleContext bundleContext) {
        OSGiRuntime.instance.tuscanyRunningInOSGiContainer = true;
        this.bundleContext = bundleContext;
    }

    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    protected void setContextClassLoader(ClassLoader contextClassLoader) {
        this.contextClassLoader = contextClassLoader;
    }

    protected void initialize() {
        ServiceReference packageAdminReference;
        this.bundleContext = this.getBundleContext();
        if (this.bundleContext != null && (packageAdminReference = this.bundleContext.getServiceReference("org.osgi.service.packageadmin.PackageAdmin")) != null) {
            this.packageAdmin = (PackageAdmin)this.bundleContext.getService(packageAdminReference);
        }
    }

    public Bundle findBundle(String bundleSymbolicName, String bundleVersion) {
        if (this.bundleContext != null) {
            Bundle[] installedBundles;
            for (Bundle bundle : installedBundles = this.bundleContext.getBundles()) {
                if (!bundleSymbolicName.equals(bundle.getSymbolicName()) || bundleVersion != null && !bundleVersion.equals(bundle.getHeaders().get("Bundle-Version"))) continue;
                return bundle;
            }
        }
        return null;
    }

    public static synchronized Bundle findInstalledBundle(String bundleLocation) {
        if (instance != null) {
            if (bundleLocation.startsWith("bundle:") || bundleLocation.startsWith("bundleresource:")) {
                try {
                    return OSGiRuntime.findInstalledBundle(new URL(bundleLocation));
                }
                catch (MalformedURLException malformedURLException) {
                }
            } else {
                return instance.findBundle(bundleLocation);
            }
        }
        return null;
    }

    public static synchronized Bundle findInstalledBundle(URL bundleURL) {
        if (instance != null) {
            if (OSGiRuntime.instance.bundleContext != null) {
                Bundle[] installedBundles;
                for (Bundle bundle : installedBundles = OSGiRuntime.instance.bundleContext.getBundles()) {
                    try {
                        if (bundle.getEntry("/").getHost().equals(bundleURL.getHost())) {
                            return bundle;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            return null;
        }
        return null;
    }

    public Bundle findBundle(String bundleLocation) {
        if (this.bundleContext != null) {
            Bundle[] installedBundles;
            for (Bundle bundle : installedBundles = this.bundleContext.getBundles()) {
                if (!bundle.getLocation().equals(bundleLocation)) continue;
                return bundle;
            }
        }
        return null;
    }

    public Bundle installBundle(String bundleLocation, InputStream inputStream) {
        try {
            if (this.bundleContext != null) {
                Bundle bundle = this.findBundle(bundleLocation);
                if (bundle != null) {
                    return bundle;
                }
                bundle = inputStream == null ? this.bundleContext.installBundle(bundleLocation) : this.bundleContext.installBundle(bundleLocation, inputStream);
                if (bundle != null && this.packageAdmin != null) {
                    this.packageAdmin.refreshPackages(null);
                }
                return bundle;
            }
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
        return null;
    }

    public static synchronized void stop() throws Exception {
        if (instance != null && !OSGiRuntime.instance.tuscanyRunningInOSGiContainer) {
            instance.shutdown();
            instance = null;
        }
    }
}

