/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.launcher;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.node.launcher.Contribution;
import org.apache.tuscany.sca.node.launcher.DomainManagerLauncher;
import org.apache.tuscany.sca.node.launcher.LauncherException;
import org.apache.tuscany.sca.node.launcher.NodeDaemonLauncher;
import org.apache.tuscany.sca.node.launcher.NodeLauncher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NodeLauncherUtil {
    private static final Logger logger = Logger.getLogger(NodeLauncherUtil.class.getName());
    private static final String TUSCANY_HOME = "TUSCANY_HOME";
    private static final String TUSCANY_PATH = "TUSCANY_PATH";

    NodeLauncherUtil() {
    }

    static ClassLoader standAloneRuntimeClassLoader(ClassLoader parentClassLoader) throws FileNotFoundException, URISyntaxException, MalformedURLException {
        return NodeLauncherUtil.runtimeClassLoader(parentClassLoader, new StandAloneJARFileNameFilter());
    }

    static ClassLoader webAppRuntimeClassLoader(ClassLoader parentClassLoader) throws FileNotFoundException, URISyntaxException, MalformedURLException {
        return NodeLauncherUtil.runtimeClassLoader(parentClassLoader, new WebAppJARFileNameFilter());
    }

    private static ClassLoader runtimeClassLoader(ClassLoader parentClassLoader, FilenameFilter filter) throws FileNotFoundException, URISyntaxException, MalformedURLException {
        String ext;
        String home;
        HashSet<URL> jarDirectoryURLs = new HashSet<URL>();
        ArrayList<URL> jarURLs = new ArrayList<URL>();
        String resource = NodeLauncherUtil.class.getName().replace('.', '/') + ".class";
        URL url = NodeLauncherUtil.class.getClassLoader().getResource(resource);
        if (url == null) {
            throw new FileNotFoundException(resource);
        }
        URI uri = url.toURI();
        String scheme = uri.getScheme();
        if (scheme.equals("jar")) {
            File jarDirectory;
            File file;
            String path = uri.toString().substring(4);
            int i = path.indexOf("!/");
            if (i != -1) {
                path = path.substring(0, i);
                uri = URI.create(path);
            }
            if ((file = new File(uri)).exists() && (jarDirectory = file.getParentFile()) != null && jarDirectory.exists()) {
                URL jarDirectoryURL = jarDirectory.toURI().toURL();
                jarDirectoryURLs.add(jarDirectoryURL);
                NodeLauncherUtil.collectJARFiles(jarDirectory, jarURLs, filter);
                File homeDirectory = jarDirectory.getParentFile();
                if (homeDirectory != null && homeDirectory.exists()) {
                    File libDirectory;
                    URL libDirectoryURL;
                    File modulesDirectory = new File(homeDirectory, "modules");
                    URL modulesDirectoryURL = modulesDirectory.toURI().toURL();
                    if (!jarDirectoryURLs.contains(modulesDirectoryURL) && modulesDirectory.exists()) {
                        jarDirectoryURLs.add(modulesDirectoryURL);
                        NodeLauncherUtil.collectJARFiles(modulesDirectory, jarURLs, filter);
                    }
                    if (!jarDirectoryURLs.contains(libDirectoryURL = (libDirectory = new File(homeDirectory, "lib")).toURI().toURL()) && libDirectory.exists()) {
                        jarDirectoryURLs.add(libDirectoryURL);
                        NodeLauncherUtil.collectJARFiles(libDirectory, jarURLs, filter);
                    }
                }
            }
        }
        if ((home = System.getProperty(TUSCANY_HOME)) == null || home.length() == 0) {
            home = System.getenv(TUSCANY_HOME);
        }
        if (home != null && home.length() != 0) {
            logger.fine("TUSCANY_HOME: " + home);
            NodeLauncherUtil.collectJARFiles(home, jarDirectoryURLs, jarURLs, filter);
        }
        if ((ext = System.getProperty(TUSCANY_PATH)) == null || ext.length() == 0) {
            ext = System.getenv(TUSCANY_PATH);
        }
        if (ext != null && ext.length() != 0) {
            logger.fine("TUSCANY_PATH: " + ext);
            String separator = System.getProperty("path.separator");
            StringTokenizer tokens = new StringTokenizer(ext, separator);
            while (tokens.hasMoreTokens()) {
                NodeLauncherUtil.collectJARFiles(tokens.nextToken(), jarDirectoryURLs, jarURLs, filter);
            }
        }
        if (!jarURLs.isEmpty()) {
            RuntimeClassLoader classLoader = new RuntimeClassLoader(jarURLs.toArray(new URL[jarURLs.size()]), parentClassLoader);
            return classLoader;
        }
        return null;
    }

    private static void collectJARFiles(String directory, Set<URL> jarDirectoryURLs, List<URL> jarURLs, FilenameFilter filter) throws MalformedURLException {
        File directoryFile = new File(directory);
        URL directoryURL = directoryFile.toURI().toURL();
        if (!jarDirectoryURLs.contains(directoryURL) && directoryFile.exists()) {
            File libDirectory;
            URL libDirectoryURL;
            jarDirectoryURLs.add(directoryURL);
            NodeLauncherUtil.collectJARFiles(directoryFile, jarURLs, filter);
            File modulesDirectory = new File(directoryFile, "modules");
            URL modulesDirectoryURL = modulesDirectory.toURI().toURL();
            if (!jarDirectoryURLs.contains(modulesDirectoryURL) && modulesDirectory.exists()) {
                jarDirectoryURLs.add(modulesDirectoryURL);
                NodeLauncherUtil.collectJARFiles(modulesDirectory, jarURLs, filter);
            }
            if (!jarDirectoryURLs.contains(libDirectoryURL = (libDirectory = new File(directoryFile, "lib")).toURI().toURL()) && libDirectory.exists()) {
                jarDirectoryURLs.add(libDirectoryURL);
                NodeLauncherUtil.collectJARFiles(libDirectory, jarURLs, filter);
            }
        }
    }

    private static void collectJARFiles(File directory, List<URL> urls, FilenameFilter filter) throws MalformedURLException {
        String[] files = directory.list(filter);
        if (files != null) {
            URL directoryURL = new URL(directory.toURI().toString() + "/");
            int count = 0;
            for (String file : files) {
                URL url = new URL(directoryURL, file);
                urls.add(url);
                ++count;
            }
            if (count != 0) {
                logger.fine("Runtime classpath: " + count + " JAR" + (count > 1 ? "s" : "") + " from " + directory.toString());
            }
        }
    }

    static Object node(String configurationURI, String compositeURI, String compositeContent, Contribution[] contributions, ClassLoader contributionClassLoader) throws LauncherException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Object node;
            String[] uris;
            Constructor<?> constructor;
            Object bootstrap;
            ClassLoader runtimeClassLoader = NodeLauncherUtil.runtimeClassLoader(Thread.currentThread().getContextClassLoader(), new StandAloneJARFileNameFilter());
            if (runtimeClassLoader != null) {
                Thread.currentThread().setContextClassLoader(runtimeClassLoader);
            }
            String className = "org.apache.tuscany.sca.implementation.node.launcher.NodeImplementationLauncherBootstrap";
            Class<?> bootstrapClass = runtimeClassLoader != null ? Class.forName(className, true, runtimeClassLoader) : Class.forName(className);
            if (configurationURI != null) {
                bootstrap = bootstrapClass.getConstructor(String.class).newInstance(configurationURI);
            } else if (contributionClassLoader != null) {
                constructor = bootstrapClass.getConstructor(String.class, ClassLoader.class);
                bootstrap = constructor.newInstance(compositeURI, contributionClassLoader);
            } else if (compositeContent != null) {
                constructor = bootstrapClass.getConstructor(String.class, String.class, String[].class, String[].class);
                uris = new String[contributions.length];
                String[] locations = new String[contributions.length];
                for (int i = 0; i < contributions.length; ++i) {
                    uris[i] = contributions[i].getURI();
                    locations[i] = contributions[i].getLocation();
                }
                bootstrap = constructor.newInstance(compositeURI, compositeContent, uris, locations);
            } else {
                constructor = bootstrapClass.getConstructor(String.class, String[].class, String[].class);
                uris = new String[contributions.length];
                String[] locations = new String[contributions.length];
                for (int i = 0; i < contributions.length; ++i) {
                    uris[i] = contributions[i].getURI();
                    locations[i] = contributions[i].getLocation();
                }
                bootstrap = constructor.newInstance(compositeURI, uris, locations);
            }
            Object object = node = bootstrapClass.getMethod("getNode", new Class[0]).invoke(bootstrap, new Object[0]);
            return object;
        }
        catch (Exception e) {
            NodeLauncher.logger.log(Level.SEVERE, "SCA Node could not be created", e);
            throw new LauncherException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    static Object nodeDaemon() throws LauncherException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Object nodeDaemon;
            ClassLoader runtimeClassLoader = NodeLauncherUtil.runtimeClassLoader(Thread.currentThread().getContextClassLoader(), new StandAloneJARFileNameFilter());
            if (runtimeClassLoader != null) {
                Thread.currentThread().setContextClassLoader(runtimeClassLoader);
            }
            String className = "org.apache.tuscany.sca.implementation.node.launcher.NodeImplementationDaemonBootstrap";
            Class<?> bootstrapClass = runtimeClassLoader != null ? Class.forName(className, true, runtimeClassLoader) : Class.forName(className);
            Object bootstrap = bootstrapClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Object object = nodeDaemon = bootstrapClass.getMethod("getNode", new Class[0]).invoke(bootstrap, new Object[0]);
            return object;
        }
        catch (Exception e) {
            NodeDaemonLauncher.logger.log(Level.SEVERE, "SCA Node Daemon could not be created", e);
            throw new LauncherException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    static Object domainManager(String rootDirectory) throws LauncherException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Object domainManager;
            ClassLoader runtimeClassLoader = NodeLauncherUtil.runtimeClassLoader(Thread.currentThread().getContextClassLoader(), new StandAloneJARFileNameFilter());
            if (runtimeClassLoader != null) {
                Thread.currentThread().setContextClassLoader(runtimeClassLoader);
            }
            String className = "org.apache.tuscany.sca.domain.manager.launcher.DomainManagerLauncherBootstrap";
            Class<?> bootstrapClass = runtimeClassLoader != null ? Class.forName(className, true, runtimeClassLoader) : Class.forName(className);
            Constructor<?> constructor = bootstrapClass.getConstructor(String.class);
            Object bootstrap = constructor.newInstance(rootDirectory);
            Object object = domainManager = bootstrapClass.getMethod("getNode", new Class[0]).invoke(bootstrap, new Object[0]);
            return object;
        }
        catch (Exception e) {
            DomainManagerLauncher.logger.log(Level.SEVERE, "SCA Domain Manager could not be created", e);
            throw new LauncherException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RuntimeClassLoader
    extends URLClassLoader {
        private static final ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        private ClassLoader parent;

        private RuntimeClassLoader(URL[] urls, ClassLoader parent) {
            super(urls);
            this.parent = parent;
        }

        @Override
        public URL findResource(String name) {
            URL url = super.findResource(name);
            if (url == null) {
                url = this.parent.getResource(name);
            }
            return url;
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            Enumeration<URL> resources = super.findResources(name);
            Enumeration<URL> parentResources = this.parent.getResources(name);
            ArrayList<URL> allResources = new ArrayList<URL>();
            while (resources.hasMoreElements()) {
                allResources.add(resources.nextElement());
            }
            while (parentResources.hasMoreElements()) {
                allResources.add(parentResources.nextElement());
            }
            return Collections.enumeration(allResources);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> cl;
            try {
                cl = this.parent.loadClass(name);
                ClassLoader loadedBy = cl.getClassLoader();
                if (loadedBy != this.parent && loadedBy != systemClassLoader && loadedBy != null) {
                    try {
                        cl = super.findClass(name);
                    }
                    catch (ClassNotFoundException e) {}
                }
            }
            catch (ClassNotFoundException e) {
                cl = super.findClass(name);
            }
            return cl;
        }
    }

    private static class WebAppJARFileNameFilter
    extends StandAloneJARFileNameFilter {
        private WebAppJARFileNameFilter() {
        }

        public boolean accept(File dir, String name) {
            if (!super.accept(dir, name)) {
                return false;
            }
            if ((name = name.toLowerCase()).startsWith("servlet-api")) {
                return false;
            }
            return !name.startsWith("tuscany-host-tomcat") && !name.startsWith("tuscany-host-jetty");
        }
    }

    private static class StandAloneJARFileNameFilter
    implements FilenameFilter {
        private StandAloneJARFileNameFilter() {
        }

        public boolean accept(File dir, String name) {
            if ((name = name.toLowerCase()).startsWith("tuscany-sca-all")) {
                return false;
            }
            if (name.startsWith("tuscany-sca-manifest")) {
                return false;
            }
            if (name.startsWith("tuscany-host-tomcat") || name.startsWith("tuscany-host-webapp")) {
                return false;
            }
            if (name.endsWith(".jar")) {
                return true;
            }
            return name.endsWith(".mar");
        }
    }
}

