/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.launcher;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.node.launcher.LauncherException;
import org.apache.tuscany.sca.node.launcher.NodeLauncherUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDaemonLauncher {
    static final Logger logger = Logger.getLogger(NodeDaemonLauncher.class.getName());

    private NodeDaemonLauncher() {
    }

    public static NodeDaemonLauncher newInstance() {
        return new NodeDaemonLauncher();
    }

    public <T> T createNodeDaemon() throws LauncherException {
        return (T)NodeLauncherUtil.nodeDaemon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block17: {
            logger.info("Apache Tuscany SCA Node Daemon is starting...");
            NodeDaemonLauncher launcher = NodeDaemonLauncher.newInstance();
            Object node = null;
            ShutdownThread shutdown = null;
            try {
                int k;
                do {
                    node = launcher.createNodeDaemon();
                    try {
                        node.getClass().getMethod("start", new Class[0]).invoke(node, new Object[0]);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "SCA Node Daemon could not be started", e);
                        throw e;
                    }
                    logger.info("SCA Node Daemon is now started.");
                    shutdown = new ShutdownThread(node);
                    Runtime.getRuntime().addShutdownHook(shutdown);
                    logger.info("Press 'q' to quit, 'r' to restart.");
                    k = 0;
                    try {
                        while (k != 113 && k != 114) {
                            k = System.in.read();
                        }
                    }
                    catch (IOException e) {
                        Object lock;
                        Object object = lock = new Object();
                        synchronized (object) {
                            lock.wait();
                        }
                    }
                    if (node == null) continue;
                    Object n = node;
                    node = null;
                    NodeDaemonLauncher.stopNode(n);
                } while (k != 113);
                if (shutdown == null) break block17;
                Runtime.getRuntime().removeShutdownHook(shutdown);
            }
            catch (Exception e) {
                try {
                    if (node != null) {
                        try {
                            Object n = node;
                            node = null;
                            NodeDaemonLauncher.stopNode(n);
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    if (shutdown != null) {
                        Runtime.getRuntime().removeShutdownHook(shutdown);
                    }
                    throw throwable;
                }
            }
        }
    }

    private static void stopNode(Object node) throws Exception {
        try {
            node.getClass().getMethod("stop", new Class[0]).invoke(node, new Object[0]);
            logger.info("SCA Node Daemon is now stopped.");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SCA Node Daemon could not be stopped", e);
            throw e;
        }
    }

    private static class ShutdownThread
    extends Thread {
        private Object node;

        public ShutdownThread(Object node) {
            this.node = node;
        }

        public void run() {
            try {
                NodeDaemonLauncher.stopNode(this.node);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

