/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.wsdl.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensionDeserializer;
import javax.wsdl.extensions.UnknownExtensionSerializer;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.DefaultImport;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImport;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionRuntimeException;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.xml.BPELExtensionHandler;
import org.apache.tuscany.sca.xsd.XSDFactory;
import org.apache.tuscany.sca.xsd.XSDefinition;
import org.apache.tuscany.sca.xsd.xml.XMLDocumentHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLModelResolver
implements ModelResolver {
    public static final String ELEM_SCHEMA = "schema";
    public static final String NS_URI_XSD_1999 = "http://www.w3.org/1999/XMLSchema";
    public static final String NS_URI_XSD_2000 = "http://www.w3.org/2000/10/XMLSchema";
    public static final String NS_URI_XSD_2001 = "http://www.w3.org/2001/XMLSchema";
    public static final QName Q_ELEM_XSD_1999 = new QName("http://www.w3.org/1999/XMLSchema", "schema");
    public static final QName Q_ELEM_XSD_2000 = new QName("http://www.w3.org/2000/10/XMLSchema", "schema");
    public static final QName Q_ELEM_XSD_2001 = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    public static final List<QName> XSD_QNAME_LIST = Arrays.asList(Q_ELEM_XSD_1999, Q_ELEM_XSD_2000, Q_ELEM_XSD_2001);
    public static final QName Q_POLICY_ATTRIBUTE_EXTENSION = new QName("http://www.osoa.org/xmlns/sca/1.0", "requires");
    public static final QName Q_POLICY_END_CONVERSATION_ATTRIBUTE_EXTENSION = new QName("http://www.osoa.org/xmlns/sca/1.0", "endsConversation");
    public static final String ELEM_PLINKTYPE = "partnerLinkType";
    public static final String NS_BPEL_1_1 = "http://schemas.xmlsoap.org/ws/2004/03/partner-link/";
    public static final QName BPEL_PLINKTYPE = new QName("http://schemas.xmlsoap.org/ws/2004/03/partner-link/", "partnerLinkType");
    private Contribution contribution;
    private Map<String, List<WSDLDefinition>> map = new HashMap<String, List<WSDLDefinition>>();
    private ExtensionRegistry wsdlExtensionRegistry;
    private WSDLFactory wsdlFactory;
    private javax.wsdl.factory.WSDLFactory wsdl4jFactory;
    private ContributionFactory contributionFactory;
    private XSDFactory xsdFactory;

    public WSDLModelResolver(Contribution contribution, ModelFactoryExtensionPoint modelFactories) {
        this.contribution = contribution;
        this.wsdlFactory = modelFactories.getFactory(WSDLFactory.class);
        this.wsdl4jFactory = modelFactories.getFactory(javax.wsdl.factory.WSDLFactory.class);
        this.contributionFactory = modelFactories.getFactory(ContributionFactory.class);
        this.xsdFactory = modelFactories.getFactory(XSDFactory.class);
        this.wsdlExtensionRegistry = this.wsdl4jFactory.newPopulatedExtensionRegistry();
        Object deserializer = new UnknownExtensionDeserializer();
        Object serializer = new UnknownExtensionSerializer();
        for (QName schema : XSD_QNAME_LIST) {
            this.wsdlExtensionRegistry.registerSerializer(Types.class, schema, (ExtensionSerializer)serializer);
            this.wsdlExtensionRegistry.registerDeserializer(Types.class, schema, (ExtensionDeserializer)deserializer);
        }
        try {
            this.wsdlExtensionRegistry.registerExtensionAttributeType(PortType.class, Q_POLICY_ATTRIBUTE_EXTENSION, 3);
            this.wsdlExtensionRegistry.registerExtensionAttributeType(Operation.class, Q_POLICY_END_CONVERSATION_ATTRIBUTE_EXTENSION, 0);
        }
        catch (NoSuchMethodError e) {
            // empty catch block
        }
        serializer = new BPELExtensionHandler();
        deserializer = new BPELExtensionHandler();
        this.wsdlExtensionRegistry.registerSerializer(Definition.class, BPEL_PLINKTYPE, (ExtensionSerializer)serializer);
        this.wsdlExtensionRegistry.registerDeserializer(Definition.class, BPEL_PLINKTYPE, (ExtensionDeserializer)deserializer);
    }

    @Override
    public void addModel(Object resolved) {
        WSDLDefinition definition = (WSDLDefinition)resolved;
        for (XSDefinition d : definition.getXmlSchemas()) {
            if (this.contribution == null) continue;
            this.contribution.getModelResolver().addModel(d);
        }
        List<WSDLDefinition> list = this.map.get(definition.getNamespace());
        if (list == null) {
            list = new ArrayList<WSDLDefinition>();
            this.map.put(definition.getNamespace(), list);
        }
        list.add(definition);
    }

    @Override
    public Object removeModel(Object resolved) {
        WSDLDefinition definition = (WSDLDefinition)resolved;
        List<WSDLDefinition> list = this.map.get(definition.getNamespace());
        if (list == null) {
            return null;
        }
        return list.remove(definition);
    }

    private WSDLDefinition aggregate(List<WSDLDefinition> definitions) {
        if (definitions == null || definitions.size() == 0) {
            return null;
        }
        if (definitions.size() == 1) {
            WSDLDefinition d = definitions.get(0);
            this.loadOnDemand(d);
            return d;
        }
        WSDLDefinition aggregated = this.wsdlFactory.createWSDLDefinition();
        for (WSDLDefinition d : definitions) {
            this.loadOnDemand(d);
        }
        Definition facade = this.wsdl4jFactory.newDefinition();
        String ns = definitions.get(0).getNamespace();
        facade.setQName(new QName(ns, "$aggregated$"));
        facade.setTargetNamespace(ns);
        for (WSDLDefinition d : definitions) {
            if (d.getDefinition() == null) continue;
            javax.wsdl.Import imp = facade.createImport();
            imp.setNamespaceURI(d.getNamespace());
            imp.setDefinition(d.getDefinition());
            imp.setLocationURI(d.getDefinition().getDocumentBaseURI());
            facade.addImport(imp);
            aggregated.getXmlSchemas().addAll(d.getXmlSchemas());
            aggregated.getImportedDefinitions().add(d);
        }
        aggregated.setDefinition(facade);
        definitions.clear();
        definitions.add(aggregated);
        return aggregated;
    }

    @Override
    public <T> T resolveModel(Class<T> modelClass, T unresolved) {
        String namespace = ((WSDLDefinition)unresolved).getNamespace();
        if (namespace == null) {
            return modelClass.cast(unresolved);
        }
        List<WSDLDefinition> list = this.map.get(namespace);
        WSDLDefinition resolved = this.aggregate(list);
        if (resolved != null && !resolved.isUnresolved()) {
            return modelClass.cast(resolved);
        }
        for (Import import_ : this.contribution.getImports()) {
            NamespaceImport namespaceImport;
            if (!(import_ instanceof NamespaceImport ? (namespaceImport = (NamespaceImport)import_).getNamespace().equals(namespace) && !(resolved = namespaceImport.getModelResolver().resolveModel(WSDLDefinition.class, (WSDLDefinition)unresolved)).isUnresolved() : import_ instanceof DefaultImport && !(resolved = import_.getModelResolver().resolveModel(WSDLDefinition.class, (WSDLDefinition)unresolved)).isUnresolved())) continue;
            return modelClass.cast(resolved);
        }
        return modelClass.cast(unresolved);
    }

    private void loadOnDemand(WSDLDefinition def) {
        if (def.getDefinition() == null && def.getLocation() != null) {
            try {
                this.loadDefinition(def);
            }
            catch (ContributionReadException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void loadDefinition(WSDLDefinition wsdlDef) throws ContributionReadException {
        if (wsdlDef.getDefinition() != null || wsdlDef.getLocation() == null) {
            return;
        }
        try {
            URL artifactURL = wsdlDef.getLocation().toURL();
            InputStream is = artifactURL.openStream();
            WSDLReader reader = this.wsdl4jFactory.newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            reader.setFeature("javax.wsdl.importDocuments", true);
            reader.setExtensionRegistry(this.wsdlExtensionRegistry);
            WSDLLocatorImpl locator = new WSDLLocatorImpl(artifactURL, is);
            Definition definition = reader.readWSDL((WSDLLocator)locator);
            wsdlDef.setDefinition(definition);
            for (Map.Entry entry : definition.getImports().entrySet()) {
                if (((String)entry.getKey()).equals(definition.getTargetNamespace())) continue;
                WSDLDefinition wsdlDefinition = this.wsdlFactory.createWSDLDefinition();
                wsdlDefinition.setUnresolved(true);
                wsdlDefinition.setNamespace((String)entry.getKey());
                WSDLDefinition resolved = this.resolveModel(WSDLDefinition.class, wsdlDefinition);
                if (resolved.isUnresolved()) continue;
                block4: for (javax.wsdl.Import imp : (List)entry.getValue()) {
                    if (resolved.getDefinition().getDocumentBaseURI().equals(imp.getDefinition().getDocumentBaseURI())) {
                        wsdlDef.getImportedDefinitions().add(resolved);
                        continue;
                    }
                    for (WSDLDefinition def : resolved.getImportedDefinitions()) {
                        if (!def.getDefinition().getDocumentBaseURI().equals(imp.getDefinition().getDocumentBaseURI())) continue;
                        wsdlDef.getImportedDefinitions().add(def);
                        continue block4;
                    }
                }
            }
            this.readInlineSchemas(wsdlDef, definition);
        }
        catch (WSDLException e) {
            throw new ContributionReadException(e);
        }
        catch (IOException e) {
            throw new ContributionReadException(e);
        }
    }

    private Document promote(Element element) {
        Document doc = (Document)element.getOwnerDocument().cloneNode(false);
        Element schema = (Element)doc.importNode(element, true);
        doc.appendChild(schema);
        Node parent = element.getParentNode();
        while (parent instanceof Element) {
            Element root = (Element)parent;
            NamedNodeMap nodeMap = root.getAttributes();
            if (nodeMap != null) {
                for (int i = 0; i < nodeMap.getLength(); ++i) {
                    Attr attr = (Attr)nodeMap.item(i);
                    String name = attr.getName();
                    if (!"xmlns".equals(name) && !name.startsWith("xmlns:") || schema.getAttributeNode(name) != null) continue;
                    schema.setAttributeNodeNS((Attr)doc.importNode(attr, true));
                }
            }
            parent = parent.getParentNode();
        }
        doc.setDocumentURI(element.getOwnerDocument().getDocumentURI());
        return doc;
    }

    private void readInlineSchemas(WSDLDefinition wsdlDefinition, Definition definition) {
        if (this.contribution == null) {
            return;
        }
        Types types = definition.getTypes();
        if (types != null) {
            int index = 0;
            for (Object ext : types.getExtensibilityElements()) {
                ExtensibilityElement extElement = (ExtensibilityElement)ext;
                Element element = null;
                if (XSD_QNAME_LIST.contains(extElement.getElementType())) {
                    if (extElement instanceof Schema) {
                        element = ((Schema)extElement).getElement();
                    } else if (extElement instanceof UnknownExtensibilityElement) {
                        element = ((UnknownExtensibilityElement)extElement).getElement();
                    }
                }
                if (element == null) continue;
                Document doc = this.promote(element);
                XSDefinition xsDefinition = this.xsdFactory.createXSDefinition();
                xsDefinition.setUnresolved(true);
                xsDefinition.setNamespace(element.getAttribute("targetNamespace"));
                xsDefinition.setDocument(doc);
                xsDefinition.setLocation(URI.create(doc.getDocumentURI() + "#" + index));
                XSDefinition resolved = this.contribution.getModelResolver().resolveModel(XSDefinition.class, xsDefinition);
                if (resolved != null && !resolved.isUnresolved() && !wsdlDefinition.getXmlSchemas().contains(resolved)) {
                    wsdlDefinition.getXmlSchemas().add(xsDefinition);
                }
                ++index;
            }
        }
        for (Object imports : definition.getImports().values()) {
            List impList = (List)imports;
            for (Object i : impList) {
                javax.wsdl.Import anImport = (javax.wsdl.Import)i;
                if (anImport.getDefinition() == null) continue;
                this.readInlineSchemas(wsdlDefinition, anImport.getDefinition());
            }
        }
    }

    private class WSDLLocatorImpl
    implements WSDLLocator {
        private InputStream inputStream;
        private URL base;
        private String latestImportURI;

        public WSDLLocatorImpl(URL base, InputStream is) {
            this.base = base;
            this.inputStream = is;
        }

        public void close() {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public InputSource getBaseInputSource() {
            try {
                return XMLDocumentHelper.getInputSource(this.base, this.inputStream);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public String getBaseURI() {
            return this.base.toString();
        }

        public InputSource getImportInputSource(String parentLocation, String importLocation) {
            try {
                if (importLocation == null) {
                    throw new IllegalArgumentException("Required attribute 'location' is missing.");
                }
                URL url = null;
                if (importLocation.startsWith("/")) {
                    String uri = importLocation.substring(1);
                    Artifact proxyArtifact = WSDLModelResolver.this.contributionFactory.createArtifact();
                    proxyArtifact.setURI(uri);
                    Artifact importedArtifact = WSDLModelResolver.this.contribution.getModelResolver().resolveModel(Artifact.class, proxyArtifact);
                    if (importedArtifact.getLocation() != null) {
                        url = new URL(importedArtifact.getLocation());
                    }
                } else {
                    url = new URL(new URL(parentLocation), importLocation);
                }
                if (url == null) {
                    return null;
                }
                this.latestImportURI = url.toString();
                return XMLDocumentHelper.getInputSource(url);
            }
            catch (Exception e) {
                throw new ContributionRuntimeException(e);
            }
        }

        public String getLatestImportURI() {
            return this.latestImportURI;
        }
    }
}

