/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperInfo {
    private ElementInfo inputWrapperElement;
    private ElementInfo outputWrapperElement;
    private List<ElementInfo> inputChildElements;
    private List<ElementInfo> outputChildElements;
    private DataType<List<DataType>> unwrappedInputType;
    private DataType<XMLType> unwrappedOutputType;
    private String dataBinding;
    private DataType<XMLType> inputWrapperType;
    private DataType<XMLType> outputWrapperType;

    public WrapperInfo(String dataBinding, ElementInfo inputWrapperElement, ElementInfo outputWrapperElement, List<ElementInfo> inputElements, List<ElementInfo> outputElements) {
        this.dataBinding = dataBinding;
        this.inputWrapperElement = inputWrapperElement;
        this.outputWrapperElement = outputWrapperElement;
        this.inputChildElements = inputElements;
        this.outputChildElements = outputElements;
    }

    public List<ElementInfo> getInputChildElements() {
        return this.inputChildElements;
    }

    public ElementInfo getInputWrapperElement() {
        return this.inputWrapperElement;
    }

    public List<ElementInfo> getOutputChildElements() {
        return this.outputChildElements;
    }

    public ElementInfo getOutputWrapperElement() {
        return this.outputWrapperElement;
    }

    public DataType<List<DataType>> getUnwrappedInputType() {
        if (this.unwrappedInputType == null) {
            ArrayList<DataType> childTypes = new ArrayList<DataType>();
            for (ElementInfo element : this.getInputChildElements()) {
                DataType type = this.getDataType(element);
                childTypes.add(type);
            }
            this.unwrappedInputType = new DataTypeImpl("idl:unwrapped.input", Object[].class, childTypes);
        }
        return this.unwrappedInputType;
    }

    private DataType getDataType(ElementInfo element) {
        DataTypeImpl<Object> type = null;
        if (element.isMany()) {
            DataTypeImpl<XMLType> logical = new DataTypeImpl<XMLType>(this.dataBinding, Object.class, new XMLType(element));
            type = new DataTypeImpl<DataTypeImpl<XMLType>>("java:array", Object[].class, logical);
        } else {
            type = new DataTypeImpl<XMLType>(this.dataBinding, Object.class, new XMLType(element));
        }
        return type;
    }

    public DataType getUnwrappedOutputType() {
        List<ElementInfo> elements;
        if (this.unwrappedOutputType == null && (elements = this.getOutputChildElements()) != null && elements.size() > 0) {
            if (elements.size() > 1) {
                // empty if block
            }
            ElementInfo element = elements.get(0);
            this.unwrappedOutputType = this.getDataType(element);
        }
        return this.unwrappedOutputType;
    }

    public Class<?> getInputWrapperClass() {
        return this.inputWrapperType == null ? null : this.inputWrapperType.getPhysical();
    }

    public Class<?> getOutputWrapperClass() {
        return this.outputWrapperType == null ? null : this.outputWrapperType.getPhysical();
    }

    public String getDataBinding() {
        return this.dataBinding;
    }

    public void setDataBinding(String dataBinding) {
        this.dataBinding = dataBinding;
    }

    public DataType<XMLType> getInputWrapperType() {
        return this.inputWrapperType;
    }

    public void setInputWrapperType(DataType<XMLType> inputWrapperType) {
        this.inputWrapperType = inputWrapperType;
    }

    public DataType<XMLType> getOutputWrapperType() {
        return this.outputWrapperType;
    }

    public void setOutputWrapperType(DataType<XMLType> outputWrapperType) {
        this.outputWrapperType = outputWrapperType;
    }
}

