/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPointType;
import org.apache.tuscany.sca.policy.PolicySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceImpl
implements Interface {
    private boolean remotable;
    private boolean conversational;
    private OperationList operations = new OperationList();
    private boolean unresolved;
    private List<PolicySet> applicablePolicySets = new ArrayList<PolicySet>();
    private IntentAttachPointType type;
    private List<PolicySet> policySets = new ArrayList<PolicySet>();
    private List<Intent> requiredIntents = new ArrayList<Intent>();

    @Override
    public boolean isRemotable() {
        return this.remotable;
    }

    @Override
    public void setRemotable(boolean local) {
        this.remotable = local;
    }

    @Override
    public List<Operation> getOperations() {
        return this.operations;
    }

    public boolean isUnresolved() {
        return this.unresolved;
    }

    public void setUnresolved(boolean undefined) {
        this.unresolved = undefined;
    }

    @Override
    public boolean isConversational() {
        return this.conversational;
    }

    @Override
    public void setConversational(boolean conversational) {
        this.conversational = conversational;
    }

    @Override
    @Deprecated
    public void setDefaultDataBinding(String dataBinding) {
        for (Operation op : this.getOperations()) {
            DataType unwrappedOutputType;
            WrapperInfo wrapper;
            List<DataType> faultTypes;
            DataType outputType;
            if (op.getDataBinding() != null) continue;
            op.setDataBinding(dataBinding);
            DataType<List<DataType>> inputType = op.getInputType();
            if (inputType != null) {
                for (DataType d : inputType.getLogical()) {
                    if (d.getDataBinding() != null) continue;
                    d.setDataBinding(dataBinding);
                }
            }
            if ((outputType = op.getOutputType()) != null && outputType.getDataBinding() == null) {
                outputType.setDataBinding(dataBinding);
            }
            if ((faultTypes = op.getFaultTypes()) != null) {
                for (DataType d : faultTypes) {
                    DataType ft;
                    if (d.getDataBinding() == null) {
                        d.setDataBinding(dataBinding);
                    }
                    if ((ft = (DataType)d.getLogical()).getDataBinding() != null) continue;
                    ft.setDataBinding(dataBinding);
                }
            }
            if (!op.isWrapperStyle() || (wrapper = op.getWrapper()) == null) continue;
            DataType<List<DataType>> unwrappedInputType = wrapper.getUnwrappedInputType();
            if (unwrappedInputType != null) {
                for (DataType d : unwrappedInputType.getLogical()) {
                    if (d.getDataBinding() != null) continue;
                    d.setDataBinding(dataBinding);
                }
            }
            if ((unwrappedOutputType = wrapper.getUnwrappedOutputType()) == null || unwrappedOutputType.getDataBinding() != null) continue;
            unwrappedOutputType.setDataBinding(dataBinding);
        }
    }

    private void setDataBinding(DataType dataType, String dataBinding) {
        if ("java:array".equals(dataType.getDataBinding())) {
            this.setDataBinding((DataType)dataType.getLogical(), dataBinding);
        } else {
            dataType.setDataBinding(dataBinding);
        }
    }

    @Override
    public void resetDataBinding(String dataBinding) {
        for (Operation op : this.getOperations()) {
            DataType unwrappedOutputType;
            WrapperInfo wrapper;
            List<DataType> faultTypes;
            DataType outputType;
            op.setDataBinding(dataBinding);
            DataType<List<DataType>> inputType = op.getInputType();
            if (inputType != null) {
                for (DataType d : inputType.getLogical()) {
                    this.setDataBinding(d, dataBinding);
                }
            }
            if ((outputType = op.getOutputType()) != null) {
                this.setDataBinding(outputType, dataBinding);
            }
            if ((faultTypes = op.getFaultTypes()) != null) {
                for (DataType d : faultTypes) {
                    this.setDataBinding(d, dataBinding);
                    this.setDataBinding((DataType)d.getLogical(), dataBinding);
                }
            }
            if (!op.isWrapperStyle() || (wrapper = op.getWrapper()) == null) continue;
            DataType<List<DataType>> unwrappedInputType = wrapper.getUnwrappedInputType();
            if (unwrappedInputType != null) {
                for (DataType d : unwrappedInputType.getLogical()) {
                    this.setDataBinding(d, dataBinding);
                }
            }
            if ((unwrappedOutputType = wrapper.getUnwrappedOutputType()) == null) continue;
            this.setDataBinding(unwrappedOutputType, dataBinding);
        }
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public List<PolicySet> getApplicablePolicySets() {
        return this.applicablePolicySets;
    }

    @Override
    public List<PolicySet> getPolicySets() {
        return this.policySets;
    }

    @Override
    public List<Intent> getRequiredIntents() {
        return this.requiredIntents;
    }

    @Override
    public IntentAttachPointType getType() {
        return this.type;
    }

    @Override
    public void setType(IntentAttachPointType type) {
        this.type = type;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        InterfaceImpl copy = (InterfaceImpl)super.clone();
        copy.operations = new OperationList();
        for (Operation operation : this.operations) {
            Operation clonedOperation = (Operation)operation.clone();
            copy.operations.add(clonedOperation);
        }
        return copy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.conversational ? 1231 : 1237);
        result = 31 * result + (this.operations == null ? 0 : this.operations.hashCode());
        result = 31 * result + (this.remotable ? 1231 : 1237);
        result = 31 * result + (this.unresolved ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InterfaceImpl other = (InterfaceImpl)obj;
        if (this.conversational != other.conversational) {
            return false;
        }
        if (this.operations == null ? other.operations != null : !this.operations.equals(other.operations)) {
            return false;
        }
        if (this.remotable != other.remotable) {
            return false;
        }
        return this.unresolved == other.unresolved;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OperationList
    extends ArrayList<Operation> {
        private static final long serialVersionUID = -903469106307606099L;

        private OperationList() {
        }

        @Override
        public Operation set(int index, Operation element) {
            element.setInterface(InterfaceImpl.this);
            return super.set(index, element);
        }

        @Override
        public void add(int index, Operation element) {
            element.setInterface(InterfaceImpl.this);
            super.add(index, element);
        }

        @Override
        public boolean add(Operation o) {
            o.setInterface(InterfaceImpl.this);
            return super.add(o);
        }

        @Override
        public boolean addAll(Collection<? extends Operation> c) {
            for (Operation operation : c) {
                operation.setInterface(InterfaceImpl.this);
            }
            return super.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Operation> c) {
            for (Operation operation : c) {
                operation.setInterface(InterfaceImpl.this);
            }
            return super.addAll(index, c);
        }
    }
}

