/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.xquery.xml;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Iterator;
import javax.xml.namespace.QName;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.implementation.xquery.XQueryImplementation;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.util.JavaXMLMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XQueryIntrospector {
    private static final String SCA_SERVICE_PREFIX = "scaservice:java/";
    private static final String SCA_REFERENCE_PREFIX = "scareference:java/";
    private static final String SCA_PROPERTY_JAVA_PREFIX = "scaproperty:java/";
    private static final String SCA_PROPERTY_XML_PREFIX = "scaproperty:xml/";
    private AssemblyFactory assemblyFactory;
    private JavaInterfaceFactory javaFactory;

    public XQueryIntrospector(AssemblyFactory assemblyFactory, JavaInterfaceFactory javaFactory) {
        this.assemblyFactory = assemblyFactory;
        this.javaFactory = javaFactory;
    }

    public boolean introspect(XQueryImplementation xqueryImplementation, ModelResolver resolver) throws ContributionResolveException {
        String xqExpression = null;
        try {
            URL url = new URL(xqueryImplementation.getLocationURL());
            xqExpression = this.loadXQExpression(url);
        }
        catch (FileNotFoundException e) {
            throw new ContributionResolveException(e);
        }
        catch (IOException e) {
            throw new ContributionResolveException(e);
        }
        if (xqExpression == null) {
            return false;
        }
        xqueryImplementation.setXqExpression(xqExpression);
        xqExpression = xqExpression + "\r\n<dummy></dummy>";
        Configuration config = new Configuration();
        StaticQueryContext sqc = new StaticQueryContext(config);
        XQueryExpression exp = null;
        try {
            exp = sqc.compileQuery(xqExpression);
        }
        catch (XPathException e) {
            throw new ContributionResolveException(e);
        }
        if (exp == null) {
            return false;
        }
        xqueryImplementation.getCompiledExpressionsCache().put(xqExpression, exp);
        try {
            this.introspectServicesAndReferences(xqueryImplementation, exp, resolver);
        }
        catch (ClassNotFoundException e) {
            throw new ContributionResolveException(e);
        }
        catch (InvalidInterfaceException e) {
            throw new ContributionResolveException(e);
        }
        this.fillExpressionExtensions(xqueryImplementation);
        return true;
    }

    private String loadXQExpression(URL locationURL) throws FileNotFoundException, IOException {
        InputStream xqResourceStream = locationURL.openStream();
        if (xqResourceStream == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        while ((i = xqResourceStream.read()) >= 0) {
            baos.write(i);
        }
        xqResourceStream.close();
        baos.flush();
        baos.close();
        String xqExpression = baos.toString();
        return xqExpression;
    }

    private Class<?> resolveClass(ModelResolver resolver, String className) throws ClassNotFoundException {
        ClassReference classReference = new ClassReference(className);
        Class<?> javaClass = (classReference = resolver.resolveModel(ClassReference.class, classReference)).getJavaClass();
        if (javaClass == null) {
            throw new ClassNotFoundException(className);
        }
        return javaClass;
    }

    private void introspectServicesAndReferences(XQueryImplementation xqueryImplementation, XQueryExpression exp, ModelResolver resolver) throws ClassNotFoundException, InvalidInterfaceException {
        NamespaceResolver namespaceResolver = exp.getStaticContext().getNamespaceResolver();
        Iterator declaredPrefixesIterator = namespaceResolver.iteratePrefixes();
        while (declaredPrefixesIterator.hasNext()) {
            String propertyName;
            String className;
            String prefix = (String)declaredPrefixesIterator.next();
            String uri = namespaceResolver.getURIForPrefix(prefix, false);
            if (uri.startsWith(SCA_SERVICE_PREFIX)) {
                String serviceName = prefix;
                className = uri.substring(SCA_SERVICE_PREFIX.length());
                Class<?> interfaze = this.resolveClass(resolver, className);
                Service theService = this.createService(interfaze, serviceName);
                xqueryImplementation.getServices().add(theService);
                continue;
            }
            if (uri.startsWith(SCA_REFERENCE_PREFIX)) {
                String referenceName = prefix;
                className = uri.substring(SCA_REFERENCE_PREFIX.length());
                Class<?> interfaze = this.resolveClass(resolver, className);
                Reference theReference = this.createReference(interfaze, referenceName);
                xqueryImplementation.getReferences().add(theReference);
                continue;
            }
            if (uri.startsWith(SCA_PROPERTY_JAVA_PREFIX)) {
                propertyName = prefix;
                className = uri.substring(SCA_PROPERTY_JAVA_PREFIX.length());
                Class<?> clazz = this.resolveClass(resolver, className);
                QName xmlType = JavaXMLMapper.getXMLType(clazz);
                Property theProperty = this.createProperty(xmlType, propertyName);
                xqueryImplementation.getProperties().add(theProperty);
                continue;
            }
            if (!uri.startsWith(SCA_PROPERTY_XML_PREFIX)) continue;
            propertyName = prefix;
            String namespaceAndLocalname = uri.substring(SCA_PROPERTY_XML_PREFIX.length());
            int localNameDelimiterPostition = namespaceAndLocalname.lastIndexOf(58);
            String localName = null;
            String namespace = null;
            if (localNameDelimiterPostition < 0) {
                localName = namespaceAndLocalname;
                namespace = "";
            } else {
                namespace = namespaceAndLocalname.substring(0, localNameDelimiterPostition);
                localName = namespaceAndLocalname.substring(localNameDelimiterPostition + 1);
            }
            QName xmlType = new QName(namespace, localName);
            Property theProperty = this.createProperty(xmlType, propertyName);
            xqueryImplementation.getProperties().add(theProperty);
        }
    }

    private Service createService(Class<?> interfaze, String name) throws InvalidInterfaceException {
        Service service = this.assemblyFactory.createService();
        JavaInterfaceContract interfaceContract = this.javaFactory.createJavaInterfaceContract();
        service.setInterfaceContract(interfaceContract);
        service.setName(name);
        JavaInterface callInterface = null;
        try {
            callInterface = (JavaInterface)this.javaFactory.createJavaInterface(interfaze).clone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        service.getInterfaceContract().setInterface(callInterface);
        if (callInterface.getCallbackClass() != null) {
            JavaInterface callbackInterface = null;
            try {
                callbackInterface = (JavaInterface)this.javaFactory.createJavaInterface(callInterface.getCallbackClass()).clone();
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            service.getInterfaceContract().setCallbackInterface(callbackInterface);
        }
        return service;
    }

    protected Property createProperty(QName type, String name) {
        Property property = this.assemblyFactory.createProperty();
        property.setName(name);
        property.setXSDType(type);
        property.setMany(false);
        return property;
    }

    private Reference createReference(Class<?> interfaze, String name) throws InvalidInterfaceException {
        Reference reference = this.assemblyFactory.createReference();
        JavaInterfaceContract interfaceContract = this.javaFactory.createJavaInterfaceContract();
        reference.setInterfaceContract(interfaceContract);
        reference.setName(name);
        reference.setMultiplicity(Multiplicity.ONE_ONE);
        JavaInterface callInterface = null;
        try {
            callInterface = (JavaInterface)this.javaFactory.createJavaInterface(interfaze).clone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        reference.getInterfaceContract().setInterface(callInterface);
        if (callInterface.getCallbackClass() != null) {
            JavaInterface callbackInterface = null;
            try {
                callbackInterface = (JavaInterface)this.javaFactory.createJavaInterface(callInterface.getCallbackClass()).clone();
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            reference.getInterfaceContract().setCallbackInterface(callbackInterface);
        }
        return reference;
    }

    private void fillExpressionExtensions(XQueryImplementation xqueryImplementation) {
        for (Service service : xqueryImplementation.getServices()) {
            Class<?> interfaze = ((JavaInterface)service.getInterfaceContract().getInterface()).getJavaClass();
            for (Method method : interfaze.getMethods()) {
                String expressionExtension = this.createExpressionExtension(method, interfaze, service.getName());
                xqueryImplementation.getXqExpressionExtensionsMap().put(method, expressionExtension);
            }
        }
    }

    private String createExpressionExtension(Method method, Class<?> interfaze, String serviceName) {
        int i;
        StringBuffer exprBuf = new StringBuffer();
        exprBuf.append("\r\n");
        String methodName = method.getName();
        for (i = 0; i < method.getParameterTypes().length; ++i) {
            exprBuf.append("declare variable $" + methodName + "_" + i + " external;\r\n");
        }
        exprBuf.append(serviceName + ":" + methodName + "(");
        for (i = 0; i < method.getParameterTypes().length; ++i) {
            exprBuf.append("$" + methodName + "_" + i);
            if (i == method.getParameterTypes().length - 1) continue;
            exprBuf.append(", ");
        }
        exprBuf.append(")");
        return exprBuf.toString();
    }
}

