/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.xquery.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.implementation.xquery.XQueryImplementation;
import org.apache.tuscany.sca.implementation.xquery.XQueryImplementationFactory;
import org.apache.tuscany.sca.implementation.xquery.xml.XQueryIntrospector;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XQueryImplementationProcessor
implements StAXArtifactProcessor<XQueryImplementation> {
    private static final String LOCATION = "location";
    private static final String IMPLEMENTATION_XQUERY = "implementation.xquery";
    private static final QName IMPLEMENTATION_XQUERY_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "implementation.xquery");
    private AssemblyFactory assemblyFactory;
    private JavaInterfaceFactory javaFactory;
    private ContributionFactory contributionFactory;
    private Monitor monitor;

    public XQueryImplementationProcessor(ModelFactoryExtensionPoint modelFactoryExtensionPoint, Monitor monitor) {
        this.assemblyFactory = modelFactoryExtensionPoint.getFactory(AssemblyFactory.class);
        this.javaFactory = modelFactoryExtensionPoint.getFactory(JavaInterfaceFactory.class);
        this.contributionFactory = modelFactoryExtensionPoint.getFactory(ContributionFactory.class);
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "impl-xquery-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    @Override
    public QName getArtifactType() {
        return IMPLEMENTATION_XQUERY_QNAME;
    }

    @Override
    public XQueryImplementation read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        XQueryImplementation xqueryImplementation = null;
        String xqueryLocation = reader.getAttributeValue(null, LOCATION);
        if (xqueryLocation != null) {
            xqueryImplementation = XQueryImplementationFactory.INSTANCE.createXQueryImplementation();
            xqueryImplementation.setLocation(xqueryLocation);
            xqueryImplementation.setUnresolved(true);
        } else {
            this.error("LocationAttributeMissing", reader, new Object[0]);
        }
        while (reader.hasNext() && (reader.next() != 2 || !IMPLEMENTATION_XQUERY_QNAME.equals(reader.getName()))) {
        }
        return xqueryImplementation;
    }

    @Override
    public void write(XQueryImplementation xqueryImplementation, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement("http://tuscany.apache.org/xmlns/sca/1.0", IMPLEMENTATION_XQUERY);
        if (xqueryImplementation.getLocation() != null) {
            writer.writeAttribute(LOCATION, xqueryImplementation.getLocation());
        }
        writer.writeEndElement();
    }

    @Override
    public Class<XQueryImplementation> getModelType() {
        return XQueryImplementation.class;
    }

    @Override
    public void resolve(XQueryImplementation xqueryImplementation, ModelResolver resolver) throws ContributionResolveException {
        if (xqueryImplementation != null) {
            Artifact artifact = this.contributionFactory.createArtifact();
            artifact.setURI(xqueryImplementation.getLocation());
            artifact = resolver.resolveModel(Artifact.class, artifact);
            if (artifact.getLocation() != null) {
                xqueryImplementation.setLocationURL(artifact.getLocation());
                XQueryIntrospector introspector = new XQueryIntrospector(this.assemblyFactory, this.javaFactory);
                boolean success = introspector.introspect(xqueryImplementation, resolver);
                if (success) {
                    xqueryImplementation.setUnresolved(false);
                }
            } else {
                this.error("CouldNotLocateFile", resolver, xqueryImplementation.getLocation());
            }
        }
    }
}

