/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.xquery;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Value;
import org.apache.tuscany.sca.databinding.saxon.SaxonDataBindingHelper;
import org.apache.tuscany.sca.databinding.saxon.collection.ItemList;
import org.apache.tuscany.sca.implementation.xquery.XQueryImplementation;
import org.apache.tuscany.sca.implementation.xquery.XQueryInvokationException;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XQueryInvoker
implements Invoker {
    private RuntimeComponentService service;
    private Operation operation;
    private Method theMethod;
    private XQueryImplementation implementation;
    private Map<String, Object> referenceProxies;
    private Map<String, Object> properties;

    public XQueryInvoker(RuntimeComponentService service, Operation operation, XQueryImplementation implementation, Map<String, Object> referenceProxies, Map<String, Object> properties) {
        this.service = service;
        this.operation = operation;
        this.implementation = implementation;
        this.referenceProxies = referenceProxies;
        this.properties = properties;
        this.findMatchingMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doInvoke(Object payload) throws XQueryInvokationException, XPathException {
        if (this.theMethod == null) {
            throw new XQueryInvokationException("No java method for operation: " + this.operation.getName());
        }
        String xqExpression = this.implementation.getXqExpression() + this.implementation.getXqExpressionExtensionsMap().get(this.theMethod);
        Configuration config = null;
        Properties props = new Properties();
        props.setProperty("method", "xml");
        props.setProperty("indent", "yes");
        XQueryExpression exp = this.implementation.getCompiledExpressionsCache().get(xqExpression);
        if (exp == null) {
            config = new Configuration();
            StaticQueryContext sqc = new StaticQueryContext(config);
            exp = sqc.compileQuery(xqExpression);
            this.implementation.getCompiledExpressionsCache().put(xqExpression, exp);
        } else {
            config = exp.getStaticContext().getConfiguration();
        }
        Object[] params = this.prepareParameters(payload, config, props);
        DynamicQueryContext dynamicContext = new DynamicQueryContext(config);
        String methodName = this.theMethod.getName();
        for (int i = 0; i < params.length; ++i) {
            dynamicContext.setParameter(methodName + "_" + i, params[i]);
        }
        for (Map.Entry<String, Object> entry : this.referenceProxies.entrySet()) {
            dynamicContext.setParameter(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            dynamicContext.setParameter(entry.getKey(), this.transformProperty(entry.getValue(), config));
        }
        SequenceIterator iterator = null;
        Configuration oldConfigValue = SaxonDataBindingHelper.CURR_EXECUTING_CONFIG;
        SaxonDataBindingHelper.CURR_EXECUTING_CONFIG = config;
        try {
            iterator = exp.iterator(dynamicContext);
        }
        finally {
            SaxonDataBindingHelper.CURR_EXECUTING_CONFIG = oldConfigValue;
        }
        ItemList list = new ItemList();
        Item item = iterator.next();
        while (item != null) {
            list.add(item);
            item = iterator.next();
        }
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            item = (Item)list.iterator().next();
            if (item instanceof NodeInfo) {
                return item;
            }
            return Value.asValue((ValueRepresentation)item);
        }
        return list;
    }

    @Override
    public Message invoke(Message msg) {
        try {
            Object resp = this.doInvoke(msg.getBody());
            msg.setBody(resp);
        }
        catch (XQueryInvokationException e) {
            msg.setFaultBody(e.getCause());
        }
        catch (XPathException e) {
            msg.setFaultBody(e.getCause());
        }
        return msg;
    }

    private void findMatchingMethod() {
        Class<?> interfaze = ((JavaInterface)this.service.getInterfaceContract().getInterface()).getJavaClass();
        for (Method method : interfaze.getMethods()) {
            if (!XQueryInvoker.match(this.operation, method)) continue;
            this.theMethod = method;
        }
    }

    private static boolean match(Operation operation, Method method) {
        Class<?>[] params = method.getParameterTypes();
        DataType<List<DataType>> inputType = operation.getInputType();
        List<DataType> types = inputType.getLogical();
        boolean matched = true;
        if (types.size() == params.length && method.getName().equals(operation.getName())) {
            for (int i = 0; i < params.length; ++i) {
                Class<?> clazz = params[i];
                if (clazz.equals(operation.getInputType().getLogical().get(i).getPhysical())) continue;
                matched = false;
            }
        } else {
            matched = false;
        }
        return matched;
    }

    private Object[] prepareParameters(Object payload, Configuration configuration, Properties props) {
        if (payload == null) {
            return new Object[0];
        }
        Object[] inputArguments = null;
        inputArguments = payload.getClass().isArray() ? (Object[])payload : new Object[]{payload};
        Object[] parameters = new Object[inputArguments.length];
        for (int i = 0; i < inputArguments.length; ++i) {
            if (inputArguments[i] instanceof NodeInfo) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                StreamResult sw = new StreamResult(baos);
                try {
                    QueryResult.serialize((NodeInfo)((NodeInfo)inputArguments[i]), (Result)sw, (Properties)props, (Configuration)((NodeInfo)inputArguments[i]).getConfiguration());
                    baos.close();
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    StreamSource ss = new StreamSource(bais);
                    parameters[i] = Builder.build((Source)ss, null, (Configuration)configuration);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    parameters[i] = null;
                }
                continue;
            }
            parameters[i] = inputArguments[i];
        }
        return parameters;
    }

    private Object transformProperty(Object argument, Configuration configuration) {
        Object parameter = argument;
        if (argument instanceof Document) {
            try {
                Document doc = (Document)argument;
                Node valueNode = doc.getFirstChild();
                DocumentInfo docInfo = null;
                if (valueNode instanceof Element && valueNode.getNodeName().equals("value")) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    StreamResult sr = new StreamResult(baos);
                    try {
                        Node element = null;
                        NodeList list = valueNode.getChildNodes();
                        for (int i = 0; i < list.getLength(); ++i) {
                            if (list.item(i).getNodeType() != 1) continue;
                            element = list.item(i);
                            break;
                        }
                        if (element == null) {
                            element = valueNode.getFirstChild();
                        }
                        Transformer transformer = TransformerFactory.newInstance().newTransformer();
                        transformer.transform(new DOMSource(element), sr);
                        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                        docInfo = (DocumentInfo)Builder.build((Source)new StreamSource(bais), null, (Configuration)configuration);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return parameter;
                    }
                } else {
                    docInfo = (DocumentInfo)Builder.build((Source)new DOMSource(doc), null, (Configuration)configuration);
                }
                parameter = docInfo;
            }
            catch (XPathException e) {
                e.printStackTrace();
                return parameter;
            }
        }
        return parameter;
    }
}

