/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.widget;

import java.io.IOException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.implementation.widget.WidgetImplementation;
import org.apache.tuscany.sca.implementation.widget.WidgetImplementationFactory;
import org.apache.tuscany.sca.implementation.widget.WidgetImplementationIntrospector;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetImplementationProcessor
implements StAXArtifactProcessor<WidgetImplementation> {
    private static final QName IMPLEMENTATION_WIDGET = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "implementation.widget");
    private AssemblyFactory assemblyFactory;
    private ContributionFactory contributionFactory;
    private WidgetImplementationFactory implementationFactory;
    private Monitor monitor;

    public WidgetImplementationProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.contributionFactory = modelFactories.getFactory(ContributionFactory.class);
        this.implementationFactory = new WidgetImplementationFactory(modelFactories);
        this.monitor = monitor;
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "impl-widget-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "impl-widget-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    @Override
    public QName getArtifactType() {
        return IMPLEMENTATION_WIDGET;
    }

    @Override
    public Class<WidgetImplementation> getModelType() {
        return WidgetImplementation.class;
    }

    @Override
    public WidgetImplementation read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        WidgetImplementation implementation = null;
        String location = reader.getAttributeValue(null, "location");
        if (location != null) {
            implementation = this.implementationFactory.createWidgetImplementation();
            implementation.setLocation(location);
            implementation.setUnresolved(true);
        } else {
            this.error("LocationAttributeMissing", (Object)reader, new Object[0]);
        }
        while (reader.hasNext() && (reader.next() != 2 || !IMPLEMENTATION_WIDGET.equals(reader.getName()))) {
        }
        return implementation;
    }

    @Override
    public void resolve(WidgetImplementation implementation, ModelResolver resolver) throws ContributionResolveException {
        if (implementation != null) {
            Artifact artifact = this.contributionFactory.createArtifact();
            artifact.setURI(implementation.getLocation());
            Artifact resolved = resolver.resolveModel(Artifact.class, artifact);
            if (resolved.getLocation() != null) {
                try {
                    implementation.setLocationURL(new URL(resolved.getLocation()));
                    WidgetImplementationIntrospector widgetIntrospector = new WidgetImplementationIntrospector(this.assemblyFactory, implementation);
                    widgetIntrospector.introspectImplementation();
                    implementation.setUnresolved(false);
                }
                catch (IOException e) {
                    ContributionResolveException ce = new ContributionResolveException(e);
                    this.error("ContributionResolveException", (Object)resolver, ce);
                }
            } else {
                this.error("CouldNotResolveLocation", (Object)resolver, implementation.getLocation());
            }
        }
    }

    @Override
    public void write(WidgetImplementation implementation, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.setPrefix("widget", IMPLEMENTATION_WIDGET.getNamespaceURI());
        writer.writeStartElement(IMPLEMENTATION_WIDGET.getNamespaceURI(), IMPLEMENTATION_WIDGET.getLocalPart());
        writer.writeNamespace("widget", IMPLEMENTATION_WIDGET.getNamespaceURI());
        if (implementation.getLocation() != null) {
            writer.writeAttribute("location", implementation.getLocation());
        }
        writer.writeEndElement();
    }
}

