/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring.processor;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.osoa.sca.annotations.Reference;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceAnnotationProcessor
implements BeanPostProcessor {
    private Class<? extends Annotation> referenceAnnotationType = Reference.class;
    private RuntimeComponent component;

    public ReferenceAnnotationProcessor(RuntimeComponent component) {
        this.component = component;
    }

    protected Class<? extends Annotation> getReferenceAnnotationType() {
        return this.referenceAnnotationType;
    }

    public void setReferenceAnnotationType(Class<? extends Annotation> referenceAnnotationType) {
        Assert.notNull(referenceAnnotationType, (String)"'referenceAnnotationType' type must not be null.");
        this.referenceAnnotationType = referenceAnnotationType;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.processAnnotation(bean);
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    protected void processAnnotation(final Object bean) {
        Class<?> clazz = bean.getClass();
        ReflectionUtils.doWithMethods(clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                Reference annotation = (Reference)method.getAnnotation(ReferenceAnnotationProcessor.this.getReferenceAnnotationType());
                if (annotation != null) {
                    if (Modifier.isStatic(method.getModifiers())) {
                        throw new IllegalStateException("Reference annotation is not supported on static methods");
                    }
                    if (Modifier.isPrivate(method.getModifiers())) {
                        throw new IllegalStateException("Reference annotation is not supported on private methods");
                    }
                    if (method.getParameterTypes().length == 0) {
                        throw new IllegalStateException("Reference annotation requires at least one argument: " + method);
                    }
                    PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)method);
                    if (pd != null) {
                        String refName = annotation.name();
                        if ("".equals(refName)) {
                            ReferenceAnnotationProcessor.this.injectReference(bean, pd, pd.getName());
                        } else {
                            ReferenceAnnotationProcessor.this.injectReference(bean, pd, refName);
                        }
                    }
                }
            }
        });
        ReflectionUtils.doWithFields(clazz, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) {
                Reference annotation = (Reference)field.getAnnotation(ReferenceAnnotationProcessor.this.getReferenceAnnotationType());
                if (annotation != null) {
                    if (Modifier.isStatic(field.getModifiers())) {
                        throw new IllegalStateException("Reference annotation is not supported on static fields");
                    }
                    if (Modifier.isPrivate(field.getModifiers())) {
                        throw new IllegalStateException("Reference annotation is not supported on private fields");
                    }
                    ReflectionUtils.makeAccessible((Field)field);
                    Object referenceObj = null;
                    String refName = annotation.name();
                    referenceObj = "".equals(refName) ? ReferenceAnnotationProcessor.this.component.getComponentContext().getService(field.getType(), field.getName()) : ReferenceAnnotationProcessor.this.component.getComponentContext().getService(field.getType(), refName);
                    if (referenceObj != null) {
                        ReflectionUtils.setField((Field)field, (Object)bean, referenceObj);
                    }
                }
            }
        });
    }

    public void injectReference(Object bean, PropertyDescriptor pd, String name) {
        Object referenceObj = this.component.getComponentContext().getService(pd.getPropertyType(), name);
        if (referenceObj != null) {
            try {
                pd.getWriteMethod().invoke(bean, referenceObj);
            }
            catch (Throwable e) {
                throw new FatalBeanException("Problem injecting reference:  " + e.getMessage(), e);
            }
        }
    }
}

