/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring.processor;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.implementation.java.injection.JavaPropertyValueObjectFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.osoa.sca.annotations.Property;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAnnotationProcessor
implements BeanPostProcessor {
    private Class<? extends Annotation> propertyAnnotationType = Property.class;
    private RuntimeComponent component;
    private JavaPropertyValueObjectFactory propertyFactory;

    public PropertyAnnotationProcessor(JavaPropertyValueObjectFactory propertyFactory, RuntimeComponent component) {
        this.propertyFactory = propertyFactory;
        this.component = component;
    }

    protected Class<? extends Annotation> getPropertyAnnotationType() {
        return this.propertyAnnotationType;
    }

    public void setPropertyAnnotationType(Class<? extends Annotation> propertyAnnotationType) {
        Assert.notNull(propertyAnnotationType, (String)"'propertyAnnotationType' type must not be null.");
        this.propertyAnnotationType = propertyAnnotationType;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.processAnnotation(bean);
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    protected void processAnnotation(final Object bean) {
        Class<?> clazz = bean.getClass();
        ReflectionUtils.doWithMethods(clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                Property annotation = (Property)method.getAnnotation(PropertyAnnotationProcessor.this.getPropertyAnnotationType());
                if (annotation != null) {
                    if (Modifier.isStatic(method.getModifiers())) {
                        throw new IllegalStateException("Property annotation is not supported on static methods");
                    }
                    if (Modifier.isPrivate(method.getModifiers())) {
                        throw new IllegalStateException("Property annotation is not supported on private methods");
                    }
                    if (method.getParameterTypes().length == 0) {
                        throw new IllegalStateException("Property annotation requires at least one argument: " + method);
                    }
                    PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)method);
                    if (pd != null) {
                        String propName = annotation.name();
                        if ("".equals(propName)) {
                            PropertyAnnotationProcessor.this.injectProperty(bean, pd, PropertyAnnotationProcessor.this.getPropertyObj(pd.getPropertyType(), pd.getName()));
                        } else {
                            PropertyAnnotationProcessor.this.injectProperty(bean, pd, PropertyAnnotationProcessor.this.getPropertyObj(pd.getPropertyType(), propName));
                        }
                    }
                }
            }
        });
        ReflectionUtils.doWithFields(clazz, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) {
                Property annotation = (Property)field.getAnnotation(PropertyAnnotationProcessor.this.getPropertyAnnotationType());
                if (annotation != null) {
                    if (Modifier.isStatic(field.getModifiers())) {
                        throw new IllegalStateException("Property annotation is not supported on static fields");
                    }
                    if (Modifier.isPrivate(field.getModifiers())) {
                        throw new IllegalStateException("Property annotation is not supported on private fields");
                    }
                    ReflectionUtils.makeAccessible((Field)field);
                    Object propertyObj = null;
                    String propName = annotation.name();
                    propertyObj = "".equals(propName) ? PropertyAnnotationProcessor.this.getPropertyObj(field.getType(), field.getName()) : PropertyAnnotationProcessor.this.getPropertyObj(field.getType(), propName);
                    if (propertyObj != null) {
                        ReflectionUtils.setField((Field)field, (Object)bean, (Object)propertyObj);
                    }
                }
            }
        });
    }

    public Object getPropertyObj(Class requiredType, String name) {
        Object propertyObj = null;
        List<ComponentProperty> props = this.component.getProperties();
        for (ComponentProperty prop : props) {
            if (!prop.getName().equals(name)) continue;
            ObjectFactory factory = this.propertyFactory.createValueFactory((org.apache.tuscany.sca.assembly.Property)prop, prop.getValue(), requiredType);
            propertyObj = factory.getInstance();
        }
        return propertyObj;
    }

    public void injectProperty(Object bean, PropertyDescriptor pd, Object propertyObj) {
        if (propertyObj != null) {
            try {
                pd.getWriteMethod().invoke(bean, propertyObj);
            }
            catch (Throwable e) {
                throw new FatalBeanException("Problem injecting property:  " + e.getMessage(), e);
            }
        }
    }
}

