/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.implementation.java.injection.JavaPropertyValueObjectFactory;
import org.apache.tuscany.sca.implementation.spring.SpringImplementation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SCAParentApplicationContext
implements ApplicationContext {
    private SpringImplementation implementation;
    private RuntimeComponent component;
    private JavaPropertyValueObjectFactory propertyFactory;
    private static final String[] EMPTY_ARRAY = new String[0];

    public SCAParentApplicationContext(RuntimeComponent component, SpringImplementation implementation, ProxyFactory proxyService, JavaPropertyValueObjectFactory propertyValueObjectFactory) {
        this.implementation = implementation;
        this.component = component;
        this.propertyFactory = propertyValueObjectFactory;
    }

    public Object getBean(String name) throws BeansException {
        return this.getBean(name, (Class)null);
    }

    public Object getBean(String name, Class requiredType) throws BeansException {
        System.out.println("Spring parent context - getBean called for name: " + name);
        for (Reference reference : this.implementation.getReferences()) {
            if (!reference.getName().equals(name)) continue;
            if (requiredType == null) {
                JavaInterface javaInterface = (JavaInterface)reference.getInterfaceContract().getInterface();
                requiredType = javaInterface.getJavaClass();
            }
            return this.getService(requiredType, reference.getName());
        }
        for (Property property : this.implementation.getProperties()) {
            if (!property.getName().equals(name)) continue;
            if (requiredType == null) {
                requiredType = this.implementation.getPropertyClass(name);
            }
            return this.getPropertyBean(requiredType, property.getName());
        }
        throw new NoSuchBeanDefinitionException("Unable to find Bean with name " + name);
    }

    public Object getBean(String name, Object[] args) throws BeansException {
        return this.getBean(name, (Class)null);
    }

    private <B> B getService(Class<B> businessInterface, String referenceName) {
        return this.component.getComponentContext().getService(businessInterface, referenceName);
    }

    private <B> B getPropertyBean(Class requiredType, String name) {
        B propertyObject = null;
        List<ComponentProperty> props = this.component.getProperties();
        for (ComponentProperty prop : props) {
            if (!prop.getName().equals(name)) continue;
            ObjectFactory factory = this.propertyFactory.createValueFactory((Property)prop, prop.getValue(), requiredType);
            propertyObject = (B)factory.getInstance();
        }
        return propertyObject;
    }

    public boolean containsBean(String name) {
        System.out.println("Spring parent context - containsBean called for name: " + name);
        return false;
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return false;
    }

    public boolean isTypeMatch(String name, Class targetType) throws NoSuchBeanDefinitionException {
        throw new UnsupportedOperationException();
    }

    public Class getType(String name) throws NoSuchBeanDefinitionException {
        return null;
    }

    public String[] getAliases(String name) throws NoSuchBeanDefinitionException {
        return EMPTY_ARRAY;
    }

    public ApplicationContext getParent() {
        return null;
    }

    public AutowireCapableBeanFactory getAutowireCapableBeanFactory() throws IllegalStateException {
        return null;
    }

    public String getId() {
        return this.toString();
    }

    public String getDisplayName() {
        return this.implementation.getURI();
    }

    public long getStartupDate() {
        return 0L;
    }

    public boolean containsBeanDefinition(String beanName) {
        return false;
    }

    public int getBeanDefinitionCount() {
        return 0;
    }

    public String[] getBeanDefinitionNames() {
        return new String[0];
    }

    public String[] getBeanNamesForType(Class type) {
        return new String[0];
    }

    public String[] getBeanNamesForType(Class type, boolean includePrototypes, boolean includeFactoryBeans) {
        return new String[0];
    }

    public Map getBeansOfType(Class type) throws BeansException {
        return null;
    }

    public Map getBeansOfType(Class type, boolean includePrototypes, boolean includeFactoryBeans) throws BeansException {
        return null;
    }

    public boolean isPrototype(String theString) {
        return false;
    }

    public BeanFactory getParentBeanFactory() {
        return null;
    }

    public boolean containsLocalBean(String name) {
        return false;
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return null;
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return null;
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        return null;
    }

    public void publishEvent(ApplicationEvent event) {
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        return new Resource[0];
    }

    public Resource getResource(String location) {
        return null;
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }
}

