/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.script;

import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.axiom.om.OMElement;
import org.apache.bsf.xml.XMLHelper;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.core.factory.ObjectCreationException;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.extension.helper.InvokerFactory;
import org.apache.tuscany.sca.extension.helper.utils.PropertyValueObjectFactory;
import org.apache.tuscany.sca.implementation.script.ScriptImplementation;
import org.apache.tuscany.sca.implementation.script.ScriptInvoker;
import org.apache.tuscany.sca.implementation.script.engines.TuscanyJRubyScriptEngine;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

public class ScriptInvokerFactory
implements InvokerFactory {
    protected ScriptEngine scriptEngine;
    protected XMLHelper xmlHelper;
    protected RuntimeComponent rc;
    protected ComponentType ct;
    protected ScriptImplementation implementation;
    protected PropertyValueObjectFactory propertyFactory;

    public ScriptInvokerFactory(RuntimeComponent rc, ComponentType ct, ScriptImplementation implementation, PropertyValueObjectFactory propertyFactory) {
        this.rc = rc;
        this.ct = ct;
        this.implementation = implementation;
        this.propertyFactory = propertyFactory;
    }

    public Invoker createInvoker(Operation operation) {
        this.init(this.rc, this.ct, this.implementation, this.propertyFactory);
        return new ScriptInvoker(this.scriptEngine, this.xmlHelper, operation);
    }

    protected synchronized void init(RuntimeComponent rc, ComponentType ct, ScriptImplementation implementation, PropertyValueObjectFactory propertyFactory) {
        if (this.scriptEngine != null) {
            return;
        }
        try {
            this.scriptEngine = this.getScriptEngineByExtension(implementation.getScriptLanguage());
            if (this.scriptEngine == null) {
                throw new ObjectCreationException("no script engine found for language: " + implementation.getScriptLanguage());
            }
            if (!(this.scriptEngine instanceof Invocable)) {
                throw new ObjectCreationException("script engine does not support Invocable: " + this.scriptEngine);
            }
            for (Reference reference : ct.getReferences()) {
                this.scriptEngine.put(reference.getName(), this.createReferenceProxy(reference.getName(), rc));
            }
            for (Property property : ct.getProperties()) {
                ObjectFactory propertyValueFactory = propertyFactory.createValueFactory(property);
                if (propertyValueFactory == null) continue;
                this.scriptEngine.put(property.getName(), propertyValueFactory.getInstance());
            }
            this.scriptEngine.eval(new StringReader(implementation.getScriptSrc()));
        }
        catch (ScriptException e) {
            throw new ObjectCreationException(e);
        }
        for (ComponentService service : rc.getServices()) {
            InterfaceContract ic = service.getInterfaceContract();
            if (!(ic instanceof WSDLInterfaceContract)) continue;
            ic.getInterface().resetDataBinding(OMElement.class.getName());
            this.xmlHelper = XMLHelper.getArgHelper((ScriptEngine)this.scriptEngine);
        }
    }

    protected Object createReferenceProxy(String name, RuntimeComponent component) {
        for (ComponentReference reference : component.getReferences()) {
            if (!reference.getName().equals(name)) continue;
            Class<?> iface = ((JavaInterface)reference.getInterfaceContract().getInterface()).getJavaClass();
            return component.getComponentContext().getService(iface, name);
        }
        throw new IllegalArgumentException("reference " + name + " not found on component: " + component);
    }

    protected ScriptEngine getScriptEngineByExtension(String scriptExtn) {
        if ("rb".equals(scriptExtn)) {
            return new TuscanyJRubyScriptEngine();
        }
        if ("py".equals(scriptExtn)) {
            this.pythonCachedir();
        }
        ScriptEngineManager scriptEngineManager = AccessController.doPrivileged(new PrivilegedAction<ScriptEngineManager>(){

            @Override
            public ScriptEngineManager run() {
                return new ScriptEngineManager();
            }
        });
        return scriptEngineManager.getEngineByExtension(scriptExtn);
    }

    protected void pythonCachedir() {
        if (System.getProperty("python.home") == null) {
            System.setProperty("python.verbose", "error");
        }
    }
}

