/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.script;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.DefaultContributionFactory;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.extension.helper.utils.ResourceHelper;

public class ScriptImplementation {
    protected String scriptName;
    protected URL scriptURL;
    protected String scriptSrc;
    protected String scriptLanguage;

    public String getScript() {
        return this.scriptName;
    }

    public void setScript(String scriptName) {
        this.scriptName = scriptName;
    }

    public void setLanguage(String language) {
        this.scriptLanguage = language;
    }

    public void setElementText(String elementText) {
        this.scriptSrc = elementText;
    }

    public String getScriptLanguage() {
        int i;
        if ((this.scriptLanguage == null || this.scriptLanguage.length() < 1) && (i = this.scriptName.lastIndexOf(46)) > 0) {
            this.scriptLanguage = this.scriptName.substring(i + 1);
        }
        return this.scriptLanguage;
    }

    public String getScriptSrc() {
        if (this.scriptSrc == null) {
            if (this.scriptName == null) {
                throw new IllegalArgumentException("script name is null and no inline source used");
            }
            if (this.scriptURL == null) {
                throw new RuntimeException("No script: " + this.scriptName);
            }
            this.scriptSrc = ResourceHelper.readResource(this.scriptURL);
        }
        return this.scriptSrc;
    }

    public void resolve(ModelResolver resolver) {
        if (this.scriptName != null) {
            DefaultContributionFactory contributionFactory = new DefaultContributionFactory();
            Artifact artifact = contributionFactory.createArtifact();
            artifact.setURI(this.scriptName);
            artifact = resolver.resolveModel(Artifact.class, artifact);
            if (artifact.getLocation() != null) {
                try {
                    this.scriptURL = new URL(artifact.getLocation());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

