/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.resource.impl;

import java.io.IOException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.implementation.resource.ResourceImplementation;
import org.apache.tuscany.sca.implementation.resource.ResourceImplementationFactory;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceImplementationProcessor
implements StAXArtifactProcessor<ResourceImplementation> {
    private static final QName IMPLEMENTATION_RESOURCE = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "implementation.resource");
    private ContributionFactory contributionFactory;
    private ResourceImplementationFactory implementationFactory;
    private Monitor monitor;

    public ResourceImplementationProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.contributionFactory = modelFactories.getFactory(ContributionFactory.class);
        this.implementationFactory = modelFactories.getFactory(ResourceImplementationFactory.class);
        this.monitor = monitor;
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "impl-resource-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "impl-resource-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    @Override
    public QName getArtifactType() {
        return IMPLEMENTATION_RESOURCE;
    }

    @Override
    public Class<ResourceImplementation> getModelType() {
        return ResourceImplementation.class;
    }

    @Override
    public ResourceImplementation read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        ResourceImplementation implementation = null;
        String location = reader.getAttributeValue(null, "location");
        if (location != null) {
            implementation = this.implementationFactory.createResourceImplementation();
            implementation.setLocation(location);
            implementation.setUnresolved(true);
        } else {
            this.error("LocationAttributeMissing", (Object)reader, new Object[0]);
        }
        while (reader.hasNext() && (reader.next() != 2 || !IMPLEMENTATION_RESOURCE.equals(reader.getName()))) {
        }
        return implementation;
    }

    @Override
    public void resolve(ResourceImplementation implementation, ModelResolver resolver) throws ContributionResolveException {
        if (implementation == null) {
            return;
        }
        Artifact artifact = this.contributionFactory.createArtifact();
        artifact.setURI(implementation.getLocation());
        Artifact resolved = resolver.resolveModel(Artifact.class, artifact);
        if (resolved.getLocation() != null) {
            try {
                implementation.setLocationURL(new URL(resolved.getLocation()));
                implementation.setUnresolved(false);
            }
            catch (IOException e) {
                ContributionResolveException ce = new ContributionResolveException(e);
                this.error("ContributionResolveException", (Object)resolver, ce);
            }
        } else {
            this.error("CouldNotResolveLocation", (Object)resolver, implementation.getLocation());
        }
    }

    @Override
    public void write(ResourceImplementation implementation, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(IMPLEMENTATION_RESOURCE.getNamespaceURI(), IMPLEMENTATION_RESOURCE.getLocalPart());
        if (implementation.getLocation() != null) {
            writer.writeAttribute("location", implementation.getLocation());
        }
        writer.writeEndElement();
    }
}

