/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.osgi.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tuscany.sca.core.context.InstanceWrapper;
import org.apache.tuscany.sca.core.invocation.TargetInvocationException;
import org.apache.tuscany.sca.core.scope.Scope;
import org.apache.tuscany.sca.core.scope.ScopeContainer;
import org.apache.tuscany.sca.core.scope.TargetResolutionException;
import org.apache.tuscany.sca.implementation.osgi.runtime.OSGiImplementationProvider;
import org.apache.tuscany.sca.implementation.osgi.runtime.OSGiInstanceWrapper;
import org.apache.tuscany.sca.interfacedef.ConversationSequence;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceUtil;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.EndpointReference;
import org.apache.tuscany.sca.runtime.ReferenceParameters;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiTargetInvoker<T>
implements Invoker {
    private Operation operation;
    protected InstanceWrapper<T> target;
    private final OSGiImplementationProvider provider;
    private final RuntimeComponentService service;
    private ScopeContainer scopeContainer;

    public OSGiTargetInvoker(Operation operation, OSGiImplementationProvider provider, RuntimeComponentService service) {
        this.operation = operation;
        this.service = service;
        this.provider = provider;
    }

    protected InstanceWrapper getInstance(Object contextId) throws TargetResolutionException, TargetInvocationException {
        if (this.scopeContainer == null) {
            this.scopeContainer = this.provider.getScopeContainer();
        }
        return this.scopeContainer.getWrapper(contextId);
    }

    private Object invokeTarget(Message msg) throws InvocationTargetException {
        Operation op;
        if (this.scopeContainer == null) {
            this.scopeContainer = this.provider.getScopeContainer();
        }
        if ((op = msg.getOperation()) == null) {
            op = this.operation;
        }
        ConversationSequence sequence = op.getConversationSequence();
        Object contextId = null;
        EndpointReference from = msg.getFrom();
        ReferenceParameters parameters = null;
        if (from != null) {
            parameters = from.getReferenceParameters();
        }
        if (this.scopeContainer != null) {
            Scope scope = this.scopeContainer.getScope();
            if (scope == Scope.REQUEST) {
                contextId = Thread.currentThread();
            } else if (scope == Scope.CONVERSATION && parameters != null) {
                contextId = parameters.getConversationID();
            }
        }
        try {
            OSGiInstanceWrapper wrapper = (OSGiInstanceWrapper)this.getInstance(contextId);
            boolean removeTemporaryConversationalComponentAfterCall = false;
            if (parameters != null && contextId == null && parameters.getConversationID() != null) {
                contextId = parameters.getConversationID();
                removeTemporaryConversationalComponentAfterCall = true;
            }
            Object instance = wrapper.getInstance(this.service);
            Method m = JavaInterfaceUtil.findMethod(instance.getClass(), this.operation);
            Object ret = this.invokeMethod(instance, m, msg);
            this.scopeContainer.returnWrapper(wrapper, contextId);
            if (sequence == ConversationSequence.CONVERSATION_END || removeTemporaryConversationalComponentAfterCall) {
                this.scopeContainer.remove(contextId);
                parameters.setConversationID(null);
            }
            return ret;
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    protected Object invokeMethod(Object instance, Method m, Message msg) throws InvocationTargetException {
        try {
            Object payload = msg.getBody();
            if (payload != null && !payload.getClass().isArray()) {
                return m.invoke(instance, payload);
            }
            return m.invoke(instance, (Object[])payload);
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    @Override
    public Message invoke(Message msg) {
        try {
            Object resp = this.invokeTarget(msg);
            msg.setBody(resp);
        }
        catch (InvocationTargetException e) {
            msg.setFaultBody(e.getCause());
        }
        return msg;
    }
}

