/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.osgi.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import org.apache.tuscany.sca.databinding.DataBinding;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.implementation.osgi.context.OSGiAnnotations;
import org.apache.tuscany.sca.implementation.osgi.runtime.OSGiImplementationProvider;
import org.apache.tuscany.sca.implementation.osgi.runtime.OSGiTargetInvoker;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

public class OSGiRemotableInvoker
extends OSGiTargetInvoker
implements DataExchangeSemantics {
    private DataBindingExtensionPoint registry;
    private Operation operation;
    private OSGiAnnotations osgiAnnotations;

    public OSGiRemotableInvoker(OSGiAnnotations osgiAnnotations, DataBindingExtensionPoint registry, Operation operation, OSGiImplementationProvider provider, RuntimeComponentService service) {
        super(operation, provider, service);
        this.osgiAnnotations = osgiAnnotations;
        this.registry = registry;
        this.operation = operation;
    }

    public Object invokeMethod(Object targetObject, Method m, Message msg) throws InvocationTargetException {
        Object result;
        if (this.osgiAnnotations.isAllowsPassByReference(targetObject, m)) {
            result = super.invokeMethod(targetObject, m, msg);
        } else {
            Object obj = msg.getBody();
            msg.setBody(this.copy((Object[])obj));
            result = super.invokeMethod(targetObject, m, msg);
            if (this.operation.getOutputType() != null) {
                String dataBindingId = this.operation.getOutputType().getDataBinding();
                DataBinding dataBinding = this.registry.getDataBinding(dataBindingId);
                result = this.copy(result, this.operation.getOutputType(), dataBinding);
            }
        }
        return result;
    }

    public Object[] copy(Object[] args) {
        if (args == null) {
            return null;
        }
        Object[] copiedArgs = new Object[args.length];
        IdentityHashMap map = new IdentityHashMap();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) {
                copiedArgs[i] = null;
                continue;
            }
            Object copiedArg = map.get(args[i]);
            if (copiedArg != null) {
                copiedArgs[i] = copiedArg;
                continue;
            }
            DataType dt = this.operation.getInputType().getLogical().get(i);
            String dataBindingId = dt.getDataBinding();
            DataBinding dataBinding = this.registry.getDataBinding(dataBindingId);
            copiedArg = this.copy(args[i], dt, dataBinding);
            map.put(args[i], copiedArg);
            copiedArgs[i] = copiedArg;
        }
        return copiedArgs;
    }

    public Object copy(Object arg, DataType dataType, DataBinding argDataBinding) {
        Object copiedArg;
        if (arg == null) {
            return null;
        }
        if (argDataBinding != null) {
            copiedArg = argDataBinding.copy(arg, dataType, this.operation);
        } else {
            DataBinding binding;
            copiedArg = arg;
            dataType = this.registry.introspectType(arg, this.operation);
            if (dataType != null && (binding = this.registry.getDataBinding(dataType.getDataBinding())) != null) {
                copiedArg = binding.copy(arg, dataType, this.operation);
            }
        }
        return copiedArg;
    }

    public boolean allowsPassByReference() {
        return true;
    }
}

