/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.osgi.runtime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.core.context.InstanceWrapper;
import org.apache.tuscany.sca.core.scope.Scope;
import org.apache.tuscany.sca.core.scope.TargetDestructionException;
import org.apache.tuscany.sca.core.scope.TargetInitializationException;
import org.apache.tuscany.sca.implementation.osgi.context.OSGiAnnotations;
import org.apache.tuscany.sca.implementation.osgi.runtime.OSGiImplementationProvider;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osoa.sca.annotations.Destroy;
import org.osoa.sca.annotations.Init;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiInstanceWrapper<T>
implements InstanceWrapper<T> {
    private static final Random RANDOM_NUMBER_GENERATOR = new Random();
    private OSGiAnnotations annotationProcessor;
    private OSGiImplementationProvider provider;
    private BundleContext bundleContext;
    private Hashtable<Object, InstanceInfo<T>> instanceInfoList = new Hashtable();
    private Bundle dummyReferenceBundle;

    public OSGiInstanceWrapper(OSGiImplementationProvider provider, OSGiAnnotations annotationProcessor, BundleContext bundleContext) {
        this.provider = provider;
        this.annotationProcessor = annotationProcessor;
        this.bundleContext = bundleContext;
    }

    public synchronized T getInstance(ComponentService service) throws TargetInitializationException {
        InstanceInfo<T> instanceInfo2;
        if (this.instanceInfoList.get(service) != null) {
            return (T)((InstanceInfo)this.instanceInfoList.get(service)).osgiInstance;
        }
        if (service.isCallback()) {
            for (InstanceInfo<T> instanceInfo2 : this.instanceInfoList.values()) {
                Class<?>[] interfaces;
                Interface interfaze = service.getInterfaceContract().getInterface();
                if (!(interfaze instanceof JavaInterface) || ((JavaInterface)interfaze).getJavaClass() == null) continue;
                String interfaceName = ((JavaInterface)interfaze).getJavaClass().getName();
                for (Class<?> clazz : interfaces = ((InstanceInfo)instanceInfo2).osgiInstance.getClass().getInterfaces()) {
                    if (!clazz.getName().equals(interfaceName)) continue;
                    return (T)((InstanceInfo)instanceInfo2).osgiInstance;
                }
            }
        }
        Bundle refBundle = this.provider.startBundle(true);
        if (!this.annotationProcessor.getScope().equals(Scope.COMPOSITE)) {
            refBundle = this.getDummyReferenceBundle();
        }
        instanceInfo2 = new InstanceInfo();
        ((InstanceInfo)instanceInfo2).refBundleContext = refBundle.getBundleContext();
        ((InstanceInfo)instanceInfo2).osgiInstance = this.getInstanceObject(instanceInfo2, service);
        try {
            if (!this.isInitialized(((InstanceInfo)instanceInfo2).osgiInstance)) {
                this.annotationProcessor.injectProperties(((InstanceInfo)instanceInfo2).osgiInstance);
                this.callLifecycleMethod(((InstanceInfo)instanceInfo2).osgiInstance, Init.class);
                ((InstanceInfo)instanceInfo2).isFirstInstance = true;
            }
            this.instanceInfoList.put(service, instanceInfo2);
        }
        catch (Exception e) {
            throw new TargetInitializationException(e);
        }
        return (T)((InstanceInfo)instanceInfo2).osgiInstance;
    }

    @Override
    public T getInstance() {
        return null;
    }

    @Override
    public void start() throws TargetInitializationException {
        if (this.provider.isEagerInit()) {
            List<ComponentService> services = this.provider.getRuntimeComponent().getServices();
            for (ComponentService service : services) {
                this.getInstance(service);
            }
        }
    }

    @Override
    public synchronized void stop() throws TargetDestructionException {
        for (InstanceInfo<T> instanceInfo : this.instanceInfoList.values()) {
            if (((InstanceInfo)instanceInfo).osgiInstance == null || ((InstanceInfo)instanceInfo).osgiServiceReference == null) continue;
            try {
                if (((InstanceInfo)instanceInfo).isFirstInstance) {
                    this.callLifecycleMethod(((InstanceInfo)instanceInfo).osgiInstance, Destroy.class);
                }
                ((InstanceInfo)instanceInfo).refBundleContext.ungetService(((InstanceInfo)instanceInfo).osgiServiceReference);
                ((InstanceInfo)instanceInfo).osgiInstance = null;
                ((InstanceInfo)instanceInfo).osgiServiceReference = null;
            }
            catch (Exception e) {
                throw new TargetDestructionException(e);
            }
        }
        this.instanceInfoList.clear();
        if (this.dummyReferenceBundle != null) {
            try {
                this.dummyReferenceBundle.uninstall();
            }
            catch (BundleException e) {
                throw new TargetDestructionException(e);
            }
            this.dummyReferenceBundle = null;
        }
    }

    private T getInstanceObject(InstanceInfo<T> instanceInfo, ComponentService service) {
        int maxRetries = 10;
        for (int i = 0; i < maxRetries; ++i) {
            ((InstanceInfo)instanceInfo).osgiServiceReference = this.provider.getOSGiServiceReference(service);
            if (((InstanceInfo)instanceInfo).osgiServiceReference == null) {
                return null;
            }
            Object obj = ((InstanceInfo)instanceInfo).refBundleContext.getService(((InstanceInfo)instanceInfo).osgiServiceReference);
            if (obj == null) continue;
            return (T)obj;
        }
        return null;
    }

    private Bundle getDummyReferenceBundle() throws TargetInitializationException {
        if (this.dummyReferenceBundle != null) {
            return this.dummyReferenceBundle;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String EOL = System.getProperty("line.separator");
        String bundleName = "dummy.sca." + RANDOM_NUMBER_GENERATOR.nextInt();
        String manifestStr = "Manifest-Version: 1.0" + EOL + "Bundle-ManifestVersion: 2" + EOL + "Bundle-Name: " + bundleName + EOL + "Bundle-SymbolicName: " + bundleName + EOL + "Bundle-Version: " + "1.0.0" + EOL + "Bundle-Localization: plugin" + EOL;
        StringBuilder manifestBuf = new StringBuilder();
        manifestBuf.append(manifestStr);
        try {
            ByteArrayInputStream manifestStream = new ByteArrayInputStream(manifestBuf.toString().getBytes());
            Manifest manifest = new Manifest();
            manifest.read(manifestStream);
            JarOutputStream jarOut = new JarOutputStream((OutputStream)out, manifest);
            jarOut.close();
            out.close();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            this.dummyReferenceBundle = this.bundleContext.installBundle("file://" + bundleName + ".jar", (InputStream)in);
            this.dummyReferenceBundle.start();
        }
        catch (Exception e) {
            throw new TargetInitializationException(e);
        }
        return this.dummyReferenceBundle;
    }

    private void callLifecycleMethod(Object instance, Class<? extends Annotation> annotationClass) throws Exception {
        Method method = null;
        if (annotationClass == Init.class) {
            method = this.annotationProcessor.getInitMethod(instance);
        } else if (annotationClass == Destroy.class) {
            method = this.annotationProcessor.getDestroyMethod(instance);
        }
        if (method != null) {
            method.setAccessible(true);
            method.invoke(instance, new Object[0]);
        }
    }

    private boolean isInitialized(Object instance) {
        for (InstanceInfo<T> info : this.instanceInfoList.values()) {
            if (((InstanceInfo)info).osgiInstance != instance) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstanceInfo<T> {
        private T osgiInstance;
        private ServiceReference osgiServiceReference;
        private BundleContext refBundleContext;
        private boolean isFirstInstance;

        private InstanceInfo() {
        }
    }
}

