/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.osgi.context;

import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.context.RequestContextFactory;
import org.apache.tuscany.sca.core.context.RequestContextImpl;
import org.apache.tuscany.sca.core.factory.ObjectCreationException;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.core.invocation.CallbackWireObjectFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.impl.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaResourceImpl;
import org.apache.tuscany.sca.implementation.java.injection.ArrayMultiplicityObjectFactory;
import org.apache.tuscany.sca.implementation.java.injection.ConversationIDObjectFactory;
import org.apache.tuscany.sca.implementation.java.injection.FieldInjector;
import org.apache.tuscany.sca.implementation.java.injection.Injector;
import org.apache.tuscany.sca.implementation.java.injection.InvalidAccessorException;
import org.apache.tuscany.sca.implementation.java.injection.JavaPropertyValueObjectFactory;
import org.apache.tuscany.sca.implementation.java.injection.ListMultiplicityObjectFactory;
import org.apache.tuscany.sca.implementation.java.injection.MethodInjector;
import org.apache.tuscany.sca.implementation.java.injection.ResourceObjectFactory;
import org.apache.tuscany.sca.implementation.java.introspect.impl.JavaIntrospectionHelper;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.osoa.sca.ComponentContext;
import org.osoa.sca.RequestContext;
import org.osoa.sca.annotations.ConversationID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiPropertyInjector {
    private ArrayList<JavaElementImpl> injectionSites = new ArrayList();
    private Hashtable<JavaElementImpl, ObjectFactory> factories = new Hashtable();
    private Injector[] injectors;

    public OSGiPropertyInjector(JavaImplementation javaImpl, RuntimeComponent component, JavaPropertyValueObjectFactory propertyValueFactory, ProxyFactory proxyFactory, RequestContextFactory requestContextFactory) throws IntrospectionException {
        this.createInjectionSites(javaImpl, component, propertyValueFactory, proxyFactory, requestContextFactory);
        this.injectors = this.createInjectors();
    }

    public void injectProperties(Object instance) {
        for (Injector injector : this.injectors) {
            injector.inject(instance);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createInjectionSites(JavaImplementation javaImpl, RuntimeComponent component, JavaPropertyValueObjectFactory propertyValueFactory, ProxyFactory proxyFactory, RequestContextFactory requestContextFactory) {
        List<ComponentProperty> componentProperties = component.getProperties();
        Map<String, JavaElementImpl> propertyMembers = javaImpl.getPropertyMembers();
        for (ComponentProperty prop : componentProperties) {
            JavaElementImpl javaElementImpl = propertyMembers.get(prop.getName());
            if (javaElementImpl == null || javaElementImpl.getAnchor() instanceof Constructor || prop.getValue() == null) continue;
            Class<?> propertyJavaType = JavaIntrospectionHelper.getBaseType(javaElementImpl.getType(), javaElementImpl.getGenericType());
            ObjectFactory objFactory = propertyValueFactory.createValueFactory((Property)prop, prop.getValue(), propertyJavaType);
            this.factories.put(javaElementImpl, objFactory);
            this.injectionSites.add(javaElementImpl);
        }
        for (Member member : javaImpl.getConversationIDMembers()) {
            JavaElementImpl element;
            ConversationIDObjectFactory conversationIDObjectFactory = new ConversationIDObjectFactory();
            if (member instanceof Field) {
                element = new JavaElementImpl((Field)member);
                element.setClassifer(ConversationID.class);
                this.injectionSites.add(element);
                this.factories.put(element, conversationIDObjectFactory);
                continue;
            }
            if (member instanceof Method) {
                element = new JavaElementImpl((Method)member, 0);
                element.setName(JavaIntrospectionHelper.toPropertyName(member.getName()));
                element.setClassifer(ConversationID.class);
                this.injectionSites.add(element);
                this.factories.put(element, conversationIDObjectFactory);
                continue;
            }
            throw new InvalidAccessorException("Member must be a field or method: " + member.getName());
        }
        if (!javaImpl.getCallbackMembers().isEmpty()) {
            HashMap<String, List<RuntimeWire>> callbackWires = new HashMap<String, List<RuntimeWire>>();
            for (ComponentService componentService : component.getServices()) {
                List<RuntimeWire> wires;
                RuntimeComponentReference callbackReference = (RuntimeComponentReference)componentService.getCallbackReference();
                if (callbackReference == null || (wires = callbackReference.getRuntimeWires()).isEmpty()) continue;
                callbackWires.put(wires.get(0).getSource().getInterfaceContract().getInterface().toString(), wires);
            }
            for (Map.Entry entry : javaImpl.getCallbackMembers().entrySet()) {
                List wires = (List)callbackWires.get(entry.getKey());
                if (wires == null) continue;
                for (JavaElementImpl element : (Collection)entry.getValue()) {
                    CallbackWireObjectFactory factory = new CallbackWireObjectFactory(element.getType(), proxyFactory, wires);
                    if (!(element.getAnchor() instanceof Constructor)) {
                        this.injectionSites.add(element);
                    }
                    this.factories.put(element, factory);
                }
            }
        }
        for (JavaResourceImpl resource : javaImpl.getResources().values()) {
            void var10_21;
            Class<?> type = resource.getElement().getType();
            if (ComponentContext.class.equals(type)) {
                ComponentContextFactory componentContextFactory = new ComponentContextFactory(component);
            } else if (RequestContext.class.equals(type)) {
                RequestContextObjectFactory requestContextObjectFactory = new RequestContextObjectFactory(requestContextFactory, proxyFactory);
            } else {
                boolean optional = resource.isOptional();
                String mappedName = resource.getMappedName();
                ResourceObjectFactory resourceObjectFactory = new ResourceObjectFactory(type, mappedName, optional, null);
            }
            this.factories.put(resource.getElement(), (ObjectFactory)var10_21);
            if (resource.getElement().getAnchor() instanceof Constructor) continue;
            this.injectionSites.add(resource.getElement());
        }
    }

    private Injector[] createInjectors() {
        Injector[] injectors = new Injector[this.injectionSites.size()];
        int i = 0;
        for (JavaElementImpl element : this.injectionSites) {
            ObjectFactory obj = this.factories.get(element);
            if (obj == null) continue;
            if (obj instanceof ObjectFactory) {
                ObjectFactory factory = obj;
                Member member = (Member)((Object)element.getAnchor());
                if (element.getElementType() == ElementType.FIELD) {
                    injectors[i++] = new FieldInjector((Field)member, factory);
                    continue;
                }
                if (element.getElementType() == ElementType.PARAMETER && member instanceof Method) {
                    injectors[i++] = new MethodInjector((Method)member, factory);
                    continue;
                }
                if (!(member instanceof Constructor)) {
                    throw new AssertionError((Object)String.valueOf(element));
                }
                continue;
            }
            injectors[i++] = this.createMultiplicityInjector(element, (List)((Object)obj));
        }
        return injectors;
    }

    protected Injector createMultiplicityInjector(JavaElementImpl element, List<ObjectFactory<?>> factories) {
        Class<?> interfaceType = JavaIntrospectionHelper.getBaseType(element.getType(), element.getGenericType());
        if (element.getAnchor() instanceof Field) {
            Field field = (Field)element.getAnchor();
            if (field.getType().isArray()) {
                return new FieldInjector(field, new ArrayMultiplicityObjectFactory(interfaceType, factories));
            }
            return new FieldInjector(field, new ListMultiplicityObjectFactory(factories));
        }
        if (element.getAnchor() instanceof Method) {
            Method method = (Method)element.getAnchor();
            if (method.getParameterTypes()[0].isArray()) {
                return new MethodInjector(method, new ArrayMultiplicityObjectFactory(interfaceType, factories));
            }
            return new MethodInjector(method, new ListMultiplicityObjectFactory(factories));
        }
        throw new InvalidAccessorException("Member must be a field or method: " + element.getName());
    }

    private static class RequestContextObjectFactory
    implements ObjectFactory {
        private RequestContextFactory factory;
        private ProxyFactory proxyFactory;

        public RequestContextObjectFactory(RequestContextFactory factory) {
            this(factory, null);
        }

        public RequestContextObjectFactory(RequestContextFactory factory, ProxyFactory proxyFactory) {
            this.factory = factory;
            this.proxyFactory = proxyFactory;
        }

        public RequestContext getInstance() throws ObjectCreationException {
            if (this.factory != null) {
                return this.factory.createRequestContext();
            }
            return new RequestContextImpl(this.proxyFactory);
        }
    }

    private static class ComponentContextFactory
    implements ObjectFactory {
        RuntimeComponent component;

        private ComponentContextFactory(RuntimeComponent component) {
            this.component = component;
        }

        public Object getInstance() throws ObjectCreationException {
            return this.component.getComponentContext();
        }
    }
}

