/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.osgi.context;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.context.RequestContextFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.implementation.java.DefaultJavaImplementationFactory;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaImplementationFactory;
import org.apache.tuscany.sca.implementation.java.impl.JavaScopeImpl;
import org.apache.tuscany.sca.implementation.java.injection.JavaPropertyValueObjectFactory;
import org.apache.tuscany.sca.implementation.java.introspect.impl.AllowsPassByReferenceProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.ComponentNameProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.ConstructorProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.ContextProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.ConversationProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.DestroyProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.EagerInitProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.HeuristicPojoProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.InitProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.PolicyProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.PropertyProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.ReferenceProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.ResourceProcessor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.ServiceProcessor;
import org.apache.tuscany.sca.implementation.osgi.context.OSGiPropertyInjector;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.osgi.framework.Bundle;
import org.osoa.sca.annotations.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiAnnotations {
    private org.apache.tuscany.sca.core.scope.Scope scope = org.apache.tuscany.sca.core.scope.Scope.COMPOSITE;
    private boolean isEagerInit;
    private String[] classList;
    private Bundle[] bundles;
    private RuntimeComponent runtimeComponent;
    private JavaPropertyValueObjectFactory propertyValueFactory;
    private ProxyFactory proxyFactory;
    private JavaImplementationFactory javaImplementationFactory;
    private JavaInterfaceFactory javaInterfaceFactory;
    private PolicyFactory policyFactory;
    private RequestContextFactory requestContextFactory;
    private Hashtable<Class<?>, JavaImplementation> javaAnnotationInfo = new Hashtable();
    private Hashtable<JavaImplementation, OSGiPropertyInjector> propertyInjectors = new Hashtable();
    private long maxAge = -1L;
    private long maxIdleTime = -1L;
    private boolean annotationsProcessed;

    public OSGiAnnotations(ModelFactoryExtensionPoint modelFactories, String[] classList, RuntimeComponent runtimeComponent, JavaPropertyValueObjectFactory propertyValueFactory, ProxyFactory proxyFactory, RequestContextFactory requestContextFactory, Bundle mainBundle, ArrayList<Bundle> dependentBundles) {
        this.classList = classList;
        this.runtimeComponent = runtimeComponent;
        this.propertyValueFactory = propertyValueFactory;
        this.proxyFactory = proxyFactory;
        AssemblyFactory assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.javaInterfaceFactory = modelFactories.getFactory(JavaInterfaceFactory.class);
        this.javaImplementationFactory = this.createJavaImplementationFactory(assemblyFactory);
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.bundles = new Bundle[dependentBundles.size() + 1];
        this.bundles[0] = mainBundle;
        for (int i = 0; i < dependentBundles.size(); ++i) {
            this.bundles[i + 1] = dependentBundles.get(i);
        }
    }

    public void processAnnotations() throws IntrospectionException {
        if (this.annotationsProcessed) {
            return;
        }
        this.annotationsProcessed = true;
        block2: for (String className : this.classList) {
            for (Bundle bundle : this.bundles) {
                try {
                    Class clazz = bundle.loadClass(className);
                    this.processAnnotations(clazz);
                    continue block2;
                }
                catch (ClassNotFoundException e) {
                }
            }
        }
    }

    public void injectProperties(Object instance) {
        OSGiPropertyInjector injector;
        JavaImplementation javaImpl = this.getAnnotationInfo(instance);
        if (javaImpl != null && (injector = this.propertyInjectors.get(javaImpl)) != null) {
            injector.injectProperties(instance);
        }
    }

    public org.apache.tuscany.sca.core.scope.Scope getScope() {
        return this.scope;
    }

    public boolean isAllowsPassByReference(Object instance, Method method) {
        JavaImplementation javaImpl = this.getAnnotationInfo(instance);
        if (javaImpl == null) {
            return false;
        }
        if (javaImpl.isAllowsPassByReference()) {
            return true;
        }
        return javaImpl.isAllowsPassByReference(method);
    }

    public boolean isEagerInit() {
        return this.isEagerInit;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public Method getInitMethod(Object instance) {
        JavaImplementation javaImpl = this.getAnnotationInfo(instance);
        return javaImpl == null ? null : javaImpl.getInitMethod();
    }

    public Method getDestroyMethod(Object instance) {
        JavaImplementation javaImpl = this.getAnnotationInfo(instance);
        return javaImpl == null ? null : javaImpl.getDestroyMethod();
    }

    private JavaImplementation getAnnotationInfo(final Object instance) {
        JavaImplementation javaImpl = AccessController.doPrivileged(new PrivilegedAction<JavaImplementation>(){

            @Override
            public JavaImplementation run() {
                return (JavaImplementation)OSGiAnnotations.this.javaAnnotationInfo.get(instance.getClass());
            }
        });
        if (javaImpl != null) {
            return javaImpl;
        }
        try {
            return this.processAnnotations(instance.getClass());
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    private JavaImplementation processAnnotations(Class<?> clazz) throws IntrospectionException {
        JavaImplementation javaImpl = this.javaImplementationFactory.createJavaImplementation(clazz);
        this.javaAnnotationInfo.put(clazz, javaImpl);
        OSGiPropertyInjector propertyInjector = new OSGiPropertyInjector(javaImpl, this.runtimeComponent, this.propertyValueFactory, this.proxyFactory, this.requestContextFactory);
        this.propertyInjectors.put(javaImpl, propertyInjector);
        if (javaImpl.isEagerInit()) {
            this.isEagerInit = true;
        }
        if (javaImpl.getMaxAge() != -1L) {
            this.maxAge = javaImpl.getMaxAge();
        }
        if (javaImpl.getMaxIdleTime() != -1L) {
            this.maxIdleTime = javaImpl.getMaxIdleTime();
        }
        if (javaImpl.getJavaScope() != JavaScopeImpl.COMPOSITE) {
            this.scope = new org.apache.tuscany.sca.core.scope.Scope(javaImpl.getJavaScope().getScope());
        }
        return javaImpl;
    }

    private JavaImplementationFactory createJavaImplementationFactory(AssemblyFactory assemblyFactory) {
        BaseJavaClassVisitor[] extensions;
        DefaultJavaImplementationFactory javaImplementationFactory = new DefaultJavaImplementationFactory();
        for (BaseJavaClassVisitor extension : extensions = new BaseJavaClassVisitor[]{new ConstructorProcessor(assemblyFactory), new AllowsPassByReferenceProcessor(assemblyFactory), new ComponentNameProcessor(assemblyFactory), new ContextProcessor(assemblyFactory), new ConversationProcessor(assemblyFactory), new DestroyProcessor(assemblyFactory), new EagerInitProcessor(assemblyFactory), new InitProcessor(assemblyFactory), new PropertyProcessor(assemblyFactory), new ReferenceProcessor(assemblyFactory, this.javaInterfaceFactory), new ResourceProcessor(assemblyFactory), new OSGiScopeProcessor(assemblyFactory), new ServiceProcessor(assemblyFactory, this.javaInterfaceFactory), new HeuristicPojoProcessor(assemblyFactory, this.javaInterfaceFactory), new PolicyProcessor(assemblyFactory, this.policyFactory)}) {
            javaImplementationFactory.addClassVisitor(extension);
        }
        return javaImplementationFactory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OSGiScopeProcessor
    extends BaseJavaClassVisitor {
        public OSGiScopeProcessor(AssemblyFactory factory) {
            super(factory);
        }

        @Override
        public <T> void visitClass(Class<T> clazz, JavaImplementation type) throws IntrospectionException {
            Scope annotation = clazz.getAnnotation(Scope.class);
            if (annotation == null) {
                type.setJavaScope(JavaScopeImpl.COMPOSITE);
                return;
            }
            String name = annotation.value();
            JavaScopeImpl scope = "COMPOSITE".equals(name) ? JavaScopeImpl.COMPOSITE : ("SESSION".equals(name) ? JavaScopeImpl.SESSION : ("CONVERSATION".equals(name) ? JavaScopeImpl.CONVERSATION : ("REQUEST".equals(name) ? JavaScopeImpl.REQUEST : new JavaScopeImpl(name))));
            type.setJavaScope(scope);
        }
    }
}

