/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.notification;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.DefaultAssemblyFactory;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.implementation.notification.NotificationImplementationFactory;
import org.apache.tuscany.sca.implementation.notification.NotificationImplementationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationImplementationProcessor
implements StAXArtifactProcessor<NotificationImplementationImpl> {
    protected static final QName IMPLEMENTATION_NOTIFICATION = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "implementation.notification");
    private NotificationImplementationFactory implementationFactory;

    public NotificationImplementationProcessor(NotificationImplementationFactory implementationFactory) {
        this.implementationFactory = implementationFactory;
    }

    @Override
    public QName getArtifactType() {
        return IMPLEMENTATION_NOTIFICATION;
    }

    @Override
    public Class<NotificationImplementationImpl> getModelType() {
        return NotificationImplementationImpl.class;
    }

    @Override
    public NotificationImplementationImpl read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        assert (IMPLEMENTATION_NOTIFICATION.equals(reader.getName()));
        String componentTypeName = reader.getAttributeValue(null, "name");
        String implementationType = reader.getAttributeValue(null, "type");
        NotificationImplementationImpl implementation = this.implementationFactory.createNotificationImplementation();
        implementation.setComponentTypeName(componentTypeName);
        implementation.setImplementationType(implementationType);
        while (reader.hasNext() && (reader.next() != 2 || !IMPLEMENTATION_NOTIFICATION.equals(reader.getName()))) {
        }
        ComponentType componentType = new DefaultAssemblyFactory().createComponentType();
        componentType.setURI(componentTypeName + ".componentType");
        componentType.setUnresolved(true);
        implementation.setComponentType(componentType);
        return implementation;
    }

    @Override
    public void resolve(NotificationImplementationImpl impl, ModelResolver resolver) throws ContributionResolveException {
        ComponentType componentType = resolver.resolveModel(ComponentType.class, impl.getComponentType());
        if (componentType.isUnresolved()) {
            throw new ContributionResolveException("ComponentType still unresolved");
        }
        impl.setComponentType(componentType);
        impl.setUnresolved(false);
    }

    @Override
    public void write(NotificationImplementationImpl model, XMLStreamWriter outputSource) throws ContributionWriteException, XMLStreamException {
    }
}

