/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.node.webapp;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletMappingException;
import org.apache.tuscany.sca.implementation.node.launcher.NodeImplementationLauncherUtil;
import org.apache.tuscany.sca.implementation.node.webapp.NodeWebAppRequestDispatcher;
import org.apache.tuscany.sca.node.SCAClient;
import org.apache.tuscany.sca.node.SCANode;
import org.apache.tuscany.sca.node.SCANodeFactory;

public class NodeWebAppServletHost
implements ServletHost,
Filter {
    private static final Logger logger = Logger.getLogger(NodeWebAppServletHost.class.getName());
    private static final NodeWebAppServletHost servletHost = new NodeWebAppServletHost();
    private Map<String, Servlet> servlets = new HashMap<String, Servlet>();
    private SCANode node;
    private String contextPath = "/";
    private int defaultPort = 8080;

    private NodeWebAppServletHost() {
    }

    public static NodeWebAppServletHost servletHost() {
        return servletHost;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletConfig servletConfig = NodeWebAppServletHost.servletConfig(filterConfig);
        ServletContext servletContext = servletConfig.getServletContext();
        this.contextPath = NodeWebAppServletHost.contextPath(servletContext);
        String nodeName = this.contextPath;
        if (nodeName.startsWith("/")) {
            nodeName = nodeName.substring(1);
        }
        if (nodeName.endsWith("/")) {
            nodeName = nodeName.substring(0, nodeName.length() - 1);
        }
        String nodeConfiguration = NodeImplementationLauncherUtil.nodeConfigurationURI(nodeName);
        SCANodeFactory nodeFactory = SCANodeFactory.newInstance();
        this.node = nodeFactory.createSCANodeFromURL(nodeConfiguration);
        ServletHostExtensionPoint servletHosts = NodeWebAppServletHost.servletHosts(this.node);
        servletHosts.getServletHosts().clear();
        servletHosts.addServletHost(servletHost);
        servletContext.setAttribute(SCAClient.class.getName(), (Object)this.node);
        this.node.start();
        for (Servlet servlet : this.servlets.values()) {
            servlet.init(servletConfig);
        }
    }

    public void addServletMapping(String suri, Servlet servlet) throws ServletMappingException {
        URI pathURI = URI.create(suri);
        if (!(suri = pathURI.getPath()).startsWith("/")) {
            suri = '/' + suri;
        }
        if (!suri.startsWith(this.contextPath)) {
            suri = this.contextPath + suri;
        }
        this.servlets.put(suri, servlet);
        logger.info("Added Servlet mapping: " + suri);
    }

    public Servlet removeServletMapping(String suri) throws ServletMappingException {
        URI pathURI = URI.create(suri);
        if (!(suri = pathURI.getPath()).startsWith("/")) {
            suri = '/' + suri;
        }
        if (!suri.startsWith(this.contextPath)) {
            suri = this.contextPath + suri;
        }
        return this.servlets.remove(suri);
    }

    public Servlet getServletMapping(String suri) throws ServletMappingException {
        if (!suri.startsWith("/")) {
            suri = '/' + suri;
        }
        if (!suri.startsWith(this.contextPath)) {
            suri = this.contextPath + suri;
        }
        Servlet servlet = this.servlets.get(suri);
        return servlet;
    }

    public URL getURLMapping(String suri) throws ServletMappingException {
        URL url;
        String host;
        int portNumber;
        URI uri = URI.create(suri);
        String scheme = uri.getScheme();
        if (scheme == null) {
            scheme = "http";
        }
        if ((portNumber = uri.getPort()) == -1) {
            portNumber = this.defaultPort;
        }
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            host = "localhost";
        }
        String path = uri.getPath();
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (this.contextPath != null && !path.startsWith(this.contextPath)) {
            path = this.contextPath + path;
        }
        try {
            url = new URL(scheme, host, portNumber, path);
        }
        catch (MalformedURLException e) {
            throw new ServletMappingException(e);
        }
        return url;
    }

    public RequestDispatcher getRequestDispatcher(String suri) throws ServletMappingException {
        Servlet servlet;
        if (!suri.startsWith("/")) {
            suri = '/' + suri;
        }
        if ((servlet = this.servlets.get(suri = this.contextPath + suri)) != null) {
            return new NodeWebAppRequestDispatcher(suri, servlet);
        }
        for (Map.Entry<String, Servlet> entry : this.servlets.entrySet()) {
            String servletPath = entry.getKey();
            if (!servletPath.endsWith("*")) continue;
            if (suri.startsWith(servletPath = servletPath.substring(0, servletPath.length() - 1))) {
                return new NodeWebAppRequestDispatcher(entry.getKey(), entry.getValue());
            }
            if (!(suri + "/").startsWith(servletPath)) continue;
            return new NodeWebAppRequestDispatcher(entry.getKey(), entry.getValue());
        }
        return null;
    }

    public void destroy() {
        for (Servlet servlet : this.servlets.values()) {
            servlet.destroy();
        }
        if (this.node != null) {
            this.node.stop();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        RequestDispatcher dispatcher;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String path = httpRequest.getPathInfo();
        if (path == null) {
            path = httpRequest.getServletPath();
        }
        if (path == null) {
            path = "/";
        }
        if ((dispatcher = this.getRequestDispatcher(path)) != null) {
            dispatcher.forward(request, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void setDefaultPort(int port) {
        this.defaultPort = port;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String path) {
    }

    private static String contextPath(ServletContext context) {
        String contextPath;
        block2: {
            contextPath = "/";
            try {
                Method m = context.getClass().getMethod("getContextPath", new Class[0]);
                contextPath = (String)m.invoke((Object)context, new Object[0]);
            }
            catch (Exception e) {
                contextPath = context.getInitParameter("contextPath");
                if (contextPath != null) break block2;
                logger.warning("Servlet level is: " + context.getMajorVersion() + "." + context.getMinorVersion());
                throw new IllegalStateException("'contextPath' init parameter must be set for pre-2.5 servlet container");
            }
        }
        logger.info("ContextPath: " + contextPath);
        return contextPath;
    }

    private static ServletHostExtensionPoint servletHosts(SCANode node) {
        ExtensionPointRegistry registry;
        try {
            registry = (ExtensionPointRegistry)node.getClass().getMethod("getExtensionPointRegistry", new Class[0]).invoke((Object)node, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ServletHostExtensionPoint servletHosts = registry.getExtensionPoint(ServletHostExtensionPoint.class);
        return servletHosts;
    }

    private static ServletConfig servletConfig(final FilterConfig filterConfig) {
        ServletConfig servletConfig = new ServletConfig(){

            public String getInitParameter(String name) {
                return filterConfig.getInitParameter(name);
            }

            public Enumeration getInitParameterNames() {
                return filterConfig.getInitParameterNames();
            }

            public ServletContext getServletContext() {
                return filterConfig.getServletContext();
            }

            public String getServletName() {
                return filterConfig.getFilterName();
            }
        };
        return servletConfig;
    }
}

