/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.node.launcher;

import org.apache.tuscany.sca.node.SCAClient;
import org.apache.tuscany.sca.node.SCAContribution;
import org.apache.tuscany.sca.node.SCANode;
import org.apache.tuscany.sca.node.SCANodeFactory;
import org.osoa.sca.CallableReference;
import org.osoa.sca.ServiceReference;

public class NodeImplementationLauncherBootstrap {
    private SCANode node;

    public NodeImplementationLauncherBootstrap(String configurationURI) throws Exception {
        SCANodeFactory nodeFactory = SCANodeFactory.newInstance();
        this.node = new NodeFacade(nodeFactory.createSCANodeFromURL(configurationURI));
    }

    public NodeImplementationLauncherBootstrap(String compositeURI, ClassLoader contributionClassLoader) throws Exception {
        SCANodeFactory nodeFactory = SCANodeFactory.newInstance();
        this.node = new NodeFacade(nodeFactory.createSCANodeFromClassLoader(compositeURI, contributionClassLoader));
    }

    public NodeImplementationLauncherBootstrap(String compositeURI, String[] uris, String[] locations) throws Exception {
        SCANodeFactory nodeFactory = SCANodeFactory.newInstance();
        SCAContribution[] contributions = new SCAContribution[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            contributions[i] = new SCAContribution(uris[i], locations[i]);
        }
        this.node = new NodeFacade(nodeFactory.createSCANode(compositeURI, contributions));
    }

    public NodeImplementationLauncherBootstrap(String compositeURI, String compositeContent, String[] uris, String[] locations) throws Exception {
        SCANodeFactory nodeFactory = SCANodeFactory.newInstance();
        SCAContribution[] contributions = new SCAContribution[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            contributions[i] = new SCAContribution(uris[i], locations[i]);
        }
        this.node = new NodeFacade(nodeFactory.createSCANode(compositeURI, compositeContent, contributions));
    }

    public SCANode getNode() {
        return this.node;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeFacade
    implements SCANode,
    SCAClient {
        private ClassLoader threadContextClassLoader;
        private ClassLoader runtimeClassLoader = Thread.currentThread().getContextClassLoader();
        private SCANode delegate;

        private NodeFacade(SCANode delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start() {
            this.threadContextClassLoader = Thread.currentThread().getContextClassLoader();
            boolean started = false;
            try {
                Thread.currentThread().setContextClassLoader(this.runtimeClassLoader);
                this.delegate.start();
                started = true;
            }
            finally {
                if (!started) {
                    Thread.currentThread().setContextClassLoader(this.threadContextClassLoader);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            try {
                Thread.currentThread().setContextClassLoader(this.runtimeClassLoader);
                this.delegate.stop();
            }
            finally {
                Thread.currentThread().setContextClassLoader(this.threadContextClassLoader);
            }
        }

        @Override
        public <B, R extends CallableReference<B>> R cast(B target) throws IllegalArgumentException {
            return ((SCAClient)((Object)this.delegate)).cast(target);
        }

        @Override
        public <B> B getService(Class<B> businessInterface, String serviceName) {
            return ((SCAClient)((Object)this.delegate)).getService(businessInterface, serviceName);
        }

        @Override
        public <B> ServiceReference<B> getServiceReference(Class<B> businessInterface, String referenceName) {
            return ((SCAClient)((Object)this.delegate)).getServiceReference(businessInterface, referenceName);
        }
    }
}

