/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.jee.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.implementation.jee.JEEImplementation;
import org.apache.tuscany.sca.implementation.jee.JEEImplementationFactory;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JEEImplementationProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<JEEImplementation> {
    private static final QName IMPLEMENTATION_JEE = new QName("http://www.osoa.org/xmlns/sca/1.0", "implementation.jee");
    private AssemblyFactory assemblyFactory;
    private JEEImplementationFactory implementationFactory;
    private Monitor monitor;

    public JEEImplementationProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.implementationFactory = modelFactories.getFactory(JEEImplementationFactory.class);
        this.monitor = monitor;
    }

    @Override
    public QName getArtifactType() {
        return IMPLEMENTATION_JEE;
    }

    @Override
    public Class<JEEImplementation> getModelType() {
        return JEEImplementation.class;
    }

    @Override
    public JEEImplementation read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        JEEImplementation implementation = this.implementationFactory.createJEEImplementation();
        implementation.setUnresolved(true);
        String archive = this.getString(reader, "archive");
        if (archive != null) {
            implementation.setArchive(archive);
            implementation.setURI(archive);
        }
        while (reader.hasNext() && (reader.next() != 2 || !IMPLEMENTATION_JEE.equals(reader.getName()))) {
        }
        return implementation;
    }

    @Override
    public void resolve(JEEImplementation implementation, ModelResolver resolver) throws ContributionResolveException {
        String uri = implementation.getURI();
        if (uri != null) {
            ComponentType componentType = this.assemblyFactory.createComponentType();
            componentType.setURI(uri + ".componentType");
            componentType = resolver.resolveModel(ComponentType.class, componentType);
            if (!componentType.isUnresolved()) {
                implementation.getServices().addAll(componentType.getServices());
                implementation.getReferences().addAll(componentType.getReferences());
                implementation.getProperties().addAll(componentType.getProperties());
            }
        }
        implementation.setUnresolved(false);
    }

    @Override
    public void write(JEEImplementation implementation, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        this.writeStart(writer, IMPLEMENTATION_JEE.getNamespaceURI(), IMPLEMENTATION_JEE.getLocalPart(), new BaseStAXArtifactProcessor.XAttr("archive", implementation.getArchive()));
        this.writeEnd(writer);
    }
}

