/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.invocation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tuscany.sca.core.context.InstanceWrapper;
import org.apache.tuscany.sca.core.scope.Scope;
import org.apache.tuscany.sca.core.scope.ScopeContainer;
import org.apache.tuscany.sca.core.scope.ScopedRuntimeComponent;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.interfacedef.ConversationSequence;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceUtil;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.EndpointReference;
import org.apache.tuscany.sca.runtime.ReferenceParameters;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.osoa.sca.ServiceRuntimeException;

public class JavaImplementationInvoker
implements Invoker,
DataExchangeSemantics {
    protected Operation operation;
    protected Method method;
    protected boolean allowsPBR;
    protected final ScopeContainer scopeContainer;

    public JavaImplementationInvoker(Operation operation, Method method, RuntimeComponent component) {
        assert (method != null) : "Operation method cannot be null";
        this.method = method;
        this.operation = operation;
        this.scopeContainer = ((ScopedRuntimeComponent)component).getScopeContainer();
        this.allowsPBR = ((JavaImplementation)component.getImplementation()).isAllowsPassByReference(method);
    }

    public JavaImplementationInvoker(Operation operation, RuntimeComponent component) {
        this.operation = operation;
        this.scopeContainer = ((ScopedRuntimeComponent)component).getScopeContainer();
    }

    public Message invoke(Message msg) {
        Operation op = msg.getOperation();
        if (op == null) {
            op = this.operation;
        }
        ConversationSequence sequence = op.getConversationSequence();
        Object payload = msg.getBody();
        Object contextId = null;
        EndpointReference from = msg.getFrom();
        ReferenceParameters parameters = null;
        if (from != null) {
            parameters = from.getReferenceParameters();
        }
        if (this.scopeContainer != null) {
            Scope scope = this.scopeContainer.getScope();
            if (scope == Scope.REQUEST) {
                contextId = Thread.currentThread();
            } else if (scope == Scope.CONVERSATION && parameters != null) {
                contextId = parameters.getConversationID();
            }
        }
        try {
            InstanceWrapper wrapper = this.scopeContainer.getWrapper(contextId);
            boolean removeTemporaryConversationalComponentAfterCall = false;
            if (parameters != null && contextId == null && parameters.getConversationID() != null) {
                contextId = parameters.getConversationID();
                removeTemporaryConversationalComponentAfterCall = true;
            }
            Object instance = wrapper.getInstance();
            Method imethod = this.method;
            if (imethod == null || !imethod.getDeclaringClass().isInstance(instance)) {
                try {
                    imethod = JavaInterfaceUtil.findMethod(instance.getClass(), this.operation);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("Callback object does not provide method " + e.getMessage());
                }
            }
            Object ret = payload != null && !payload.getClass().isArray() ? imethod.invoke(instance, payload) : imethod.invoke(instance, (Object[])payload);
            this.scopeContainer.returnWrapper(wrapper, contextId);
            if (sequence == ConversationSequence.CONVERSATION_END || removeTemporaryConversationalComponentAfterCall) {
                this.scopeContainer.remove(contextId);
                parameters.setConversationID(null);
            }
            msg.setBody(ret);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            boolean isChecked = false;
            for (DataType d : this.operation.getFaultTypes()) {
                if (!d.getPhysical().isInstance(cause)) continue;
                isChecked = true;
                msg.setFaultBody(cause);
                break;
            }
            if (sequence != ConversationSequence.CONVERSATION_NONE) {
                try {
                    if (!isChecked && contextId != null) {
                        this.scopeContainer.remove(contextId);
                        parameters.setConversationID(null);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (!isChecked) {
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new ServiceRuntimeException(cause.getMessage(), cause);
            }
        }
        catch (Exception e) {
            msg.setFaultBody(e);
        }
        return msg;
    }

    public boolean allowsPassByReference() {
        return this.allowsPBR;
    }
}

