/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Logger;
import javax.jws.WebService;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.impl.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.introspect.impl.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.IllegalCallbackReferenceException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.JavaIntrospectionHelper;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.osoa.sca.CallableReference;
import org.osoa.sca.annotations.Callback;
import org.osoa.sca.annotations.Remotable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProcessor
extends BaseJavaClassVisitor {
    private static final Logger logger = Logger.getLogger(ServiceProcessor.class.getName());
    private JavaInterfaceFactory javaFactory;

    public ServiceProcessor(AssemblyFactory assemblyFactory, JavaInterfaceFactory javaFactory) {
        super(assemblyFactory);
        this.javaFactory = javaFactory;
    }

    @Override
    public <T> void visitClass(Class<T> clazz, JavaImplementation type) throws IntrospectionException {
        org.osoa.sca.annotations.Service annotation = clazz.getAnnotation(org.osoa.sca.annotations.Service.class);
        if (annotation == null) {
            Set<Class> interfaces = JavaIntrospectionHelper.getAllInterfaces(clazz);
            for (Class interfaze : interfaces) {
                Service service;
                if (!interfaze.isAnnotationPresent(Remotable.class) && !interfaze.isAnnotationPresent(WebService.class) && !interfaze.isAnnotationPresent(Callback.class)) continue;
                try {
                    service = this.createService(interfaze);
                }
                catch (InvalidInterfaceException e) {
                    throw new IntrospectionException(e);
                }
                type.getServices().add(service);
            }
            return;
        }
        Class<?>[] interfaces = annotation.interfaces();
        if (interfaces.length == 0) {
            Class<?> interfaze = annotation.value();
            if (Void.class.equals(interfaze)) {
                logger.warning("Ignoring @Service annotation.  No interfaces specified. class = " + clazz.getName());
            } else {
                interfaces = new Class[]{interfaze};
            }
        }
        for (Class<?> interfaze : interfaces) {
            try {
                Service service = this.createService(interfaze);
                type.getServices().add(service);
            }
            catch (InvalidInterfaceException e) {
                throw new IntrospectionException(e);
            }
        }
    }

    @Override
    public void visitMethod(Method method, JavaImplementation type) throws IntrospectionException {
        Callback annotation = method.getAnnotation(Callback.class);
        if (annotation == null) {
            return;
        }
        if (Modifier.isPrivate(method.getModifiers())) {
            throw new IllegalCallbackReferenceException("Illegal annotation @Callback found on " + method, method);
        }
        if (method.getParameterTypes().length != 1) {
            throw new IllegalCallbackReferenceException("Setter must have one parameter", method);
        }
        JavaElementImpl element = new JavaElementImpl(method, 0);
        this.createCallback(type, element);
    }

    @Override
    public void visitField(Field field, JavaImplementation type) throws IntrospectionException {
        Callback annotation = field.getAnnotation(Callback.class);
        if (annotation == null) {
            return;
        }
        if (Modifier.isPrivate(field.getModifiers())) {
            throw new IllegalCallbackReferenceException("Illegal annotation @Callback found on " + field, field);
        }
        JavaElementImpl element = new JavaElementImpl(field);
        this.createCallback(type, element);
    }

    private void createCallback(JavaImplementation type, JavaElementImpl element) throws IllegalCallbackReferenceException {
        Service callbackService = null;
        Class<?> callbackClass = element.getType();
        Type genericType = element.getGenericType();
        Class<?> baseType = callbackClass;
        if (CallableReference.class.isAssignableFrom(baseType)) {
            baseType = JavaIntrospectionHelper.getBusinessInterface(baseType, genericType);
        }
        for (Service service : type.getServices()) {
            JavaInterface javaInterface = (JavaInterface)service.getInterfaceContract().getCallbackInterface();
            if (javaInterface == null || baseType != javaInterface.getJavaClass()) continue;
            callbackService = service;
        }
        if (callbackService == null) {
            throw new IllegalCallbackReferenceException("Callback type does not match a service callback interface: " + type.getName());
        }
        if (type.getCallbackMembers().get(baseType.getName()) == null) {
            type.getCallbackMembers().put(baseType.getName(), new ArrayList());
        }
        type.getCallbackMembers().get(baseType.getName()).add(element);
    }

    public Service createService(Class<?> interfaze) throws InvalidInterfaceException {
        Service service = this.assemblyFactory.createService();
        JavaInterfaceContract interfaceContract = this.javaFactory.createJavaInterfaceContract();
        service.setInterfaceContract(interfaceContract);
        service.setName(interfaze.getSimpleName());
        JavaInterface callInterface = this.javaFactory.createJavaInterface(interfaze);
        service.getInterfaceContract().setInterface(callInterface);
        if (callInterface.getCallbackClass() != null) {
            JavaInterface callbackInterface = this.javaFactory.createJavaInterface(callInterface.getCallbackClass());
            service.getInterfaceContract().setCallbackInterface(callbackInterface);
        }
        return service;
    }
}

