/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebService;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.impl.JavaConstructorImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaParameterImpl;
import org.apache.tuscany.sca.implementation.java.introspect.impl.AmbiguousConstructorException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.InvalidServiceType;
import org.apache.tuscany.sca.implementation.java.introspect.impl.JavaIntrospectionHelper;
import org.apache.tuscany.sca.implementation.java.introspect.impl.NoConstructorException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.Resource;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.util.JavaXMLMapper;
import org.osoa.sca.annotations.Callback;
import org.osoa.sca.annotations.Context;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Remotable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeuristicPojoProcessor
extends BaseJavaClassVisitor {
    private JavaInterfaceFactory javaFactory;

    public HeuristicPojoProcessor(AssemblyFactory assemblyFactory, JavaInterfaceFactory javaFactory) {
        super(assemblyFactory);
        this.javaFactory = javaFactory;
    }

    @Override
    public <T> void visitEnd(Class<T> clazz, JavaImplementation type) throws IntrospectionException {
        List<Service> services = type.getServices();
        if (services.isEmpty()) {
            Set<Class> interfaces = JavaIntrospectionHelper.getAllInterfaces(clazz);
            for (Class i : interfaces) {
                if (!i.isAnnotationPresent(Remotable.class) && !i.isAnnotationPresent(WebService.class)) continue;
                this.addService(type, i);
            }
            if (services.isEmpty()) {
                this.addService(type, clazz);
            }
        }
        Set<Method> methods = JavaIntrospectionHelper.getAllUniquePublicProtectedMethods(clazz, false);
        if (!type.getReferenceMembers().isEmpty() || !type.getPropertyMembers().isEmpty()) {
            this.evaluateConstructor(type, clazz);
            return;
        }
        this.calcPropRefs(methods, services, type, clazz);
        this.evaluateConstructor(type, clazz);
    }

    private void addService(JavaImplementation type, Class<?> clazz) throws IntrospectionException {
        try {
            Service service = this.createService(clazz);
            type.getServices().add(service);
        }
        catch (InvalidInterfaceException e) {
            throw new IntrospectionException(e);
        }
    }

    private boolean isPublicSetter(Method method) {
        return method.getParameterTypes().length == 1 && Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("set") && method.getReturnType() == Void.TYPE;
    }

    private boolean isProtectedSetter(Method method) {
        return method.getParameterTypes().length == 1 && Modifier.isProtected(method.getModifiers()) && method.getName().startsWith("set") && method.getReturnType() == Void.TYPE;
    }

    private <T> void calcPropRefs(Set<Method> methods, List<Service> services, JavaImplementation type, Class<T> clazz) throws IntrospectionException {
        String name;
        HashSet<String> setters = new HashSet<String>();
        HashSet<String> others = new HashSet<String>();
        for (Method method : methods) {
            Type genericType;
            if (!this.isPublicSetter(method)) continue;
            if (method.isAnnotationPresent(Callback.class) || method.isAnnotationPresent(Context.class)) {
                others.add(JavaIntrospectionHelper.toPropertyName(method.getName()));
                continue;
            }
            if (this.isInServiceInterface(method, services)) continue;
            String name2 = JavaIntrospectionHelper.toPropertyName(method.getName());
            setters.add(name2);
            if (type.getPropertyMembers().containsKey(name2) || type.getReferenceMembers().containsKey(name2)) continue;
            Class<?> param = method.getParameterTypes()[0];
            if (this.isReferenceType(param, genericType = method.getGenericParameterTypes()[0])) {
                type.getReferences().add(this.createReference(name2, param));
                type.getReferenceMembers().put(name2, new JavaElementImpl(method, 0));
                continue;
            }
            type.getProperties().add(this.createProperty(name2, param));
            type.getPropertyMembers().put(name2, new JavaElementImpl(method, 0));
        }
        for (Method method : methods) {
            if (!this.isProtectedSetter(method)) continue;
            if (method.isAnnotationPresent(Callback.class) || method.isAnnotationPresent(Context.class)) {
                others.add(JavaIntrospectionHelper.toPropertyName(method.getName()));
                continue;
            }
            Class<?> param = method.getParameterTypes()[0];
            name = JavaIntrospectionHelper.toPropertyName(method.getName());
            setters.add(name);
            if (this.isReferenceType(param, method.getGenericParameterTypes()[0])) {
                if (type.getReferenceMembers().containsKey(name)) continue;
                type.getReferences().add(this.createReference(name, param));
                type.getReferenceMembers().put(name, new JavaElementImpl(method, 0));
                continue;
            }
            if (type.getPropertyMembers().containsKey(name)) continue;
            type.getProperties().add(this.createProperty(name, param));
            type.getPropertyMembers().put(name, new JavaElementImpl(method, 0));
        }
        Set<Field> fields = JavaIntrospectionHelper.getAllPublicAndProtectedFields(clazz, false);
        for (Field field : fields) {
            if (field.isAnnotationPresent(Callback.class) || field.isAnnotationPresent(Context.class) || setters.contains(field.getName()) || others.contains(field.getName())) continue;
            name = field.getName();
            Class<?> paramType = field.getType();
            if (this.isReferenceType(paramType, field.getGenericType())) {
                if (type.getReferenceMembers().containsKey(name)) continue;
                type.getReferences().add(this.createReference(name, paramType));
                type.getReferenceMembers().put(name, new JavaElementImpl(field));
                continue;
            }
            if (type.getPropertyMembers().containsKey(name)) continue;
            type.getProperties().add(this.createProperty(name, paramType));
            type.getPropertyMembers().put(name, new JavaElementImpl(field));
        }
    }

    private <T> void evaluateConstructor(JavaImplementation type, Class<T> clazz) throws IntrospectionException {
        Constructor<?> constructor;
        JavaConstructorImpl definition = type.getConstructor();
        boolean explict = false;
        if (definition != null && definition.getConstructor().isAnnotationPresent(org.osoa.sca.annotations.Constructor.class)) {
            return;
        }
        if (definition != null) {
            explict = true;
            constructor = definition.getConstructor();
        } else {
            Constructor<?>[] constructors = clazz.getConstructors();
            if (constructors.length == 0) {
                throw new NoConstructorException("No public constructor for class");
            }
            if (constructors.length == 1) {
                constructor = constructors[0];
            } else {
                Constructor<?> selected = null;
                int sites = type.getPropertyMembers().size() + type.getReferenceMembers().size();
                for (Constructor<?> ctor : constructors) {
                    if (ctor.getParameterTypes().length == 0) {
                        selected = ctor;
                    }
                    if (ctor.getParameterTypes().length != sites) continue;
                }
                if (selected == null) {
                    throw new NoConstructorException();
                }
                constructor = selected;
                definition = type.getConstructors().get(selected);
                type.setConstructor(definition);
            }
            definition = type.getConstructors().get(constructor);
            type.setConstructor(definition);
        }
        JavaParameterImpl[] parameters = definition.getParameters();
        if (parameters.length == 0) {
            return;
        }
        Map<String, JavaElementImpl> props = type.getPropertyMembers();
        Map<String, JavaElementImpl> refs = type.getReferenceMembers();
        Annotation[][] annotations = constructor.getParameterAnnotations();
        if (!explict) {
            explict = this.injectionAnnotationsPresent(annotations);
        }
        if (explict) {
            for (int i = 0; i < parameters.length; ++i) {
                if (this.isAnnotated(parameters[i]) || this.findReferenceOrProperty(parameters[i], props, refs)) continue;
                throw new AmbiguousConstructorException(parameters[i].toString());
            }
        } else {
            if (!this.areUnique(parameters)) {
                throw new AmbiguousConstructorException("Cannot resolve non-unique parameter types, use @Constructor");
            }
            if (!this.calcPropRefUniqueness(props.values(), refs.values())) {
                throw new AmbiguousConstructorException("Cannot resolve non-unique parameter types, use @Constructor");
            }
            if (!props.isEmpty() || !refs.isEmpty()) {
                this.calcParamNames(parameters, props, refs);
            } else {
                this.heuristicParamNames(type, parameters);
            }
        }
    }

    private void calcParamNames(JavaParameterImpl[] parameters, Map<String, JavaElementImpl> props, Map<String, JavaElementImpl> refs) throws AmbiguousConstructorException {
        for (JavaParameterImpl param : parameters) {
            if (this.findReferenceOrProperty(param, props, refs)) continue;
            throw new AmbiguousConstructorException(param.getName());
        }
    }

    private void heuristicParamNames(JavaImplementation type, JavaParameterImpl[] parameters) throws IntrospectionException {
        for (JavaParameterImpl p : parameters) {
            String name = p.getType().getSimpleName().toLowerCase();
            if (this.isReferenceType(p.getType(), p.getGenericType())) {
                type.getReferences().add(this.createReference(name, p.getType()));
                p.setClassifer(org.osoa.sca.annotations.Reference.class);
                type.getReferenceMembers().put(name, p);
            } else {
                type.getProperties().add(this.createProperty(name, p.getType()));
                p.setClassifer(Property.class);
                type.getPropertyMembers().put(name, p);
            }
            p.setName(name);
        }
    }

    private static boolean areUnique(Class[] collection) {
        HashSet<Class> set = new HashSet<Class>(Arrays.asList(collection));
        return set.size() == collection.length;
    }

    private boolean calcPropRefUniqueness(Collection<JavaElementImpl> props, Collection<JavaElementImpl> refs) {
        Class[] classes = new Class[props.size() + refs.size()];
        int i = 0;
        for (JavaElementImpl property : props) {
            classes[i] = property.getType();
            ++i;
        }
        for (JavaElementImpl reference : refs) {
            classes[i] = reference.getType();
            ++i;
        }
        return HeuristicPojoProcessor.areUnique(classes);
    }

    private boolean findReferenceOrProperty(JavaParameterImpl parameter, Map<String, JavaElementImpl> props, Map<String, JavaElementImpl> refs) throws AmbiguousConstructorException {
        boolean found = false;
        if (!"".equals(parameter.getName())) {
            JavaElementImpl prop = props.get(parameter.getName());
            if (prop != null && prop.getType() == parameter.getType()) {
                parameter.setClassifer(Property.class);
                return true;
            }
            JavaElementImpl ref = refs.get(parameter.getName());
            if (ref != null && ref.getType() == parameter.getType()) {
                parameter.setClassifer(org.osoa.sca.annotations.Reference.class);
                return true;
            }
        }
        for (JavaElementImpl property : props.values()) {
            if (property.getType() != parameter.getType()) continue;
            if (found) {
                throw new AmbiguousConstructorException("Ambiguous property or reference for constructor type", (Member)((Object)parameter.getAnchor()));
            }
            parameter.setClassifer(Property.class);
            parameter.setName(property.getName());
            found = true;
        }
        for (JavaElementImpl reference : refs.values()) {
            if (reference.getType() != parameter.getType()) continue;
            if (found) {
                throw new AmbiguousConstructorException("Ambiguous property or reference for constructor type", (Member)((Object)parameter.getAnchor()));
            }
            parameter.setClassifer(org.osoa.sca.annotations.Reference.class);
            parameter.setName(reference.getName());
            found = true;
        }
        return found;
    }

    private boolean isReferenceType(Class<?> cls, Type genericType) {
        Class<?> baseType = JavaIntrospectionHelper.getBaseType(cls, genericType);
        return baseType.isInterface() && baseType.isAnnotationPresent(Remotable.class);
    }

    private boolean isInServiceInterface(Method operation, List<Service> services) {
        for (Service service : services) {
            Class<?> clazz;
            Interface interface1 = service.getInterfaceContract().getInterface();
            if (!(interface1 instanceof JavaInterface) || !this.isMethodMatched(clazz = ((JavaInterface)interface1).getJavaClass(), operation)) continue;
            return true;
        }
        return false;
    }

    private boolean isMethodMatched(Class<?> clazz, Method method) {
        Method[] methods;
        if (method.getDeclaringClass() == clazz) {
            return true;
        }
        for (Method m : methods = clazz.getMethods()) {
            if (!JavaIntrospectionHelper.exactMethodMatch(method, m)) continue;
            return true;
        }
        return false;
    }

    private org.apache.tuscany.sca.assembly.Property createProperty(String name, Class<?> paramType) {
        org.apache.tuscany.sca.assembly.Property property = this.assemblyFactory.createProperty();
        property.setName(name);
        property.setXSDType(JavaXMLMapper.getXMLType(paramType));
        return property;
    }

    private boolean isAnnotated(JavaParameterImpl parameter) {
        for (Annotation annotation : parameter.getAnnotations()) {
            Class<? extends Annotation> annotType = annotation.annotationType();
            if (!annotType.equals(Property.class) && !annotType.equals(org.osoa.sca.annotations.Reference.class) && !annotType.equals(Resource.class)) continue;
            return true;
        }
        return false;
    }

    public boolean areUnique(JavaParameterImpl[] parameters) {
        HashSet set = new HashSet(parameters.length);
        for (JavaParameterImpl p : parameters) {
            if (set.add(p.getType())) continue;
            return false;
        }
        return true;
    }

    public Reference createReference(String name, Class<?> paramType) throws IntrospectionException {
        Reference reference = this.assemblyFactory.createReference();
        reference.setName(name);
        JavaInterfaceContract interfaceContract = this.javaFactory.createJavaInterfaceContract();
        reference.setInterfaceContract(interfaceContract);
        try {
            JavaInterface callInterface = this.javaFactory.createJavaInterface(paramType);
            reference.getInterfaceContract().setInterface(callInterface);
            if (callInterface.getCallbackClass() != null) {
                JavaInterface callbackInterface = this.javaFactory.createJavaInterface(callInterface.getCallbackClass());
                reference.getInterfaceContract().setCallbackInterface(callbackInterface);
            }
            reference.setMultiplicity(Multiplicity.ZERO_ONE);
        }
        catch (InvalidInterfaceException e1) {
            throw new IntrospectionException(e1);
        }
        try {
            this.processCallback(paramType, reference);
        }
        catch (InvalidServiceType e) {
            throw new IntrospectionException(e);
        }
        return reference;
    }

    public Service createService(Class<?> interfaze) throws InvalidInterfaceException {
        Service service = this.assemblyFactory.createService();
        service.setName(interfaze.getSimpleName());
        JavaInterfaceContract interfaceContract = this.javaFactory.createJavaInterfaceContract();
        service.setInterfaceContract(interfaceContract);
        JavaInterface callInterface = this.javaFactory.createJavaInterface(interfaze);
        service.getInterfaceContract().setInterface(callInterface);
        if (callInterface.getCallbackClass() != null) {
            JavaInterface callbackInterface = this.javaFactory.createJavaInterface(callInterface.getCallbackClass());
            service.getInterfaceContract().setCallbackInterface(callbackInterface);
        }
        Interface javaInterface = service.getInterfaceContract().getInterface();
        javaInterface.setRemotable(interfaze.getAnnotation(Remotable.class) != null);
        service.getInterfaceContract().setInterface(javaInterface);
        return service;
    }

    public void processCallback(Class<?> interfaze, Contract contract) throws InvalidServiceType {
        Callback callback = interfaze.getAnnotation(Callback.class);
        if (callback != null && !Void.class.equals(callback.value())) {
            Class<?> callbackClass = callback.value();
            try {
                JavaInterface javaInterface = this.javaFactory.createJavaInterface(callbackClass);
                contract.getInterfaceContract().setCallbackInterface(javaInterface);
            }
            catch (InvalidInterfaceException e) {
                throw new InvalidServiceType("Invalid callback interface " + callbackClass, interfaze);
            }
        } else if (callback != null && Void.class.equals(callback.value())) {
            throw new InvalidServiceType("No callback interface specified on annotation", interfaze);
        }
    }

    public boolean injectionAnnotationsPresent(Annotation[][] annots) {
        Annotation[][] arr$ = annots;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = arr$[i$]) {
                Class<? extends Annotation> annotType = annotation.annotationType();
                if (!annotType.equals(Property.class) && !annotType.equals(org.osoa.sca.annotations.Reference.class) && !annotType.equals(Resource.class)) continue;
                return true;
            }
        }
        return false;
    }
}

